/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.ComposableStatsCalculator;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.cost.SymbolStatsEstimate;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class UnnestStatsRule
implements ComposableStatsCalculator.Rule<UnnestNode> {
    private static final int UPPER_BOUND_ROW_COUNT_FOR_ESTIMATION = 1;

    @Override
    public Pattern<UnnestNode> getPattern() {
        return Patterns.unnest();
    }

    @Override
    public Optional<PlanNodeStatsEstimate> calculate(UnnestNode node, StatsProvider statsProvider, Lookup lookup, Session session, TypeProvider types) {
        PlanNodeStatsEstimate sourceStats = statsProvider.getStats(node.getSource());
        PlanNodeStatsEstimate.Builder calculatedStats = PlanNodeStatsEstimate.builder();
        if (sourceStats.getOutputRowCount() > 1.0) {
            return Optional.empty();
        }
        calculatedStats.setOutputRowCount(sourceStats.getOutputRowCount());
        for (Symbol symbol : node.getReplicateSymbols()) {
            calculatedStats.addSymbolStatistics(symbol, sourceStats.getSymbolStatistics(symbol));
        }
        for (Map.Entry entry : node.getUnnestSymbols().entrySet()) {
            List unnestToSymbols = (List)entry.getValue();
            SymbolStatsEstimate stats = sourceStats.getSymbolStatistics((Symbol)entry.getKey());
            for (Symbol symbol : unnestToSymbols) {
                calculatedStats.addSymbolStatistics(symbol, SymbolStatsEstimate.builder().setAverageRowSize(stats.getAverageRowSize()).build());
            }
        }
        if (node.getOrdinalitySymbol().isPresent()) {
            calculatedStats.addSymbolStatistics(node.getOrdinalitySymbol().get(), SymbolStatsEstimate.builder().setLowValue(0.0).setNullsFraction(0.0).build());
        }
        return Optional.of(calculatedStats.build());
    }
}

