/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.CostProvider;
import com.facebook.presto.cost.PlanCostEstimate;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Memo;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.google.common.base.Verify;
import io.airlift.log.Logger;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CachingCostProvider
implements CostProvider {
    private static final Logger log = Logger.get(CachingCostProvider.class);
    private final CostCalculator costCalculator;
    private final StatsProvider statsProvider;
    private final Optional<Memo> memo;
    private final Session session;
    private final TypeProvider types;
    private final Map<PlanNode, PlanCostEstimate> cache = new IdentityHashMap<PlanNode, PlanCostEstimate>();

    public CachingCostProvider(CostCalculator costCalculator, StatsProvider statsProvider, Session session, TypeProvider types) {
        this(costCalculator, statsProvider, Optional.empty(), session, types);
    }

    public CachingCostProvider(CostCalculator costCalculator, StatsProvider statsProvider, Optional<Memo> memo, Session session, TypeProvider types) {
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        this.statsProvider = Objects.requireNonNull(statsProvider, "statsProvider is null");
        this.memo = Objects.requireNonNull(memo, "memo is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.types = Objects.requireNonNull(types, "types is null");
    }

    @Override
    public PlanCostEstimate getCost(PlanNode node) {
        if (!SystemSessionProperties.isEnableStatsCalculator(this.session)) {
            return PlanCostEstimate.unknown();
        }
        Objects.requireNonNull(node, "node is null");
        try {
            if (node instanceof GroupReference) {
                return this.getGroupCost((GroupReference)node);
            }
            PlanCostEstimate cost = this.cache.get(node);
            if (cost != null) {
                return cost;
            }
            cost = this.calculateCost(node);
            Verify.verify((this.cache.put(node, cost) == null ? 1 : 0) != 0, (String)"Cost already set", (Object[])new Object[0]);
            return cost;
        }
        catch (RuntimeException e) {
            if (SystemSessionProperties.isIgnoreStatsCalculatorFailures(this.session)) {
                log.error((Throwable)e, "Error occurred when computing cost for query %s", new Object[]{this.session.getQueryId()});
                return PlanCostEstimate.unknown();
            }
            throw e;
        }
    }

    private PlanCostEstimate getGroupCost(GroupReference groupReference) {
        int group = groupReference.getGroupId();
        Memo memo = this.memo.orElseThrow(() -> new IllegalStateException("CachingCostProvider without memo cannot handle GroupReferences"));
        Optional<PlanCostEstimate> knownCost = memo.getCost(group);
        if (knownCost.isPresent()) {
            return knownCost.get();
        }
        PlanCostEstimate cost = this.calculateCost(memo.getNode(group));
        Verify.verify((!memo.getCost(group).isPresent() ? 1 : 0) != 0, (String)"Group cost already set", (Object[])new Object[0]);
        memo.storeCost(group, cost);
        return cost;
    }

    private PlanCostEstimate calculateCost(PlanNode node) {
        return this.costCalculator.calculateCost(node, this.statsProvider, this, this.session, this.types);
    }
}

