/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.relational.Expressions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;

public final class SymbolToChannelTranslator {
    private SymbolToChannelTranslator() {
    }

    public static RowExpression translate(RowExpression expression, Map<Symbol, Integer> layout) {
        return (RowExpression)expression.accept((RowExpressionVisitor)new Visitor(), layout);
    }

    private static class Visitor
    implements RowExpressionVisitor<RowExpression, Map<Symbol, Integer>> {
        private Visitor() {
        }

        public RowExpression visitInputReference(InputReferenceExpression input, Map<Symbol, Integer> layout) {
            throw new UnsupportedOperationException("encountered already-translated symbols");
        }

        public RowExpression visitCall(CallExpression call, Map<Symbol, Integer> layout) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            call.getArguments().forEach(argument -> arguments.add(argument.accept((RowExpressionVisitor)this, (Object)layout)));
            return Expressions.call(call.getDisplayName(), call.getFunctionHandle(), call.getType(), (List<RowExpression>)arguments.build());
        }

        public RowExpression visitConstant(ConstantExpression literal, Map<Symbol, Integer> layout) {
            return literal;
        }

        public RowExpression visitLambda(LambdaDefinitionExpression lambda, Map<Symbol, Integer> layout) {
            return new LambdaDefinitionExpression(lambda.getArgumentTypes(), lambda.getArguments(), (RowExpression)lambda.getBody().accept((RowExpressionVisitor)this, layout));
        }

        public RowExpression visitVariableReference(VariableReferenceExpression reference, Map<Symbol, Integer> layout) {
            Symbol symbol = new Symbol(reference.getName());
            if (layout.containsKey(symbol)) {
                return Expressions.field(layout.get(symbol), reference.getType());
            }
            return reference;
        }

        public RowExpression visitSpecialForm(SpecialFormExpression specialForm, Map<Symbol, Integer> layout) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            specialForm.getArguments().forEach(argument -> arguments.add(argument.accept((RowExpressionVisitor)this, (Object)layout)));
            return new SpecialFormExpression(specialForm.getForm(), specialForm.getType(), (List)arguments.build());
        }
    }
}

