/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.relational.DeterminismEvaluator;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class LogicalRowExpressions {
    public static final ConstantExpression TRUE = new ConstantExpression((Object)true, (Type)BooleanType.BOOLEAN);
    public static final ConstantExpression FALSE = new ConstantExpression((Object)false, (Type)BooleanType.BOOLEAN);
    private final DeterminismEvaluator determinismEvaluator;

    public LogicalRowExpressions(FunctionManager functionManager) {
        this.determinismEvaluator = new DeterminismEvaluator(Objects.requireNonNull(functionManager, "functionManager is null"));
    }

    public static List<RowExpression> extractConjuncts(RowExpression expression) {
        return LogicalRowExpressions.extractPredicates(SpecialFormExpression.Form.AND, expression);
    }

    public static List<RowExpression> extractDisjuncts(RowExpression expression) {
        return LogicalRowExpressions.extractPredicates(SpecialFormExpression.Form.OR, expression);
    }

    public static List<RowExpression> extractPredicates(RowExpression expression) {
        SpecialFormExpression.Form form;
        if (expression instanceof SpecialFormExpression && ((form = ((SpecialFormExpression)expression).getForm()) == SpecialFormExpression.Form.AND || form == SpecialFormExpression.Form.OR)) {
            return LogicalRowExpressions.extractPredicates(form, expression);
        }
        return ImmutableList.of((Object)expression);
    }

    public static List<RowExpression> extractPredicates(SpecialFormExpression.Form form, RowExpression expression) {
        if (expression instanceof SpecialFormExpression && ((SpecialFormExpression)expression).getForm() == form) {
            SpecialFormExpression specialFormExpression = (SpecialFormExpression)expression;
            Verify.verify((specialFormExpression.getArguments().size() == 2 ? 1 : 0) != 0, (String)"logical binary expression requires exactly 2 operands", (Object[])new Object[0]);
            return ImmutableList.builder().addAll(LogicalRowExpressions.extractPredicates(form, (RowExpression)specialFormExpression.getArguments().get(0))).addAll(LogicalRowExpressions.extractPredicates(form, (RowExpression)specialFormExpression.getArguments().get(1))).build();
        }
        return ImmutableList.of((Object)expression);
    }

    public static RowExpression and(RowExpression ... expressions) {
        return LogicalRowExpressions.and(Arrays.asList(expressions));
    }

    public static RowExpression and(Collection<RowExpression> expressions) {
        return LogicalRowExpressions.binaryExpression(SpecialFormExpression.Form.AND, expressions);
    }

    public static RowExpression or(RowExpression ... expressions) {
        return LogicalRowExpressions.or(Arrays.asList(expressions));
    }

    public static RowExpression or(Collection<RowExpression> expressions) {
        return LogicalRowExpressions.binaryExpression(SpecialFormExpression.Form.OR, expressions);
    }

    public static RowExpression binaryExpression(SpecialFormExpression.Form form, Collection<RowExpression> expressions) {
        Objects.requireNonNull(form, "operator is null");
        Objects.requireNonNull(expressions, "expressions is null");
        if (expressions.isEmpty()) {
            switch (form) {
                case AND: {
                    return TRUE;
                }
                case OR: {
                    return FALSE;
                }
            }
            throw new IllegalArgumentException("Unsupported binary expression operator");
        }
        ArrayDeque<Object> queue = new ArrayDeque<RowExpression>(expressions);
        while (queue.size() > 1) {
            ArrayDeque<Object> buffer = new ArrayDeque<Object>();
            while (queue.size() >= 2) {
                ImmutableList arguments = ImmutableList.of(queue.remove(), queue.remove());
                buffer.add(new SpecialFormExpression(form, (Type)BooleanType.BOOLEAN, (List)arguments));
            }
            if (!queue.isEmpty()) {
                buffer.add(queue.remove());
            }
            queue = buffer;
        }
        return (RowExpression)queue.remove();
    }

    public RowExpression combinePredicates(SpecialFormExpression.Form form, RowExpression ... expressions) {
        return this.combinePredicates(form, Arrays.asList(expressions));
    }

    public RowExpression combinePredicates(SpecialFormExpression.Form form, Collection<RowExpression> expressions) {
        if (form == SpecialFormExpression.Form.AND) {
            return this.combineConjuncts(expressions);
        }
        return this.combineDisjuncts(expressions);
    }

    public RowExpression combineConjuncts(RowExpression ... expressions) {
        return this.combineConjuncts(Arrays.asList(expressions));
    }

    public RowExpression combineConjuncts(Collection<RowExpression> expressions) {
        Objects.requireNonNull(expressions, "expressions is null");
        List<RowExpression> conjuncts = expressions.stream().flatMap(e -> LogicalRowExpressions.extractConjuncts(e).stream()).filter(e -> !e.equals((Object)TRUE)).collect(Collectors.toList());
        conjuncts = this.removeDuplicates(conjuncts);
        if (conjuncts.contains(FALSE)) {
            return FALSE;
        }
        return LogicalRowExpressions.and(conjuncts);
    }

    public RowExpression combineDisjuncts(RowExpression ... expressions) {
        return this.combineDisjuncts(Arrays.asList(expressions));
    }

    public RowExpression combineDisjuncts(Collection<RowExpression> expressions) {
        return this.combineDisjunctsWithDefault(expressions, (RowExpression)FALSE);
    }

    public RowExpression combineDisjunctsWithDefault(Collection<RowExpression> expressions, RowExpression emptyDefault) {
        Objects.requireNonNull(expressions, "expressions is null");
        List<RowExpression> disjuncts = expressions.stream().flatMap(e -> LogicalRowExpressions.extractDisjuncts(e).stream()).filter(e -> !e.equals((Object)FALSE)).collect(Collectors.toList());
        disjuncts = this.removeDuplicates(disjuncts);
        if (disjuncts.contains(TRUE)) {
            return TRUE;
        }
        return disjuncts.isEmpty() ? emptyDefault : LogicalRowExpressions.or(disjuncts);
    }

    public RowExpression filterDeterministicConjuncts(RowExpression expression) {
        return this.filterConjuncts(expression, this.determinismEvaluator::isDeterministic);
    }

    public RowExpression filterNonDeterministicConjuncts(RowExpression expression) {
        return this.filterConjuncts(expression, (Predicate<RowExpression>)Predicates.not(this.determinismEvaluator::isDeterministic));
    }

    public RowExpression filterConjuncts(RowExpression expression, Predicate<RowExpression> predicate) {
        List conjuncts = (List)LogicalRowExpressions.extractConjuncts(expression).stream().filter(predicate).collect(ImmutableList.toImmutableList());
        return this.combineConjuncts(conjuncts);
    }

    private List<RowExpression> removeDuplicates(List<RowExpression> expressions) {
        HashSet<RowExpression> seen = new HashSet<RowExpression>();
        ImmutableList.Builder result = ImmutableList.builder();
        for (RowExpression expression : expressions) {
            if (!this.determinismEvaluator.isDeterministic(expression)) {
                result.add((Object)expression);
                continue;
            }
            if (seen.contains(expression)) continue;
            result.add((Object)expression);
            seen.add(expression);
        }
        return result.build();
    }
}

