/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.planPrinter;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class RowExpressionFormatter {
    private final ConnectorSession session;

    public RowExpressionFormatter(ConnectorSession session) {
        this.session = Objects.requireNonNull(session, "session is null");
    }

    public String formatRowExpression(RowExpression expression) {
        return (String)expression.accept((RowExpressionVisitor)new Formatter(), null);
    }

    public List<String> formatRowExpressions(List<RowExpression> rowExpressions) {
        return rowExpressions.stream().map(this::formatRowExpression).collect(Collectors.toList());
    }

    public class Formatter
    implements RowExpressionVisitor<String, Void> {
        public String visitCall(CallExpression node, Void context) {
            return node.getDisplayName() + "(" + String.join((CharSequence)", ", RowExpressionFormatter.this.formatRowExpressions(node.getArguments())) + ")";
        }

        public String visitSpecialForm(SpecialFormExpression node, Void context) {
            return node.getForm().name() + "(" + String.join((CharSequence)", ", RowExpressionFormatter.this.formatRowExpressions(node.getArguments())) + ")";
        }

        public String visitInputReference(InputReferenceExpression node, Void context) {
            return node.toString();
        }

        public String visitLambda(LambdaDefinitionExpression node, Void context) {
            return "(" + String.join((CharSequence)", ", node.getArguments()) + ") -> " + RowExpressionFormatter.this.formatRowExpression(node.getBody());
        }

        public String visitVariableReference(VariableReferenceExpression node, Void context) {
            return node.getName();
        }

        public String visitConstant(ConstantExpression node, Void context) {
            Object value = LiteralInterpreter.evaluate(RowExpressionFormatter.this.session, node);
            if (value == null) {
                return String.valueOf(null);
            }
            Type type = node.getType();
            if (node.getType().getJavaType() == Block.class) {
                Block block = (Block)value;
                return String.format("[Block: position count: %s; size: %s bytes]", block.getPositionCount(), block.getRetainedSizeInBytes());
            }
            return type.getDisplayName().toUpperCase() + " " + value.toString();
        }
    }
}

