/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.planPrinter;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.PlanCostEstimate;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.StageStats;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.operator.StageExecutionDescriptor;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.Marker;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.InterpretedFunctionInvoker;
import com.facebook.presto.sql.planner.OrderingScheme;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExceptNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.IntersectNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.MetadataDeleteNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.StatisticAggregations;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.planner.planPrinter.JsonRenderer;
import com.facebook.presto.sql.planner.planPrinter.NodeRepresentation;
import com.facebook.presto.sql.planner.planPrinter.PlanNodeStats;
import com.facebook.presto.sql.planner.planPrinter.PlanNodeStatsSummarizer;
import com.facebook.presto.sql.planner.planPrinter.PlanRepresentation;
import com.facebook.presto.sql.planner.planPrinter.RowExpressionFormatter;
import com.facebook.presto.sql.planner.planPrinter.TextRenderer;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.util.GraphvizPrinter;
import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import io.airlift.slice.Slice;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PlanPrinter {
    private final PlanRepresentation representation;
    private final FunctionManager functionManager;
    private final RowExpressionFormatter formatter;

    private PlanPrinter(PlanNode planRoot, TypeProvider types, Optional<StageExecutionDescriptor> stageExecutionStrategy, FunctionManager functionManager, StatsAndCosts estimatedStatsAndCosts, Session session, Optional<Map<PlanNodeId, PlanNodeStats>> stats) {
        Objects.requireNonNull(planRoot, "planRoot is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(functionManager, "functionManager is null");
        Objects.requireNonNull(estimatedStatsAndCosts, "estimatedStatsAndCosts is null");
        Objects.requireNonNull(stats, "stats is null");
        this.functionManager = functionManager;
        Optional<Duration> totalCpuTime = stats.map(s -> new Duration((double)s.values().stream().mapToLong(planNode -> planNode.getPlanNodeScheduledTime().toMillis()).sum(), TimeUnit.MILLISECONDS));
        Optional<Duration> totalScheduledTime = stats.map(s -> new Duration((double)s.values().stream().mapToLong(planNode -> planNode.getPlanNodeCpuTime().toMillis()).sum(), TimeUnit.MILLISECONDS));
        this.representation = new PlanRepresentation(planRoot, types, totalCpuTime, totalScheduledTime);
        this.formatter = new RowExpressionFormatter(session.toConnectorSession());
        Visitor visitor = new Visitor(stageExecutionStrategy, types, estimatedStatsAndCosts, session, stats);
        planRoot.accept(visitor, null);
    }

    public String toText(boolean verbose, int level) {
        return new TextRenderer(verbose, level).render(this.representation);
    }

    public String toJson() {
        return new JsonRenderer().render(this.representation);
    }

    public static String jsonFragmentPlan(PlanNode root, Map<Symbol, Type> symbols, FunctionManager functionManager, Session session) {
        TypeProvider typeProvider = TypeProvider.copyOf((Map)symbols.entrySet().stream().distinct().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
        return new PlanPrinter(root, typeProvider, Optional.empty(), functionManager, StatsAndCosts.empty(), session, Optional.empty()).toJson();
    }

    public static String textLogicalPlan(PlanNode plan, TypeProvider types, FunctionManager functionManager, StatsAndCosts estimatedStatsAndCosts, Session session, int level) {
        return new PlanPrinter(plan, types, Optional.empty(), functionManager, estimatedStatsAndCosts, session, Optional.empty()).toText(false, level);
    }

    public static String textLogicalPlan(PlanNode plan, TypeProvider types, FunctionManager functionManager, StatsAndCosts estimatedStatsAndCosts, Session session, int level, boolean verbose) {
        return PlanPrinter.textLogicalPlan(plan, types, Optional.empty(), functionManager, estimatedStatsAndCosts, session, Optional.empty(), level, verbose);
    }

    public static String textLogicalPlan(PlanNode plan, TypeProvider types, Optional<StageExecutionDescriptor> stageExecutionStrategy, FunctionManager functionManager, StatsAndCosts estimatedStatsAndCosts, Session session, Optional<Map<PlanNodeId, PlanNodeStats>> stats, int level, boolean verbose) {
        return new PlanPrinter(plan, types, stageExecutionStrategy, functionManager, estimatedStatsAndCosts, session, stats).toText(verbose, level);
    }

    public static String textDistributedPlan(StageInfo outputStageInfo, FunctionManager functionManager, Session session, boolean verbose) {
        StringBuilder builder = new StringBuilder();
        List<StageInfo> allStages = StageInfo.getAllStages(Optional.of(outputStageInfo));
        List allFragments = (List)allStages.stream().map(StageInfo::getPlan).collect(ImmutableList.toImmutableList());
        Map<PlanNodeId, PlanNodeStats> aggregatedStats = PlanNodeStatsSummarizer.aggregateStageStats(allStages);
        for (StageInfo stageInfo : allStages) {
            builder.append(PlanPrinter.formatFragment(functionManager, session, stageInfo.getPlan(), Optional.of(stageInfo), Optional.of(aggregatedStats), verbose, allFragments));
        }
        return builder.toString();
    }

    public static String textDistributedPlan(SubPlan plan, FunctionManager functionManager, Session session, boolean verbose) {
        StringBuilder builder = new StringBuilder();
        for (PlanFragment fragment : plan.getAllFragments()) {
            builder.append(PlanPrinter.formatFragment(functionManager, session, fragment, Optional.empty(), Optional.empty(), verbose, plan.getAllFragments()));
        }
        return builder.toString();
    }

    private static String formatFragment(FunctionManager functionManager, Session session, PlanFragment fragment, Optional<StageInfo> stageInfo, Optional<Map<PlanNodeId, PlanNodeStats>> planNodeStats, boolean verbose, List<PlanFragment> allFragments) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Fragment %s [%s]\n", fragment.getId(), fragment.getPartitioning()));
        if (stageInfo.isPresent()) {
            StageStats stageStats = stageInfo.get().getStageStats();
            double avgPositionsPerTask = stageInfo.get().getTasks().stream().mapToLong(task -> task.getStats().getProcessedInputPositions()).average().orElse(Double.NaN);
            double squaredDifferences = stageInfo.get().getTasks().stream().mapToDouble(task -> Math.pow((double)task.getStats().getProcessedInputPositions() - avgPositionsPerTask, 2.0)).sum();
            double sdAmongTasks = Math.sqrt(squaredDifferences / (double)stageInfo.get().getTasks().size());
            builder.append(TextRenderer.indentString(1)).append(String.format("CPU: %s, Scheduled: %s, Input: %s (%s); per task: avg.: %s std.dev.: %s, Output: %s (%s)\n", stageStats.getTotalCpuTime().convertToMostSuccinctTimeUnit(), stageStats.getTotalScheduledTime().convertToMostSuccinctTimeUnit(), TextRenderer.formatPositions(stageStats.getProcessedInputPositions()), stageStats.getProcessedInputDataSize(), TextRenderer.formatDouble(avgPositionsPerTask), TextRenderer.formatDouble(sdAmongTasks), TextRenderer.formatPositions(stageStats.getOutputPositions()), stageStats.getOutputDataSize()));
        }
        PartitioningScheme partitioningScheme = fragment.getPartitioningScheme();
        builder.append(TextRenderer.indentString(1)).append(String.format("Output layout: [%s]\n", Joiner.on((String)", ").join(partitioningScheme.getOutputLayout())));
        boolean replicateNullsAndAny = partitioningScheme.isReplicateNullsAndAny();
        List arguments = (List)partitioningScheme.getPartitioning().getArguments().stream().map(argument -> {
            if (argument.isConstant()) {
                NullableValue constant = argument.getConstant();
                String printableValue = PlanPrinter.castToVarchar(constant.getType(), constant.getValue(), functionManager, session);
                return constant.getType().getDisplayName() + "(" + printableValue + ")";
            }
            return argument.getColumn().toString();
        }).collect(ImmutableList.toImmutableList());
        builder.append(TextRenderer.indentString(1));
        if (replicateNullsAndAny) {
            builder.append(String.format("Output partitioning: %s (replicate nulls and any) [%s]%s\n", partitioningScheme.getPartitioning().getHandle(), Joiner.on((String)", ").join((Iterable)arguments), PlanPrinter.formatHash(partitioningScheme.getHashColumn())));
        } else {
            builder.append(String.format("Output partitioning: %s [%s]%s\n", partitioningScheme.getPartitioning().getHandle(), Joiner.on((String)", ").join((Iterable)arguments), PlanPrinter.formatHash(partitioningScheme.getHashColumn())));
        }
        builder.append(TextRenderer.indentString(1)).append(String.format("Stage Execution Strategy: %s\n", new Object[]{fragment.getStageExecutionDescriptor().getStageExecutionStrategy()}));
        TypeProvider typeProvider = TypeProvider.copyOf((Map)allFragments.stream().flatMap(f -> f.getSymbols().entrySet().stream()).distinct().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
        builder.append(PlanPrinter.textLogicalPlan(fragment.getRoot(), typeProvider, Optional.of(fragment.getStageExecutionDescriptor()), functionManager, fragment.getStatsAndCosts(), session, planNodeStats, 1, verbose)).append("\n");
        return builder.toString();
    }

    public static String graphvizLogicalPlan(PlanNode plan, TypeProvider types, Session session) {
        PlanFragment fragment = new PlanFragment(new PlanFragmentId(0), plan, types.allTypes(), SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<PlanNodeId>)ImmutableList.of((Object)plan.getId()), new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), plan.getOutputSymbols()), StageExecutionDescriptor.ungroupedExecution(), StatsAndCosts.empty(), Optional.empty());
        return GraphvizPrinter.printLogical((List<PlanFragment>)ImmutableList.of((Object)fragment), session);
    }

    public static String graphvizDistributedPlan(SubPlan plan, Session session) {
        return GraphvizPrinter.printDistributed(plan, session);
    }

    private static String castToVarchar(Type type, Object value, FunctionManager functionManager, Session session) {
        if (value == null) {
            return "NULL";
        }
        try {
            FunctionHandle cast = functionManager.lookupCast(CastType.CAST, type.getTypeSignature(), VarcharType.VARCHAR.getTypeSignature());
            Slice coerced = (Slice)new InterpretedFunctionInvoker(functionManager).invoke(cast, session.toConnectorSession(), value);
            return coerced.toStringUtf8();
        }
        catch (OperatorNotFoundException e) {
            return "<UNREPRESENTABLE VALUE>";
        }
    }

    private static String formatFrame(WindowNode.Frame frame) {
        StringBuilder builder = new StringBuilder(frame.getType().toString());
        frame.getOriginalStartValue().ifPresent(value -> builder.append(" ").append((String)value));
        builder.append(" ").append((Object)frame.getStartType());
        frame.getOriginalEndValue().ifPresent(value -> builder.append(" ").append((String)value));
        builder.append(" ").append((Object)frame.getEndType());
        return builder.toString();
    }

    private static String formatHash(Optional<Symbol> ... hashes) {
        List symbols = Arrays.stream(hashes).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (symbols.isEmpty()) {
            return "";
        }
        return "[" + Joiner.on((String)", ").join(symbols) + "]";
    }

    private static String formatOutputs(TypeProvider types, Iterable<Symbol> outputs) {
        return Streams.stream(outputs).map(input -> input + ":" + types.get((Symbol)input).getDisplayName()).collect(Collectors.joining(", "));
    }

    private class Visitor
    extends PlanVisitor<Void, Void> {
        private final Optional<StageExecutionDescriptor> stageExecutionStrategy;
        private final TypeProvider types;
        private final StatsAndCosts estimatedStatsAndCosts;
        private final Optional<Map<PlanNodeId, PlanNodeStats>> stats;
        private final Session session;

        public Visitor(Optional<StageExecutionDescriptor> stageExecutionStrategy, TypeProvider types, StatsAndCosts estimatedStatsAndCosts, Session session, Optional<Map<PlanNodeId, PlanNodeStats>> stats) {
            this.stageExecutionStrategy = Objects.requireNonNull(stageExecutionStrategy, "stageExecutionStrategy is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.estimatedStatsAndCosts = Objects.requireNonNull(estimatedStatsAndCosts, "estimatedStatsAndCosts is null");
            this.stats = Objects.requireNonNull(stats, "stats is null");
            this.session = Objects.requireNonNull(session, "session is null");
        }

        @Override
        public Void visitExplainAnalyze(ExplainAnalyzeNode node, Void context) {
            this.addNode(node, "ExplainAnalyze");
            return this.processChildren(node, context);
        }

        @Override
        public Void visitJoin(JoinNode node, Void context) {
            NodeRepresentation nodeOutput;
            ArrayList<ComparisonExpression> joinExpressions = new ArrayList<ComparisonExpression>();
            for (JoinNode.EquiJoinClause clause : node.getCriteria()) {
                joinExpressions.add(clause.toExpression());
            }
            node.getFilter().ifPresent(joinExpressions::add);
            if (node.isCrossJoin()) {
                Preconditions.checkState((boolean)joinExpressions.isEmpty());
                nodeOutput = this.addNode(node, "CrossJoin");
            } else {
                nodeOutput = this.addNode(node, node.getType().getJoinLabel(), String.format("[%s]%s", Joiner.on((String)" AND ").join(joinExpressions), PlanPrinter.formatHash(new Optional[]{node.getLeftHashSymbol(), node.getRightHashSymbol()})));
            }
            node.getDistributionType().ifPresent(distributionType -> nodeOutput.appendDetails("Distribution: %s", distributionType));
            node.getSortExpressionContext().ifPresent(sortContext -> nodeOutput.appendDetails("SortExpression[%s]", sortContext.getSortExpression()));
            node.getLeft().accept(this, context);
            node.getRight().accept(this, context);
            return null;
        }

        @Override
        public Void visitSpatialJoin(SpatialJoinNode node, Void context) {
            NodeRepresentation nodeOutput = this.addNode(node, node.getType().getJoinLabel(), String.format("[%s]", node.getFilter()));
            nodeOutput.appendDetailsLine("Distribution: %s", new Object[]{node.getDistributionType()});
            node.getLeft().accept(this, context);
            node.getRight().accept(this, context);
            return null;
        }

        @Override
        public Void visitSemiJoin(SemiJoinNode node, Void context) {
            NodeRepresentation nodeOutput = this.addNode(node, "SemiJoin", String.format("[%s = %s]%s", node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), PlanPrinter.formatHash(new Optional[]{node.getSourceHashSymbol(), node.getFilteringSourceHashSymbol()})));
            node.getDistributionType().ifPresent(distributionType -> nodeOutput.appendDetailsLine("Distribution: %s", distributionType));
            node.getSource().accept(this, context);
            node.getFilteringSource().accept(this, context);
            return null;
        }

        @Override
        public Void visitIndexSource(IndexSourceNode node, Void context) {
            NodeRepresentation nodeOutput = this.addNode(node, "IndexSource", String.format("[%s, lookup = %s]", node.getIndexHandle(), node.getLookupSymbols()));
            for (Map.Entry<Symbol, ColumnHandle> entry : node.getAssignments().entrySet()) {
                if (!node.getOutputSymbols().contains(entry.getKey())) continue;
                nodeOutput.appendDetailsLine("%s := %s", entry.getKey(), entry.getValue());
            }
            return null;
        }

        @Override
        public Void visitIndexJoin(IndexJoinNode node, Void context) {
            ArrayList<ComparisonExpression> joinExpressions = new ArrayList<ComparisonExpression>();
            for (IndexJoinNode.EquiJoinClause clause : node.getCriteria()) {
                joinExpressions.add(new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)clause.getProbe().toSymbolReference(), (Expression)clause.getIndex().toSymbolReference()));
            }
            this.addNode(node, String.format("%sIndexJoin", node.getType().getJoinLabel()), String.format("[%s]%s", Joiner.on((String)" AND ").join(joinExpressions), PlanPrinter.formatHash(new Optional[]{node.getProbeHashSymbol(), node.getIndexHashSymbol()})));
            node.getProbeSource().accept(this, context);
            node.getIndexSource().accept(this, context);
            return null;
        }

        @Override
        public Void visitLimit(LimitNode node, Void context) {
            this.addNode(node, String.format("Limit%s", node.isPartial() ? "Partial" : ""), String.format("[%s]", node.getCount()));
            return this.processChildren(node, context);
        }

        @Override
        public Void visitDistinctLimit(DistinctLimitNode node, Void context) {
            this.addNode(node, String.format("DistinctLimit%s", node.isPartial() ? "Partial" : ""), String.format("[%s]%s", node.getLimit(), PlanPrinter.formatHash(new Optional[]{node.getHashSymbol()})));
            return this.processChildren(node, context);
        }

        @Override
        public Void visitAggregation(AggregationNode node, Void context) {
            String type = "";
            if (node.getStep() != AggregationNode.Step.SINGLE) {
                type = String.format("(%s)", node.getStep().toString());
            }
            if (node.isStreamable()) {
                type = String.format("%s(STREAMING)", type);
            }
            String key = "";
            if (!node.getGroupingKeys().isEmpty()) {
                key = node.getGroupingKeys().toString();
            }
            NodeRepresentation nodeOutput = this.addNode(node, String.format("Aggregate%s%s%s", type, key, PlanPrinter.formatHash(new Optional[]{node.getHashSymbol()})));
            for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : node.getAggregations().entrySet()) {
                if (entry.getValue().getMask().isPresent()) {
                    nodeOutput.appendDetailsLine("%s := %s (mask = %s)", entry.getKey(), entry.getValue().getCall(), entry.getValue().getMask().get());
                    continue;
                }
                nodeOutput.appendDetailsLine("%s := %s", entry.getKey(), entry.getValue().getCall());
            }
            return this.processChildren(node, context);
        }

        @Override
        public Void visitGroupId(GroupIdNode node, Void context) {
            List inputGroupingSetSymbols = node.getGroupingSets().stream().map(set -> set.stream().map(symbol -> node.getGroupingColumns().get(symbol)).collect(Collectors.toList())).collect(Collectors.toList());
            NodeRepresentation nodeOutput = this.addNode(node, "GroupId", String.format("%s", inputGroupingSetSymbols));
            for (Map.Entry<Symbol, Symbol> mapping : node.getGroupingColumns().entrySet()) {
                nodeOutput.appendDetailsLine("%s := %s", mapping.getKey(), mapping.getValue());
            }
            return this.processChildren(node, context);
        }

        @Override
        public Void visitMarkDistinct(MarkDistinctNode node, Void context) {
            this.addNode(node, "MarkDistinct", String.format("[distinct=%s marker=%s]%s", PlanPrinter.formatOutputs(this.types, node.getDistinctSymbols()), node.getMarkerSymbol(), PlanPrinter.formatHash(new Optional[]{node.getHashSymbol()})));
            return this.processChildren(node, context);
        }

        @Override
        public Void visitWindow(WindowNode node, Void context) {
            List partitionBy = Lists.transform(node.getPartitionBy(), (Function)Functions.toStringFunction());
            ArrayList<String> args = new ArrayList<String>();
            if (!partitionBy.isEmpty()) {
                List prePartitioned = (List)node.getPartitionBy().stream().filter(node.getPrePartitionedInputs()::contains).collect(ImmutableList.toImmutableList());
                List notPrePartitioned = (List)node.getPartitionBy().stream().filter(column -> !node.getPrePartitionedInputs().contains(column)).collect(ImmutableList.toImmutableList());
                StringBuilder builder = new StringBuilder();
                if (!prePartitioned.isEmpty()) {
                    builder.append("<").append(Joiner.on((String)", ").join((Iterable)prePartitioned)).append(">");
                    if (!notPrePartitioned.isEmpty()) {
                        builder.append(", ");
                    }
                }
                if (!notPrePartitioned.isEmpty()) {
                    builder.append(Joiner.on((String)", ").join((Iterable)notPrePartitioned));
                }
                args.add(String.format("partition by (%s)", builder));
            }
            if (node.getOrderingScheme().isPresent()) {
                OrderingScheme orderingScheme = node.getOrderingScheme().get();
                args.add(String.format("order by (%s)", Stream.concat(orderingScheme.getOrderBy().stream().limit(node.getPreSortedOrderPrefix()).map(symbol -> "<" + symbol + " " + orderingScheme.getOrdering((Symbol)symbol) + ">"), orderingScheme.getOrderBy().stream().skip(node.getPreSortedOrderPrefix()).map(symbol -> symbol + " " + orderingScheme.getOrdering((Symbol)symbol))).collect(Collectors.joining(", "))));
            }
            NodeRepresentation nodeOutput = this.addNode(node, "Window", String.format("[%s]%s", Joiner.on((String)", ").join(args), PlanPrinter.formatHash(new Optional[]{node.getHashSymbol()})));
            for (Map.Entry<Symbol, WindowNode.Function> entry : node.getWindowFunctions().entrySet()) {
                CallExpression call = entry.getValue().getFunctionCall();
                String frameInfo = PlanPrinter.formatFrame(entry.getValue().getFrame());
                Object[] objectArray = new Object[4];
                objectArray[0] = entry.getKey();
                objectArray[1] = call.getDisplayName();
                objectArray[2] = Joiner.on((String)", ").join((Iterable)call.getArguments().stream().map(PlanPrinter.this.formatter::formatRowExpression).collect(ImmutableList.toImmutableList()));
                objectArray[3] = frameInfo;
                nodeOutput.appendDetailsLine("%s := %s(%s) %s", objectArray);
            }
            return this.processChildren(node, context);
        }

        @Override
        public Void visitTopNRowNumber(TopNRowNumberNode node, Void context) {
            List partitionBy = (List)node.getPartitionBy().stream().map(Functions.toStringFunction()).collect(ImmutableList.toImmutableList());
            List orderBy = (List)node.getOrderingScheme().getOrderBy().stream().map(input -> input + " " + node.getOrderingScheme().getOrdering((Symbol)input)).collect(ImmutableList.toImmutableList());
            ArrayList<String> args = new ArrayList<String>();
            args.add(String.format("partition by (%s)", Joiner.on((String)", ").join((Iterable)partitionBy)));
            args.add(String.format("order by (%s)", Joiner.on((String)", ").join((Iterable)orderBy)));
            NodeRepresentation nodeOutput = this.addNode(node, "TopNRowNumber", String.format("[%s limit %s]%s", Joiner.on((String)", ").join(args), node.getMaxRowCountPerPartition(), PlanPrinter.formatHash(new Optional[]{node.getHashSymbol()})));
            nodeOutput.appendDetailsLine("%s := %s", node.getRowNumberSymbol(), "row_number()");
            return this.processChildren(node, context);
        }

        @Override
        public Void visitRowNumber(RowNumberNode node, Void context) {
            List partitionBy = Lists.transform(node.getPartitionBy(), (Function)Functions.toStringFunction());
            ArrayList<String> args = new ArrayList<String>();
            if (!partitionBy.isEmpty()) {
                args.add(String.format("partition by (%s)", Joiner.on((String)", ").join((Iterable)partitionBy)));
            }
            if (node.getMaxRowCountPerPartition().isPresent()) {
                args.add(String.format("limit = %s", node.getMaxRowCountPerPartition().get()));
            }
            NodeRepresentation nodeOutput = this.addNode(node, "RowNumber", String.format("[%s]%s", Joiner.on((String)", ").join(args), PlanPrinter.formatHash(new Optional[]{node.getHashSymbol()})));
            nodeOutput.appendDetailsLine("%s := %s", node.getRowNumberSymbol(), "row_number()");
            return this.processChildren(node, context);
        }

        @Override
        public Void visitTableScan(TableScanNode node, Void context) {
            TableHandle table = node.getTable();
            NodeRepresentation nodeOutput = this.stageExecutionStrategy.isPresent() ? this.addNode(node, "TableScan", String.format("[%s, grouped = %s]", table, this.stageExecutionStrategy.get().isScanGroupedExecution(node.getId()))) : this.addNode(node, "TableScan", String.format("[%s]", table));
            this.printTableScanInfo(nodeOutput, node);
            return null;
        }

        @Override
        public Void visitValues(ValuesNode node, Void context) {
            NodeRepresentation nodeOutput = this.addNode(node, "Values");
            for (List<RowExpression> row : node.getRows()) {
                nodeOutput.appendDetailsLine("(" + Joiner.on((String)", ").join(PlanPrinter.this.formatter.formatRowExpressions(row)) + ")", new Object[0]);
            }
            return null;
        }

        @Override
        public Void visitFilter(FilterNode node, Void context) {
            return this.visitScanFilterAndProjectInfo(node, Optional.of(node), Optional.empty(), context);
        }

        @Override
        public Void visitProject(ProjectNode node, Void context) {
            if (node.getSource() instanceof FilterNode) {
                return this.visitScanFilterAndProjectInfo(node, Optional.of((FilterNode)node.getSource()), Optional.of(node), context);
            }
            return this.visitScanFilterAndProjectInfo(node, Optional.empty(), Optional.of(node), context);
        }

        private Void visitScanFilterAndProjectInfo(PlanNode node, Optional<FilterNode> filterNode, Optional<ProjectNode> projectNode, Void context) {
            Preconditions.checkState((projectNode.isPresent() || filterNode.isPresent() ? 1 : 0) != 0);
            PlanNode sourceNode = filterNode.isPresent() ? filterNode.get().getSource() : projectNode.get().getSource();
            Optional<Object> scanNode = sourceNode instanceof TableScanNode ? Optional.of((TableScanNode)sourceNode) : Optional.empty();
            String formatString = "[";
            String operatorName = "";
            LinkedList<Object> arguments = new LinkedList<Object>();
            if (scanNode.isPresent()) {
                operatorName = operatorName + "Scan";
                formatString = formatString + "table = %s, ";
                TableHandle table = ((TableScanNode)scanNode.get()).getTable();
                arguments.add(table);
                if (this.stageExecutionStrategy.isPresent()) {
                    formatString = formatString + "grouped = %s, ";
                    arguments.add(this.stageExecutionStrategy.get().isScanGroupedExecution(((TableScanNode)scanNode.get()).getId()));
                }
            }
            if (filterNode.isPresent()) {
                operatorName = operatorName + "Filter";
                formatString = formatString + "filterPredicate = %s, ";
                arguments.add(PlanPrinter.this.formatter.formatRowExpression(filterNode.get().getPredicate()));
            }
            if (formatString.length() > 1) {
                formatString = formatString.substring(0, formatString.length() - 2);
            }
            formatString = formatString + "]";
            if (projectNode.isPresent()) {
                operatorName = operatorName + "Project";
            }
            List<PlanNodeId> allNodes = Stream.of(scanNode, filterNode, projectNode).filter(Optional::isPresent).map(Optional::get).map(PlanNode::getId).collect(Collectors.toList());
            NodeRepresentation nodeOutput = this.addNode(node, operatorName, String.format(formatString, arguments.toArray(new Object[0])), allNodes, (List<PlanNode>)ImmutableList.of((Object)sourceNode), (List<PlanFragmentId>)ImmutableList.of());
            if (projectNode.isPresent()) {
                this.printAssignments(nodeOutput, projectNode.get().getAssignments());
            }
            if (scanNode.isPresent()) {
                this.printTableScanInfo(nodeOutput, (TableScanNode)scanNode.get());
                PlanNodeStats nodeStats = this.stats.map(s -> (PlanNodeStats)s.get(node.getId())).orElse(null);
                if (nodeStats != null) {
                    nodeOutput.appendDetails("Input: %s (%s)", TextRenderer.formatPositions(nodeStats.getPlanNodeInputPositions()), nodeStats.getPlanNodeInputDataSize().toString());
                    double filtered = 100.0 * (double)(nodeStats.getPlanNodeInputPositions() - nodeStats.getPlanNodeOutputPositions()) / (double)nodeStats.getPlanNodeInputPositions();
                    nodeOutput.appendDetailsLine(", Filtered: %s%%", TextRenderer.formatDouble(filtered));
                }
                return null;
            }
            sourceNode.accept(this, context);
            return null;
        }

        private void printTableScanInfo(NodeRepresentation nodeOutput, TableScanNode node) {
            TupleDomain<ColumnHandle> predicate;
            TableHandle table = node.getTable();
            if (table.getLayout().isPresent()) {
                ConnectorTableLayoutHandle layout = table.getLayout().get();
                if (!table.getConnectorHandle().toString().equals(layout.toString())) {
                    nodeOutput.appendDetailsLine("LAYOUT: %s", layout);
                }
            }
            if ((predicate = node.getCurrentConstraint()).isNone()) {
                nodeOutput.appendDetailsLine(":: NONE", new Object[0]);
            } else {
                for (Map.Entry<Symbol, ColumnHandle> assignment : node.getAssignments().entrySet()) {
                    ColumnHandle column = assignment.getValue();
                    nodeOutput.appendDetailsLine("%s := %s", assignment.getKey(), column);
                    this.printConstraint(nodeOutput, column, predicate);
                }
                if (!predicate.isAll()) {
                    ImmutableSet outputs = ImmutableSet.copyOf(node.getAssignments().values());
                    ((Map)predicate.getDomains().get()).entrySet().stream().filter(arg_0 -> Visitor.lambda$printTableScanInfo$10((Set)outputs, arg_0)).forEach(entry -> {
                        ColumnHandle column = (ColumnHandle)entry.getKey();
                        nodeOutput.appendDetailsLine("%s", column);
                        this.printConstraint(nodeOutput, column, predicate);
                    });
                }
            }
        }

        @Override
        public Void visitUnnest(UnnestNode node, Void context) {
            this.addNode(node, "Unnest", String.format("[replicate=%s, unnest=%s]", PlanPrinter.formatOutputs(this.types, node.getReplicateSymbols()), PlanPrinter.formatOutputs(this.types, node.getUnnestSymbols().keySet())));
            return this.processChildren(node, context);
        }

        @Override
        public Void visitOutput(OutputNode node, Void context) {
            NodeRepresentation nodeOutput = this.addNode(node, "Output", String.format("[%s]", Joiner.on((String)", ").join(node.getColumnNames())));
            for (int i = 0; i < node.getColumnNames().size(); ++i) {
                Symbol symbol;
                String name = node.getColumnNames().get(i);
                if (name.equals((symbol = node.getOutputSymbols().get(i)).toString())) continue;
                nodeOutput.appendDetailsLine("%s := %s", name, symbol);
            }
            return this.processChildren(node, context);
        }

        @Override
        public Void visitTopN(TopNNode node, Void context) {
            Iterable keys = Iterables.transform(node.getOrderingScheme().getOrderBy(), input -> input + " " + node.getOrderingScheme().getOrdering((Symbol)input));
            this.addNode(node, String.format("TopN%s", node.getStep() == TopNNode.Step.PARTIAL ? "Partial" : ""), String.format("[%s by (%s)]", node.getCount(), Joiner.on((String)", ").join(keys)));
            return this.processChildren(node, context);
        }

        @Override
        public Void visitSort(SortNode node, Void context) {
            Iterable keys = Iterables.transform(node.getOrderingScheme().getOrderBy(), input -> input + " " + node.getOrderingScheme().getOrdering((Symbol)input));
            boolean isPartial = false;
            if (SystemSessionProperties.isDistributedSortEnabled(this.session)) {
                isPartial = true;
            }
            this.addNode(node, String.format("%sSort", isPartial ? "Partial" : ""), String.format("[%s]", Joiner.on((String)", ").join(keys)));
            return this.processChildren(node, context);
        }

        @Override
        public Void visitRemoteSource(RemoteSourceNode node, Void context) {
            this.addNode(node, String.format("Remote%s", node.getOrderingScheme().isPresent() ? "Merge" : "Source"), String.format("[%s]", Joiner.on((char)',').join(node.getSourceFragmentIds())), (List<PlanNodeId>)ImmutableList.of(), (List<PlanNode>)ImmutableList.of(), node.getSourceFragmentIds());
            return null;
        }

        @Override
        public Void visitUnion(UnionNode node, Void context) {
            this.addNode(node, "Union");
            return this.processChildren(node, context);
        }

        @Override
        public Void visitIntersect(IntersectNode node, Void context) {
            this.addNode(node, "Intersect");
            return this.processChildren(node, context);
        }

        @Override
        public Void visitExcept(ExceptNode node, Void context) {
            this.addNode(node, "Except");
            return this.processChildren(node, context);
        }

        @Override
        public Void visitTableWriter(TableWriterNode node, Void context) {
            NodeRepresentation nodeOutput = this.addNode(node, "TableWriter");
            for (int i = 0; i < node.getColumnNames().size(); ++i) {
                String name = node.getColumnNames().get(i);
                Symbol symbol = node.getColumns().get(i);
                nodeOutput.appendDetailsLine("%s := %s", name, symbol);
            }
            int statisticsCollected = node.getStatisticsAggregation().map(StatisticAggregations::getAggregations).map(Map::size).orElse(0);
            nodeOutput.appendDetailsLine("Statistics collected: %s", statisticsCollected);
            return this.processChildren(node, context);
        }

        @Override
        public Void visitStatisticsWriterNode(StatisticsWriterNode node, Void context) {
            this.addNode(node, "StatisticsWriter", String.format("[%s]", node.getTarget()));
            return this.processChildren(node, context);
        }

        @Override
        public Void visitTableFinish(TableFinishNode node, Void context) {
            this.addNode(node, "TableCommit", String.format("[%s]", node.getTarget()));
            return this.processChildren(node, context);
        }

        @Override
        public Void visitSample(SampleNode node, Void context) {
            this.addNode(node, "Sample", String.format("[%s: %s]", new Object[]{node.getSampleType(), node.getSampleRatio()}));
            return this.processChildren(node, context);
        }

        @Override
        public Void visitExchange(ExchangeNode node, Void context) {
            if (node.getOrderingScheme().isPresent()) {
                OrderingScheme orderingScheme = node.getOrderingScheme().get();
                List orderBy = (List)orderingScheme.getOrderBy().stream().map(input -> input + " " + orderingScheme.getOrdering((Symbol)input)).collect(ImmutableList.toImmutableList());
                this.addNode(node, String.format("%sMerge", CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, node.getScope().toString())), String.format("[%s]", Joiner.on((String)", ").join((Iterable)orderBy)));
            } else if (node.getScope().isLocal()) {
                this.addNode(node, "LocalExchange", String.format("[%s%s]%s (%s)", node.getPartitioningScheme().getPartitioning().getHandle(), node.getPartitioningScheme().isReplicateNullsAndAny() ? " - REPLICATE NULLS AND ANY" : "", PlanPrinter.formatHash(new Optional[]{node.getPartitioningScheme().getHashColumn()}), Joiner.on((String)", ").join(node.getPartitioningScheme().getPartitioning().getArguments())));
            } else {
                this.addNode(node, String.format("%sExchange", CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, node.getScope().toString())), String.format("[%s%s]%s", new Object[]{node.getType(), node.getPartitioningScheme().isReplicateNullsAndAny() ? " - REPLICATE NULLS AND ANY" : "", PlanPrinter.formatHash(new Optional[]{node.getPartitioningScheme().getHashColumn()})}));
            }
            return this.processChildren(node, context);
        }

        @Override
        public Void visitDelete(DeleteNode node, Void context) {
            this.addNode(node, "Delete", String.format("[%s]", node.getTarget()));
            return this.processChildren(node, context);
        }

        @Override
        public Void visitMetadataDelete(MetadataDeleteNode node, Void context) {
            this.addNode(node, "MetadataDelete", String.format("[%s]", node.getTarget()));
            return this.processChildren(node, context);
        }

        @Override
        public Void visitEnforceSingleRow(EnforceSingleRowNode node, Void context) {
            this.addNode(node, "EnforceSingleRow");
            return this.processChildren(node, context);
        }

        @Override
        public Void visitAssignUniqueId(AssignUniqueId node, Void context) {
            this.addNode(node, "AssignUniqueId");
            return this.processChildren(node, context);
        }

        @Override
        public Void visitGroupReference(GroupReference node, Void context) {
            this.addNode(node, "GroupReference", String.format("[%s]", node.getGroupId()), (List<PlanNode>)ImmutableList.of());
            return null;
        }

        @Override
        public Void visitApply(ApplyNode node, Void context) {
            NodeRepresentation nodeOutput = this.addNode(node, "Apply", String.format("[%s]", node.getCorrelation()));
            this.printAssignments(nodeOutput, node.getSubqueryAssignments());
            return this.processChildren(node, context);
        }

        @Override
        public Void visitLateralJoin(LateralJoinNode node, Void context) {
            this.addNode(node, "Lateral", String.format("[%s]", node.getCorrelation()));
            return this.processChildren(node, context);
        }

        @Override
        protected Void visitPlan(PlanNode node, Void context) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }

        private Void processChildren(PlanNode node, Void context) {
            for (PlanNode child : node.getSources()) {
                child.accept(this, context);
            }
            return null;
        }

        private void printAssignments(NodeRepresentation nodeOutput, Assignments assignments) {
            for (Map.Entry<Symbol, Expression> entry : assignments.getMap().entrySet()) {
                if (entry.getValue() instanceof SymbolReference && ((SymbolReference)entry.getValue()).getName().equals(entry.getKey().getName())) continue;
                nodeOutput.appendDetailsLine("%s := %s", entry.getKey(), entry.getValue());
            }
        }

        private void printConstraint(NodeRepresentation nodeOutput, ColumnHandle column, TupleDomain<ColumnHandle> constraint) {
            Preconditions.checkArgument((!constraint.isNone() ? 1 : 0) != 0);
            Map domains = (Map)constraint.getDomains().get();
            if (!constraint.isAll() && domains.containsKey(column)) {
                nodeOutput.appendDetailsLine("    :: %s", this.formatDomain(((Domain)domains.get(column)).simplify()));
            }
        }

        private String formatDomain(Domain domain) {
            ImmutableList.Builder parts = ImmutableList.builder();
            if (domain.isNullAllowed()) {
                parts.add((Object)"NULL");
            }
            Type type = domain.getType();
            domain.getValues().getValuesProcessor().consume(ranges -> {
                for (Range range : ranges.getOrderedRanges()) {
                    StringBuilder builder = new StringBuilder();
                    if (range.isSingleValue()) {
                        String value = PlanPrinter.castToVarchar(type, range.getSingleValue(), PlanPrinter.this.functionManager, this.session);
                        builder.append('[').append(value).append(']');
                    } else {
                        builder.append(range.getLow().getBound() == Marker.Bound.EXACTLY ? (char)'[' : (char)'(');
                        if (range.getLow().isLowerUnbounded()) {
                            builder.append("<min>");
                        } else {
                            builder.append(PlanPrinter.castToVarchar(type, range.getLow().getValue(), PlanPrinter.this.functionManager, this.session));
                        }
                        builder.append(", ");
                        if (range.getHigh().isUpperUnbounded()) {
                            builder.append("<max>");
                        } else {
                            builder.append(PlanPrinter.castToVarchar(type, range.getHigh().getValue(), PlanPrinter.this.functionManager, this.session));
                        }
                        builder.append(range.getHigh().getBound() == Marker.Bound.EXACTLY ? (char)']' : (char)')');
                    }
                    parts.add((Object)builder.toString());
                }
            }, discreteValues -> discreteValues.getValues().stream().map(value -> PlanPrinter.castToVarchar(type, value, PlanPrinter.this.functionManager, this.session)).sorted().forEach(arg_0 -> ((ImmutableList.Builder)parts).add(arg_0)), allOrNone -> {
                if (allOrNone.isAll()) {
                    parts.add((Object)"ALL VALUES");
                }
            });
            return "[" + Joiner.on((String)", ").join((Iterable)parts.build()) + "]";
        }

        public NodeRepresentation addNode(PlanNode node, String name) {
            return this.addNode(node, name, "");
        }

        public NodeRepresentation addNode(PlanNode node, String name, String identifier) {
            return this.addNode(node, name, identifier, node.getSources());
        }

        public NodeRepresentation addNode(PlanNode node, String name, String identifier, List<PlanNode> children) {
            return this.addNode(node, name, identifier, (List<PlanNodeId>)ImmutableList.of((Object)node.getId()), children, (List<PlanFragmentId>)ImmutableList.of());
        }

        public NodeRepresentation addNode(PlanNode rootNode, String name, String identifier, List<PlanNodeId> allNodes, List<PlanNode> children, List<PlanFragmentId> remoteSources) {
            List childrenIds = (List)children.stream().map(PlanNode::getId).collect(ImmutableList.toImmutableList());
            List<PlanNodeStatsEstimate> estimatedStats = allNodes.stream().map(nodeId -> this.estimatedStatsAndCosts.getStats().getOrDefault(nodeId, PlanNodeStatsEstimate.unknown())).collect(Collectors.toList());
            List<PlanCostEstimate> estimatedCosts = allNodes.stream().map(nodeId -> this.estimatedStatsAndCosts.getCosts().getOrDefault(nodeId, PlanCostEstimate.unknown())).collect(Collectors.toList());
            NodeRepresentation nodeOutput = new NodeRepresentation(rootNode.getId(), name, rootNode.getClass().getSimpleName(), identifier, (List)rootNode.getOutputSymbols().stream().map(s -> new NodeRepresentation.OutputSymbol((Symbol)s, this.types.get((Symbol)s).getDisplayName())).collect(ImmutableList.toImmutableList()), this.stats.map(s -> (PlanNodeStats)s.get(rootNode.getId())), estimatedStats, estimatedCosts, childrenIds, remoteSources);
            PlanPrinter.this.representation.addNode(nodeOutput);
            return nodeOutput;
        }

        private static /* synthetic */ boolean lambda$printTableScanInfo$10(Set outputs, Map.Entry entry) {
            return !outputs.contains(entry.getKey());
        }
    }
}

