/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.util.MoreLists;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ValuesNode
extends PlanNode {
    private final List<Symbol> outputSymbols;
    private final List<List<RowExpression>> rows;

    @JsonCreator
    public ValuesNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="outputSymbols") List<Symbol> outputSymbols, @JsonProperty(value="rows") List<List<RowExpression>> rows) {
        super(id);
        this.outputSymbols = ImmutableList.copyOf(outputSymbols);
        this.rows = MoreLists.listOfListsCopy(rows);
        for (List row : rows) {
            Preconditions.checkArgument((row.size() == outputSymbols.size() || row.size() == 0 ? 1 : 0) != 0, (String)"Expected row to have %s values, but row has %s values", (int)outputSymbols.size(), (int)row.size());
        }
    }

    @Override
    @JsonProperty
    public List<Symbol> getOutputSymbols() {
        return this.outputSymbols;
    }

    @JsonProperty
    public List<List<RowExpression>> getRows() {
        return this.rows;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitValues(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((boolean)newChildren.isEmpty(), (Object)"newChildren is not empty");
        return this;
    }
}

