/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TableScanNode
extends PlanNode {
    private final TableHandle table;
    private final List<Symbol> outputSymbols;
    private final Map<Symbol, ColumnHandle> assignments;
    private final TupleDomain<ColumnHandle> currentConstraint;
    private final TupleDomain<ColumnHandle> enforcedConstraint;
    private final boolean temporaryTable;

    @JsonCreator
    public TableScanNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="table") TableHandle table, @JsonProperty(value="outputSymbols") List<Symbol> outputs, @JsonProperty(value="assignments") Map<Symbol, ColumnHandle> assignments, @JsonProperty(value="temporaryTable") boolean temporaryTable) {
        super(id);
        this.table = Objects.requireNonNull(table, "table is null");
        this.outputSymbols = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputs, "outputs is null"));
        this.assignments = ImmutableMap.copyOf(Objects.requireNonNull(assignments, "assignments is null"));
        Preconditions.checkArgument((boolean)assignments.keySet().containsAll(outputs), (Object)"assignments does not cover all of outputs");
        this.temporaryTable = temporaryTable;
        this.currentConstraint = null;
        this.enforcedConstraint = null;
    }

    public TableScanNode(PlanNodeId id, TableHandle table, List<Symbol> outputs, Map<Symbol, ColumnHandle> assignments) {
        this(id, table, outputs, assignments, (TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.all(), false);
    }

    public TableScanNode(PlanNodeId id, TableHandle table, List<Symbol> outputs, Map<Symbol, ColumnHandle> assignments, TupleDomain<ColumnHandle> currentConstraint, TupleDomain<ColumnHandle> enforcedConstraint) {
        this(id, table, outputs, assignments, currentConstraint, enforcedConstraint, false);
    }

    public TableScanNode(PlanNodeId id, TableHandle table, List<Symbol> outputs, Map<Symbol, ColumnHandle> assignments, TupleDomain<ColumnHandle> currentConstraint, TupleDomain<ColumnHandle> enforcedConstraint, boolean temporaryTable) {
        super(id);
        this.table = Objects.requireNonNull(table, "table is null");
        this.outputSymbols = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputs, "outputs is null"));
        this.assignments = ImmutableMap.copyOf(Objects.requireNonNull(assignments, "assignments is null"));
        Preconditions.checkArgument((boolean)assignments.keySet().containsAll(outputs), (Object)"assignments does not cover all of outputs");
        this.currentConstraint = Objects.requireNonNull(currentConstraint, "currentConstraint is null");
        this.enforcedConstraint = Objects.requireNonNull(enforcedConstraint, "enforcedConstraint is null");
        this.temporaryTable = temporaryTable;
        if (!currentConstraint.isAll() || !enforcedConstraint.isAll()) {
            Preconditions.checkArgument((boolean)table.getLayout().isPresent(), (Object)"tableLayout must be present when currentConstraint or enforcedConstraint is non-trivial");
        }
    }

    @JsonProperty(value="table")
    public TableHandle getTable() {
        return this.table;
    }

    @Override
    @JsonProperty(value="outputSymbols")
    public List<Symbol> getOutputSymbols() {
        return this.outputSymbols;
    }

    @JsonProperty(value="assignments")
    public Map<Symbol, ColumnHandle> getAssignments() {
        return this.assignments;
    }

    @JsonProperty
    public boolean isTemporaryTable() {
        return this.temporaryTable;
    }

    public TupleDomain<ColumnHandle> getCurrentConstraint() {
        Preconditions.checkState((this.currentConstraint != null ? 1 : 0) != 0, (Object)"currentConstraint should only be used in planner. It is not transported to workers.");
        return this.currentConstraint;
    }

    public TupleDomain<ColumnHandle> getEnforcedConstraint() {
        Preconditions.checkState((this.enforcedConstraint != null ? 1 : 0) != 0, (Object)"enforcedConstraint should only be used in planner. It is not transported to workers.");
        return this.enforcedConstraint;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableScan(this, context);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("outputSymbols", this.outputSymbols).add("assignments", this.assignments).add("currentConstraint", this.currentConstraint).add("enforcedConstraint", this.enforcedConstraint).toString();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((boolean)newChildren.isEmpty(), (Object)"newChildren is not empty");
        return this;
    }
}

