/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SpatialJoinNode
extends PlanNode {
    private final Type type;
    private final PlanNode left;
    private final PlanNode right;
    private final List<Symbol> outputSymbols;
    private final Expression filter;
    private final Optional<Symbol> leftPartitionSymbol;
    private final Optional<Symbol> rightPartitionSymbol;
    private final Optional<String> kdbTree;
    private final DistributionType distributionType;

    @JsonCreator
    public SpatialJoinNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="type") Type type, @JsonProperty(value="left") PlanNode left, @JsonProperty(value="right") PlanNode right, @JsonProperty(value="outputSymbols") List<Symbol> outputSymbols, @JsonProperty(value="filter") Expression filter, @JsonProperty(value="leftPartitionSymbol") Optional<Symbol> leftPartitionSymbol, @JsonProperty(value="rightPartitionSymbol") Optional<Symbol> rightPartitionSymbol, @JsonProperty(value="kdbTree") Optional<String> kdbTree) {
        super(id);
        this.type = Objects.requireNonNull(type, "type is null");
        this.left = Objects.requireNonNull(left, "left is null");
        this.right = Objects.requireNonNull(right, "right is null");
        this.outputSymbols = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputSymbols, "outputSymbols is null"));
        this.filter = Objects.requireNonNull(filter, "filter is null");
        this.leftPartitionSymbol = Objects.requireNonNull(leftPartitionSymbol, "leftPartitionSymbol is null");
        this.rightPartitionSymbol = Objects.requireNonNull(rightPartitionSymbol, "rightPartitionSymbol is null");
        this.kdbTree = Objects.requireNonNull(kdbTree, "kdbTree is null");
        ImmutableSet inputSymbols = ImmutableSet.builder().addAll(left.getOutputSymbols()).addAll(right.getOutputSymbols()).build();
        Preconditions.checkArgument((boolean)inputSymbols.containsAll(outputSymbols), (Object)"Left and right join inputs do not contain all output symbols");
        if (kdbTree.isPresent()) {
            Preconditions.checkArgument((boolean)leftPartitionSymbol.isPresent(), (Object)"Left partition symbol is missing");
            Preconditions.checkArgument((boolean)rightPartitionSymbol.isPresent(), (Object)"Right partition symbol is missing");
            Preconditions.checkArgument((boolean)left.getOutputSymbols().contains(leftPartitionSymbol.get()), (Object)"Left join input does not contain left partition symbol");
            Preconditions.checkArgument((boolean)right.getOutputSymbols().contains(rightPartitionSymbol.get()), (Object)"Right join input does not contain right partition symbol");
            this.distributionType = DistributionType.PARTITIONED;
        } else {
            Preconditions.checkArgument((!leftPartitionSymbol.isPresent() ? 1 : 0) != 0, (Object)"KDB tree is missing");
            Preconditions.checkArgument((!rightPartitionSymbol.isPresent() ? 1 : 0) != 0, (Object)"KDB tree is missing");
            this.distributionType = DistributionType.REPLICATED;
        }
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="left")
    public PlanNode getLeft() {
        return this.left;
    }

    @JsonProperty(value="right")
    public PlanNode getRight() {
        return this.right;
    }

    @JsonProperty(value="filter")
    public Expression getFilter() {
        return this.filter;
    }

    @JsonProperty(value="leftPartitionSymbol")
    public Optional<Symbol> getLeftPartitionSymbol() {
        return this.leftPartitionSymbol;
    }

    @JsonProperty(value="rightPartitionSymbol")
    public Optional<Symbol> getRightPartitionSymbol() {
        return this.rightPartitionSymbol;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    @Override
    @JsonProperty(value="outputSymbols")
    public List<Symbol> getOutputSymbols() {
        return this.outputSymbols;
    }

    @JsonProperty(value="distributionType")
    public DistributionType getDistributionType() {
        return this.distributionType;
    }

    @JsonProperty(value="kdbTree")
    public Optional<String> getKdbTree() {
        return this.kdbTree;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitSpatialJoin(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 2 ? 1 : 0) != 0, (Object)"expected newChildren to contain 2 nodes");
        return new SpatialJoinNode(this.getId(), this.type, newChildren.get(0), newChildren.get(1), this.outputSymbols, this.filter, this.leftPartitionSymbol, this.rightPartitionSymbol, this.kdbTree);
    }

    public static enum DistributionType {
        PARTITIONED,
        REPLICATED;

    }

    public static enum Type {
        INNER("SpatialInnerJoin"),
        LEFT("SpatialLeftJoin");

        private final String joinLabel;

        private Type(String joinLabel) {
            this.joinLabel = joinLabel;
        }

        public String getJoinLabel() {
            return this.joinLabel;
        }

        public static Type fromJoinNodeType(JoinNode.Type joinNodeType) {
            switch (joinNodeType) {
                case INNER: {
                    return INNER;
                }
                case LEFT: {
                    return LEFT;
                }
            }
            throw new IllegalArgumentException("Unsupported spatial join type: " + (Object)((Object)joinNodeType));
        }
    }
}

