/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.tree.FunctionCall;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AggregationNode
extends PlanNode {
    private final PlanNode source;
    private final Map<Symbol, Aggregation> aggregations;
    private final GroupingSetDescriptor groupingSets;
    private final List<Symbol> preGroupedSymbols;
    private final Step step;
    private final Optional<Symbol> hashSymbol;
    private final Optional<Symbol> groupIdSymbol;
    private final List<Symbol> outputs;

    @JsonCreator
    public AggregationNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="aggregations") Map<Symbol, Aggregation> aggregations, @JsonProperty(value="groupingSets") GroupingSetDescriptor groupingSets, @JsonProperty(value="preGroupedSymbols") List<Symbol> preGroupedSymbols, @JsonProperty(value="step") Step step, @JsonProperty(value="hashSymbol") Optional<Symbol> hashSymbol, @JsonProperty(value="groupIdSymbol") Optional<Symbol> groupIdSymbol) {
        super(id);
        this.source = source;
        this.aggregations = ImmutableMap.copyOf(Objects.requireNonNull(aggregations, "aggregations is null"));
        Objects.requireNonNull(groupingSets, "groupingSets is null");
        groupIdSymbol.ifPresent(symbol -> Preconditions.checkArgument((boolean)groupingSets.getGroupingKeys().contains(symbol), (Object)"Grouping columns does not contain groupId column"));
        this.groupingSets = groupingSets;
        this.groupIdSymbol = Objects.requireNonNull(groupIdSymbol);
        boolean noOrderBy = aggregations.values().stream().map(Aggregation::getCall).map(FunctionCall::getOrderBy).noneMatch(Optional::isPresent);
        Preconditions.checkArgument((noOrderBy || step == Step.SINGLE ? 1 : 0) != 0, (Object)"ORDER BY does not support distributed aggregation");
        this.step = step;
        this.hashSymbol = hashSymbol;
        Objects.requireNonNull(preGroupedSymbols, "preGroupedSymbols is null");
        Preconditions.checkArgument((preGroupedSymbols.isEmpty() || groupingSets.getGroupingKeys().containsAll(preGroupedSymbols) ? 1 : 0) != 0, (Object)"Pre-grouped symbols must be a subset of the grouping keys");
        this.preGroupedSymbols = ImmutableList.copyOf(preGroupedSymbols);
        ImmutableList.Builder outputs = ImmutableList.builder();
        outputs.addAll(groupingSets.getGroupingKeys());
        hashSymbol.ifPresent(arg_0 -> ((ImmutableList.Builder)outputs).add(arg_0));
        outputs.addAll(aggregations.keySet());
        this.outputs = outputs.build();
    }

    public List<Symbol> getGroupingKeys() {
        return this.groupingSets.getGroupingKeys();
    }

    @JsonProperty(value="groupingSets")
    public GroupingSetDescriptor getGroupingSets() {
        return this.groupingSets;
    }

    public boolean hasDefaultOutput() {
        return this.hasEmptyGroupingSet() && (this.step.isOutputPartial() || this.step.equals((Object)Step.SINGLE));
    }

    public boolean hasEmptyGroupingSet() {
        return !this.groupingSets.getGlobalGroupingSets().isEmpty();
    }

    public boolean hasNonEmptyGroupingSet() {
        return this.groupingSets.getGroupingSetCount() > this.groupingSets.getGlobalGroupingSets().size();
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    @JsonProperty
    public Map<Symbol, Aggregation> getAggregations() {
        return this.aggregations;
    }

    @JsonProperty(value="preGroupedSymbols")
    public List<Symbol> getPreGroupedSymbols() {
        return this.preGroupedSymbols;
    }

    public int getGroupingSetCount() {
        return this.groupingSets.getGroupingSetCount();
    }

    public Set<Integer> getGlobalGroupingSets() {
        return this.groupingSets.getGlobalGroupingSets();
    }

    @JsonProperty(value="source")
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty(value="step")
    public Step getStep() {
        return this.step;
    }

    @JsonProperty(value="hashSymbol")
    public Optional<Symbol> getHashSymbol() {
        return this.hashSymbol;
    }

    @JsonProperty(value="groupIdSymbol")
    public Optional<Symbol> getGroupIdSymbol() {
        return this.groupIdSymbol;
    }

    public boolean hasOrderings() {
        return this.aggregations.values().stream().map(Aggregation::getCall).map(FunctionCall::getOrderBy).anyMatch(Optional::isPresent);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitAggregation(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new AggregationNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.aggregations, this.groupingSets, this.preGroupedSymbols, this.step, this.hashSymbol, this.groupIdSymbol);
    }

    public boolean isDecomposable(FunctionManager functionManager) {
        boolean hasOrderBy = this.getAggregations().values().stream().map(Aggregation::getCall).map(FunctionCall::getOrderBy).anyMatch(Optional::isPresent);
        boolean hasDistinct = this.getAggregations().values().stream().map(Aggregation::getCall).anyMatch(FunctionCall::isDistinct);
        boolean decomposableFunctions = this.getAggregations().values().stream().map(Aggregation::getFunctionHandle).map(functionManager::getAggregateFunctionImplementation).allMatch(InternalAggregationFunction::isDecomposable);
        return !hasOrderBy && !hasDistinct && decomposableFunctions;
    }

    public boolean hasSingleNodeExecutionPreference(FunctionManager functionManager) {
        return this.hasEmptyGroupingSet() && !this.hasNonEmptyGroupingSet() || this.hasDefaultOutput() && !this.isDecomposable(functionManager);
    }

    public boolean isStreamable() {
        return !this.preGroupedSymbols.isEmpty() && this.groupingSets.getGroupingSetCount() == 1 && this.groupingSets.getGlobalGroupingSets().isEmpty();
    }

    public static GroupingSetDescriptor globalAggregation() {
        return AggregationNode.singleGroupingSet((List<Symbol>)ImmutableList.of());
    }

    public static GroupingSetDescriptor singleGroupingSet(List<Symbol> groupingKeys) {
        ImmutableSet globalGroupingSets = groupingKeys.isEmpty() ? ImmutableSet.of((Object)0) : ImmutableSet.of();
        return new GroupingSetDescriptor(groupingKeys, 1, (Set<Integer>)globalGroupingSets);
    }

    public static GroupingSetDescriptor groupingSets(List<Symbol> groupingKeys, int groupingSetCount, Set<Integer> globalGroupingSets) {
        return new GroupingSetDescriptor(groupingKeys, groupingSetCount, globalGroupingSets);
    }

    public static class Aggregation {
        private final FunctionCall call;
        private final FunctionHandle functionHandle;
        private final Optional<Symbol> mask;

        @JsonCreator
        public Aggregation(@JsonProperty(value="call") FunctionCall call, @JsonProperty(value="functionHandle") FunctionHandle functionHandle, @JsonProperty(value="mask") Optional<Symbol> mask) {
            this.call = Objects.requireNonNull(call, "call is null");
            this.functionHandle = Objects.requireNonNull(functionHandle, "functionHandle is null");
            this.mask = Objects.requireNonNull(mask, "mask is null");
        }

        @JsonProperty
        public FunctionCall getCall() {
            return this.call;
        }

        @JsonProperty
        public FunctionHandle getFunctionHandle() {
            return this.functionHandle;
        }

        @JsonProperty
        public Optional<Symbol> getMask() {
            return this.mask;
        }
    }

    public static enum Step {
        PARTIAL(true, true),
        FINAL(false, false),
        INTERMEDIATE(false, true),
        SINGLE(true, false);

        private final boolean inputRaw;
        private final boolean outputPartial;

        private Step(boolean inputRaw, boolean outputPartial) {
            this.inputRaw = inputRaw;
            this.outputPartial = outputPartial;
        }

        public boolean isInputRaw() {
            return this.inputRaw;
        }

        public boolean isOutputPartial() {
            return this.outputPartial;
        }

        public static Step partialOutput(Step step) {
            if (step.isInputRaw()) {
                return PARTIAL;
            }
            return INTERMEDIATE;
        }

        public static Step partialInput(Step step) {
            if (step.isOutputPartial()) {
                return INTERMEDIATE;
            }
            return FINAL;
        }
    }

    public static class GroupingSetDescriptor {
        private final List<Symbol> groupingKeys;
        private final int groupingSetCount;
        private final Set<Integer> globalGroupingSets;

        @JsonCreator
        public GroupingSetDescriptor(@JsonProperty(value="groupingKeys") List<Symbol> groupingKeys, @JsonProperty(value="groupingSetCount") int groupingSetCount, @JsonProperty(value="globalGroupingSets") Set<Integer> globalGroupingSets) {
            Objects.requireNonNull(globalGroupingSets, "globalGroupingSets is null");
            Preconditions.checkArgument((globalGroupingSets.size() <= groupingSetCount ? 1 : 0) != 0, (Object)"list of empty global grouping sets must be no larger than grouping set count");
            Objects.requireNonNull(groupingKeys, "groupingKeys is null");
            if (groupingKeys.isEmpty()) {
                Preconditions.checkArgument((!globalGroupingSets.isEmpty() ? 1 : 0) != 0, (Object)"no grouping keys implies at least one global grouping set, but none provided");
            }
            this.groupingKeys = ImmutableList.copyOf(groupingKeys);
            this.groupingSetCount = groupingSetCount;
            this.globalGroupingSets = ImmutableSet.copyOf(globalGroupingSets);
        }

        @JsonProperty
        public List<Symbol> getGroupingKeys() {
            return this.groupingKeys;
        }

        @JsonProperty
        public int getGroupingSetCount() {
            return this.groupingSetCount;
        }

        @JsonProperty
        public Set<Integer> getGlobalGroupingSets() {
            return this.globalGroupingSets;
        }
    }
}

