/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.Marker;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.predicate.ValueSet;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.planner.ExpressionDomainTranslator;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;

public class WindowFilterPushDown
implements PlanOptimizer {
    private static final Signature ROW_NUMBER_SIGNATURE = new Signature("row_number", FunctionKind.WINDOW, TypeSignature.parseTypeSignature((String)"bigint"), (List)ImmutableList.of());
    private final Metadata metadata;
    private final ExpressionDomainTranslator domainTranslator;

    public WindowFilterPushDown(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.domainTranslator = new ExpressionDomainTranslator(new LiteralEncoder(metadata.getBlockEncodingSerde()));
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(idAllocator, this.metadata, this.domainTranslator, session, types), plan, null);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final Metadata metadata;
        private final ExpressionDomainTranslator domainTranslator;
        private final Session session;
        private final TypeProvider types;

        private Rewriter(PlanNodeIdAllocator idAllocator, Metadata metadata, ExpressionDomainTranslator domainTranslator, Session session, TypeProvider types) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.domainTranslator = Objects.requireNonNull(domainTranslator, "domainTranslator is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.types = Objects.requireNonNull(types, "types is null");
        }

        @Override
        public PlanNode visitWindow(WindowNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            Preconditions.checkState((node.getWindowFunctions().size() == 1 ? 1 : 0) != 0, (Object)"WindowFilterPushdown requires that WindowNodes contain exactly one window function");
            PlanNode rewrittenSource = context.rewrite(node.getSource());
            if (Rewriter.canReplaceWithRowNumber(node, this.metadata.getFunctionManager())) {
                return new RowNumberNode(this.idAllocator.getNextId(), rewrittenSource, node.getPartitionBy(), (Symbol)Iterables.getOnlyElement(node.getWindowFunctions().keySet()), Optional.empty(), Optional.empty());
            }
            return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)rewrittenSource));
        }

        @Override
        public PlanNode visitLimit(LimitNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            if (node.getCount() > Integer.MAX_VALUE) {
                return context.defaultRewrite(node);
            }
            PlanNode source = context.rewrite(node.getSource());
            int limit = Math.toIntExact(node.getCount());
            if (source instanceof RowNumberNode) {
                RowNumberNode rowNumberNode = Rewriter.mergeLimit((RowNumberNode)source, limit);
                if (rowNumberNode.getPartitionBy().isEmpty()) {
                    return rowNumberNode;
                }
                source = rowNumberNode;
            } else if (source instanceof WindowNode && Rewriter.canOptimizeWindowFunction((WindowNode)source, this.metadata.getFunctionManager()) && SystemSessionProperties.isOptimizeTopNRowNumber(this.session)) {
                WindowNode windowNode = (WindowNode)source;
                Verify.verify((boolean)windowNode.getOrderingScheme().isPresent());
                TopNRowNumberNode topNRowNumberNode = this.convertToTopNRowNumber(windowNode, limit);
                if (windowNode.getPartitionBy().isEmpty()) {
                    return topNRowNumberNode;
                }
                source = topNRowNumberNode;
            }
            return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source));
        }

        @Override
        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            WindowNode windowNode;
            Symbol rowNumberSymbol;
            OptionalInt upperBound;
            PlanNode source = context.rewrite(node.getSource());
            TupleDomain<Symbol> tupleDomain = ExpressionDomainTranslator.fromPredicate(this.metadata, this.session, OriginalExpressionUtils.castToExpression(node.getPredicate()), this.types).getTupleDomain();
            if (source instanceof RowNumberNode) {
                Symbol rowNumberSymbol2 = ((RowNumberNode)source).getRowNumberSymbol();
                OptionalInt upperBound2 = Rewriter.extractUpperBound(tupleDomain, rowNumberSymbol2);
                if (upperBound2.isPresent()) {
                    source = Rewriter.mergeLimit((RowNumberNode)source, upperBound2.getAsInt());
                    return this.rewriteFilterSource(node, source, rowNumberSymbol2, upperBound2.getAsInt());
                }
            } else if (source instanceof WindowNode && Rewriter.canOptimizeWindowFunction((WindowNode)source, this.metadata.getFunctionManager()) && SystemSessionProperties.isOptimizeTopNRowNumber(this.session) && (upperBound = Rewriter.extractUpperBound(tupleDomain, rowNumberSymbol = (Symbol)((Map.Entry)Iterables.getOnlyElement((windowNode = (WindowNode)source).getWindowFunctions().entrySet())).getKey())).isPresent()) {
                source = this.convertToTopNRowNumber(windowNode, upperBound.getAsInt());
                return this.rewriteFilterSource(node, source, rowNumberSymbol, upperBound.getAsInt());
            }
            return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source));
        }

        private PlanNode rewriteFilterSource(FilterNode filterNode, PlanNode source, Symbol rowNumberSymbol, int upperBound) {
            ExpressionDomainTranslator.ExtractionResult extractionResult = ExpressionDomainTranslator.fromPredicate(this.metadata, this.session, OriginalExpressionUtils.castToExpression(filterNode.getPredicate()), this.types);
            TupleDomain<Symbol> tupleDomain = extractionResult.getTupleDomain();
            if (!Rewriter.isEqualRange(tupleDomain, rowNumberSymbol, upperBound)) {
                return new FilterNode(filterNode.getId(), source, filterNode.getPredicate());
            }
            Map<Symbol, Domain> newDomains = ((Map)tupleDomain.getDomains().get()).entrySet().stream().filter(entry -> !((Symbol)entry.getKey()).equals(rowNumberSymbol)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            TupleDomain newTupleDomain = TupleDomain.withColumnDomains(newDomains);
            Expression newPredicate = ExpressionUtils.combineConjuncts(extractionResult.getRemainingExpression(), this.domainTranslator.toPredicate((TupleDomain<Symbol>)newTupleDomain));
            if (newPredicate.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                return source;
            }
            return new FilterNode(filterNode.getId(), source, OriginalExpressionUtils.castToRowExpression(newPredicate));
        }

        private static boolean isEqualRange(TupleDomain<Symbol> tupleDomain, Symbol symbol, long upperBound) {
            if (tupleDomain.isNone()) {
                return false;
            }
            Domain domain = (Domain)((Map)tupleDomain.getDomains().get()).get(symbol);
            return domain.getValues().equals(ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)domain.getType(), (Object)upperBound), (Range[])new Range[0]));
        }

        private static OptionalInt extractUpperBound(TupleDomain<Symbol> tupleDomain, Symbol symbol) {
            if (tupleDomain.isNone()) {
                return OptionalInt.empty();
            }
            Domain rowNumberDomain = (Domain)((Map)tupleDomain.getDomains().get()).get(symbol);
            if (rowNumberDomain == null) {
                return OptionalInt.empty();
            }
            ValueSet values = rowNumberDomain.getValues();
            if (values.isAll() || values.isNone() || values.getRanges().getRangeCount() <= 0) {
                return OptionalInt.empty();
            }
            Range span = values.getRanges().getSpan();
            if (span.getHigh().isUpperUnbounded()) {
                return OptionalInt.empty();
            }
            Verify.verify((boolean)rowNumberDomain.getType().equals(BigintType.BIGINT));
            long upperBound = (Long)span.getHigh().getValue();
            if (span.getHigh().getBound() == Marker.Bound.BELOW) {
                --upperBound;
            }
            if (upperBound > 0L && upperBound <= Integer.MAX_VALUE) {
                return OptionalInt.of(Math.toIntExact(upperBound));
            }
            return OptionalInt.empty();
        }

        private static RowNumberNode mergeLimit(RowNumberNode node, int newRowCountPerPartition) {
            if (node.getMaxRowCountPerPartition().isPresent()) {
                newRowCountPerPartition = Math.min(node.getMaxRowCountPerPartition().get(), newRowCountPerPartition);
            }
            return new RowNumberNode(node.getId(), node.getSource(), node.getPartitionBy(), node.getRowNumberSymbol(), Optional.of(newRowCountPerPartition), node.getHashSymbol());
        }

        private TopNRowNumberNode convertToTopNRowNumber(WindowNode windowNode, int limit) {
            return new TopNRowNumberNode(this.idAllocator.getNextId(), windowNode.getSource(), windowNode.getSpecification(), (Symbol)Iterables.getOnlyElement(windowNode.getWindowFunctions().keySet()), limit, false, Optional.empty());
        }

        private static boolean canReplaceWithRowNumber(WindowNode node, FunctionManager functionManager) {
            return Rewriter.canOptimizeWindowFunction(node, functionManager) && !node.getOrderingScheme().isPresent();
        }

        private static boolean canOptimizeWindowFunction(WindowNode node, FunctionManager functionManager) {
            if (node.getWindowFunctions().size() != 1) {
                return false;
            }
            Symbol rowNumberSymbol = (Symbol)((Map.Entry)Iterables.getOnlyElement(node.getWindowFunctions().entrySet())).getKey();
            return Rewriter.isRowNumberMetadata(functionManager.getFunctionMetadata(node.getWindowFunctions().get(rowNumberSymbol).getFunctionHandle()));
        }

        private static boolean isRowNumberMetadata(FunctionMetadata functionMetadata) {
            return functionMetadata.getName().equals(ROW_NUMBER_SIGNATURE.getName()) && functionMetadata.getFunctionKind().equals((Object)ROW_NUMBER_SIGNATURE.getKind()) && functionMetadata.getArgumentTypes().equals(ROW_NUMBER_SIGNATURE.getArgumentTypes()) && functionMetadata.getReturnType().equals((Object)ROW_NUMBER_SIGNATURE.getReturnType());
        }
    }
}

