/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.NodeRef;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TranslateExpressions {
    private final Metadata metadata;
    private final SqlParser sqlParser;

    public TranslateExpressions(Metadata metadata, SqlParser sqlParser) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParseris null");
    }

    public Set<Rule<?>> rules() {
        return ImmutableSet.of((Object)new ValuesExpressionTranslation(), (Object)new FilterExpressionTranslation(), (Object)new WindowExpressionTranslation());
    }

    private RowExpression toRowExpression(Expression expression, Rule.Context context) {
        Map<NodeRef<Expression>, Type> types = ExpressionAnalyzer.getExpressionTypes(context.getSession(), this.metadata, this.sqlParser, context.getSymbolAllocator().getTypes(), (Iterable<Expression>)ImmutableList.of((Object)expression), (List<Expression>)ImmutableList.of(), WarningCollector.NOOP, false);
        return SqlToRowExpressionTranslator.translate(expression, types, (Map<Symbol, Integer>)ImmutableMap.of(), this.metadata.getFunctionManager(), this.metadata.getTypeManager(), context.getSession(), false);
    }

    private final class ValuesExpressionTranslation
    implements Rule<ValuesNode> {
        private ValuesExpressionTranslation() {
        }

        @Override
        public Pattern<ValuesNode> getPattern() {
            return Patterns.values();
        }

        @Override
        public Rule.Result apply(ValuesNode valuesNode, Captures captures, Rule.Context context) {
            boolean anyRewritten = false;
            ImmutableList.Builder rows = ImmutableList.builder();
            for (List<RowExpression> row : valuesNode.getRows()) {
                ImmutableList.Builder newRow = ImmutableList.builder();
                for (RowExpression rowExpression : row) {
                    if (OriginalExpressionUtils.isExpression(rowExpression)) {
                        RowExpression rewritten = TranslateExpressions.this.toRowExpression(OriginalExpressionUtils.castToExpression(rowExpression), context);
                        anyRewritten = true;
                        newRow.add((Object)rewritten);
                        continue;
                    }
                    newRow.add((Object)rowExpression);
                }
                rows.add((Object)newRow.build());
            }
            if (anyRewritten) {
                return Rule.Result.ofPlanNode(new ValuesNode(valuesNode.getId(), valuesNode.getOutputSymbols(), (List<List<RowExpression>>)rows.build()));
            }
            return Rule.Result.empty();
        }
    }

    private final class FilterExpressionTranslation
    implements Rule<FilterNode> {
        private FilterExpressionTranslation() {
        }

        @Override
        public Pattern<FilterNode> getPattern() {
            return Patterns.filter();
        }

        @Override
        public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
            Preconditions.checkState((filterNode.getSource() != null ? 1 : 0) != 0);
            RowExpression rewritten = OriginalExpressionUtils.isExpression(filterNode.getPredicate()) ? TranslateExpressions.this.toRowExpression(OriginalExpressionUtils.castToExpression(filterNode.getPredicate()), context) : filterNode.getPredicate();
            if (filterNode.getPredicate().equals((Object)rewritten)) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(new FilterNode(filterNode.getId(), filterNode.getSource(), rewritten));
        }
    }

    private final class WindowExpressionTranslation
    implements Rule<WindowNode> {
        private WindowExpressionTranslation() {
        }

        @Override
        public Pattern<WindowNode> getPattern() {
            return Patterns.window();
        }

        @Override
        public Rule.Result apply(WindowNode windowNode, Captures captures, Rule.Context context) {
            Preconditions.checkState((windowNode.getSource() != null ? 1 : 0) != 0);
            boolean anyRewritten = false;
            ImmutableMap.Builder functions = ImmutableMap.builder();
            for (Map.Entry<Symbol, WindowNode.Function> entry : windowNode.getWindowFunctions().entrySet()) {
                ImmutableList.Builder newArguments = ImmutableList.builder();
                CallExpression callExpression = entry.getValue().getFunctionCall();
                for (RowExpression argument : callExpression.getArguments()) {
                    if (OriginalExpressionUtils.isExpression(argument)) {
                        RowExpression rewritten = TranslateExpressions.this.toRowExpression(OriginalExpressionUtils.castToExpression(argument), context);
                        anyRewritten = true;
                        newArguments.add((Object)rewritten);
                        continue;
                    }
                    newArguments.add((Object)argument);
                }
                functions.put((Object)entry.getKey(), (Object)new WindowNode.Function(Expressions.call(callExpression.getDisplayName(), callExpression.getFunctionHandle(), callExpression.getType(), (List<RowExpression>)newArguments.build()), entry.getValue().getFrame()));
            }
            if (anyRewritten) {
                return Rule.Result.ofPlanNode(new WindowNode(windowNode.getId(), windowNode.getSource(), windowNode.getSpecification(), (Map<Symbol, WindowNode.Function>)functions.build(), windowNode.getHashSymbol(), windowNode.getPrePartitionedInputs(), windowNode.getPreSortedOrderPrefix()));
            }
            return Rule.Result.empty();
        }
    }
}

