/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.GroupingProperty;
import com.facebook.presto.spi.LocalProperty;
import com.facebook.presto.spi.SortingProperty;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.ExpressionDomainTranslator;
import com.facebook.presto.sql.planner.FragmentTableScanCounter;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.rule.PickTableLayout;
import com.facebook.presto.sql.planner.optimizations.ActualProperties;
import com.facebook.presto.sql.planner.optimizations.LocalProperties;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PreferredProperties;
import com.facebook.presto.sql.planner.optimizations.PropertyDerivations;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.SetMultimap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class AddExchanges
implements PlanOptimizer {
    private final SqlParser parser;
    private final Metadata metadata;
    private final ExpressionDomainTranslator domainTranslator;

    public AddExchanges(Metadata metadata, SqlParser parser) {
        this.metadata = metadata;
        this.domainTranslator = new ExpressionDomainTranslator(new LiteralEncoder(metadata.getBlockEncodingSerde()));
        this.parser = parser;
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        PlanWithProperties result = plan.accept(new Rewriter(idAllocator, symbolAllocator, session), PreferredProperties.any());
        return result.getNode();
    }

    private boolean canPushdownPartialMerge(PlanNode node, FeaturesConfig.PartialMergePushdownStrategy strategy) {
        switch (strategy) {
            case NONE: {
                return false;
            }
            case PUSH_THROUGH_LOW_MEMORY_OPERATORS: {
                return this.canPushdownPartialMergeThroughLowMemoryOperators(node);
            }
        }
        throw new UnsupportedOperationException("Unsupported PartialMergePushdownStrategy: " + (Object)((Object)strategy));
    }

    private boolean canPushdownPartialMergeThroughLowMemoryOperators(PlanNode node) {
        if (node instanceof TableScanNode) {
            return true;
        }
        if (node instanceof ExchangeNode && ((ExchangeNode)node).getScope() == ExchangeNode.Scope.REMOTE_MATERIALIZED) {
            return true;
        }
        if (node instanceof JoinNode || node instanceof AggregationNode || node instanceof SemiJoinNode) {
            return false;
        }
        return node.getSources().stream().allMatch(this::canPushdownPartialMergeThroughLowMemoryOperators);
    }

    private static Map<Symbol, Symbol> computeIdentityTranslations(Assignments assignments) {
        HashMap<Symbol, Symbol> outputToInput = new HashMap<Symbol, Symbol>();
        for (Map.Entry<Symbol, Expression> assignment : assignments.getMap().entrySet()) {
            if (!(assignment.getValue() instanceof SymbolReference)) continue;
            outputToInput.put(assignment.getKey(), Symbol.from(assignment.getValue()));
        }
        return outputToInput;
    }

    @VisibleForTesting
    static Comparator<ActualProperties> streamingExecutionPreference(PreferredProperties preferred) {
        LoadingCache matchCache = CacheBuilder.newBuilder().build(CacheLoader.from(actualProperties -> LocalProperties.match(actualProperties, preferred.getLocalProperties())));
        return (actual1, actual2) -> {
            List matchLayout1 = (List)matchCache.getUnchecked(actual1.getLocalProperties());
            List matchLayout2 = (List)matchCache.getUnchecked(actual2.getLocalProperties());
            return ComparisonChain.start().compareTrueFirst(AddExchanges.hasLocalOptimization(preferred.getLocalProperties(), matchLayout1), AddExchanges.hasLocalOptimization(preferred.getLocalProperties(), matchLayout2)).compareTrueFirst(AddExchanges.meetsPartitioningRequirements(preferred, actual1), AddExchanges.meetsPartitioningRequirements(preferred, actual2)).compare((Object)matchLayout1, (Object)matchLayout2, AddExchanges.matchedLayoutPreference()).result();
        };
    }

    private static <T> boolean hasLocalOptimization(List<LocalProperty<T>> desiredLayout, List<Optional<LocalProperty<T>>> matchResult) {
        Preconditions.checkArgument((desiredLayout.size() == matchResult.size() ? 1 : 0) != 0);
        if (matchResult.isEmpty()) {
            return false;
        }
        return !matchResult.get(0).equals(Optional.of(desiredLayout.get(0)));
    }

    private static boolean meetsPartitioningRequirements(PreferredProperties preferred, ActualProperties actual) {
        if (!preferred.getGlobalProperties().isPresent()) {
            return true;
        }
        PreferredProperties.Global preferredGlobal = preferred.getGlobalProperties().get();
        if (!preferredGlobal.isDistributed()) {
            return actual.isSingleNode();
        }
        if (!preferredGlobal.getPartitioningProperties().isPresent()) {
            return !actual.isSingleNode();
        }
        return actual.isStreamPartitionedOn(preferredGlobal.getPartitioningProperties().get().getPartitioningColumns());
    }

    private static <T> Comparator<List<Optional<LocalProperty<T>>>> matchedLayoutPreference() {
        return (matchLayout1, matchLayout2) -> {
            Iterator match1Iterator = matchLayout1.iterator();
            Iterator match2Iterator = matchLayout2.iterator();
            while (match1Iterator.hasNext() && match2Iterator.hasNext()) {
                Optional match1 = (Optional)match1Iterator.next();
                Optional match2 = (Optional)match2Iterator.next();
                if (match1.isPresent() && match2.isPresent()) {
                    return Integer.compare(((LocalProperty)match1.get()).getColumns().size(), ((LocalProperty)match2.get()).getColumns().size());
                }
                if (match1.isPresent()) {
                    return 1;
                }
                if (!match2.isPresent()) continue;
                return -1;
            }
            Preconditions.checkState((!match1Iterator.hasNext() && !match2Iterator.hasNext() ? 1 : 0) != 0);
            return 0;
        };
    }

    @VisibleForTesting
    static class PlanWithProperties {
        private final PlanNode node;
        private final ActualProperties properties;

        public PlanWithProperties(PlanNode node) {
            this(node, ActualProperties.builder().build());
        }

        public PlanWithProperties(PlanNode node, ActualProperties properties) {
            this.node = node;
            this.properties = properties;
        }

        public PlanNode getNode() {
            return this.node;
        }

        public ActualProperties getProperties() {
            return this.properties;
        }
    }

    private class Rewriter
    extends PlanVisitor<PlanWithProperties, PreferredProperties> {
        private final PlanNodeIdAllocator idAllocator;
        private final SymbolAllocator symbolAllocator;
        private final TypeProvider types;
        private final Session session;
        private final boolean distributedIndexJoins;
        private final boolean preferStreamingOperators;
        private final boolean redistributeWrites;
        private final boolean scaleWriters;
        private final FeaturesConfig.PartialMergePushdownStrategy partialMergePushdownStrategy;
        private final String partitioningProviderCatalog;
        private final int hashPartitionCount;
        private final QueryManagerConfig.ExchangeMaterializationStrategy exchangeMaterializationStrategy;

        public Rewriter(PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator, Session session) {
            this.idAllocator = idAllocator;
            this.symbolAllocator = symbolAllocator;
            this.types = symbolAllocator.getTypes();
            this.session = session;
            this.distributedIndexJoins = SystemSessionProperties.isDistributedIndexJoinEnabled(session);
            this.redistributeWrites = SystemSessionProperties.isRedistributeWrites(session);
            this.scaleWriters = SystemSessionProperties.isScaleWriters(session);
            this.partialMergePushdownStrategy = SystemSessionProperties.getPartialMergePushdownStrategy(session);
            this.preferStreamingOperators = SystemSessionProperties.preferStreamingOperators(session);
            this.partitioningProviderCatalog = SystemSessionProperties.getPartitioningProviderCatalog(session);
            this.hashPartitionCount = SystemSessionProperties.getHashPartitionCount(session);
            this.exchangeMaterializationStrategy = SystemSessionProperties.getExchangeMaterializationStrategy(session);
        }

        @Override
        protected PlanWithProperties visitPlan(PlanNode node, PreferredProperties preferredProperties) {
            return this.rebaseAndDeriveProperties(node, this.planChild(node, preferredProperties));
        }

        @Override
        public PlanWithProperties visitProject(ProjectNode node, PreferredProperties preferredProperties) {
            Map identities = AddExchanges.computeIdentityTranslations(node.getAssignments());
            PreferredProperties translatedPreferred = preferredProperties.translate(symbol -> Optional.ofNullable(identities.get(symbol)));
            return this.rebaseAndDeriveProperties((PlanNode)node, this.planChild(node, translatedPreferred));
        }

        @Override
        public PlanWithProperties visitOutput(OutputNode node, PreferredProperties preferredProperties) {
            PlanWithProperties child = this.planChild(node, PreferredProperties.undistributed());
            if (!child.getProperties().isSingleNode() && SystemSessionProperties.isForceSingleNodeOutput(this.session)) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitEnforceSingleRow(EnforceSingleRowNode node, PreferredProperties preferredProperties) {
            PlanWithProperties child = this.planChild(node, PreferredProperties.any());
            if (!child.getProperties().isSingleNode()) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitAggregation(AggregationNode node, PreferredProperties parentPreferredProperties) {
            PlanWithProperties child;
            PreferredProperties preferredProperties;
            ImmutableSet partitioningRequirement = ImmutableSet.copyOf(node.getGroupingKeys());
            boolean preferSingleNode = node.hasSingleNodeExecutionPreference(AddExchanges.this.metadata.getFunctionManager());
            PreferredProperties preferredProperties2 = preferredProperties = preferSingleNode ? PreferredProperties.undistributed() : PreferredProperties.any();
            if (!node.getGroupingKeys().isEmpty()) {
                preferredProperties = PreferredProperties.partitionedWithLocal((Set<Symbol>)partitioningRequirement, LocalProperties.grouped(node.getGroupingKeys())).mergeWithParent(parentPreferredProperties);
            }
            if ((child = this.planChild(node, preferredProperties)).getProperties().isSingleNode()) {
                return this.rebaseAndDeriveProperties((PlanNode)node, child);
            }
            if (preferSingleNode) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode()), child.getProperties());
            } else if (!child.getProperties().isStreamPartitionedOn((Collection<Symbol>)partitioningRequirement) && !child.getProperties().isNodePartitionedOn((Collection<Symbol>)partitioningRequirement)) {
                child = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), this.selectExchangeScopeForPartitionedRemoteExchange(child.getNode()), child.getNode(), this.createPartitioning(node.getGroupingKeys()), node.getHashSymbol()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitGroupId(GroupIdNode node, PreferredProperties preferredProperties) {
            PreferredProperties childPreference = preferredProperties.translate(this.translateGroupIdSymbols(node));
            PlanWithProperties child = this.planChild(node, childPreference);
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        private Function<Symbol, Optional<Symbol>> translateGroupIdSymbols(GroupIdNode node) {
            return symbol -> {
                if (node.getAggregationArguments().contains(symbol)) {
                    return Optional.of(symbol);
                }
                if (node.getCommonGroupingColumns().contains(symbol)) {
                    return Optional.of(node.getGroupingColumns().get(symbol));
                }
                return Optional.empty();
            };
        }

        @Override
        public PlanWithProperties visitMarkDistinct(MarkDistinctNode node, PreferredProperties preferredProperties) {
            PreferredProperties preferredChildProperties = PreferredProperties.partitionedWithLocal((Set<Symbol>)ImmutableSet.copyOf(node.getDistinctSymbols()), LocalProperties.grouped(node.getDistinctSymbols())).mergeWithParent(preferredProperties);
            PlanWithProperties child = node.getSource().accept(this, preferredChildProperties);
            if (child.getProperties().isSingleNode() || !child.getProperties().isStreamPartitionedOn(node.getDistinctSymbols())) {
                child = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), this.selectExchangeScopeForPartitionedRemoteExchange(child.getNode()), child.getNode(), this.createPartitioning(node.getDistinctSymbols()), node.getHashSymbol()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitWindow(WindowNode node, PreferredProperties preferredProperties) {
            ArrayList<GroupingProperty> desiredProperties = new ArrayList<GroupingProperty>();
            if (!node.getPartitionBy().isEmpty()) {
                desiredProperties.add(new GroupingProperty(node.getPartitionBy()));
            }
            node.getOrderingScheme().ifPresent(orderingScheme -> orderingScheme.getOrderBy().stream().map(symbol -> new SortingProperty(symbol, orderingScheme.getOrdering((Symbol)symbol))).forEach(desiredProperties::add));
            PlanWithProperties child = this.planChild(node, PreferredProperties.partitionedWithLocal((Set<Symbol>)ImmutableSet.copyOf(node.getPartitionBy()), desiredProperties).mergeWithParent(preferredProperties));
            if (!child.getProperties().isStreamPartitionedOn(node.getPartitionBy()) && !child.getProperties().isNodePartitionedOn(node.getPartitionBy())) {
                child = node.getPartitionBy().isEmpty() ? this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode()), child.getProperties()) : this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode(), this.createPartitioning(node.getPartitionBy()), node.getHashSymbol()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitRowNumber(RowNumberNode node, PreferredProperties preferredProperties) {
            if (node.getPartitionBy().isEmpty()) {
                PlanWithProperties child = this.planChild(node, PreferredProperties.undistributed());
                if (!child.getProperties().isSingleNode()) {
                    child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode()), child.getProperties());
                }
                return this.rebaseAndDeriveProperties((PlanNode)node, child);
            }
            PlanWithProperties child = this.planChild(node, PreferredProperties.partitionedWithLocal((Set<Symbol>)ImmutableSet.copyOf(node.getPartitionBy()), LocalProperties.grouped(node.getPartitionBy())).mergeWithParent(preferredProperties));
            if (!child.getProperties().isStreamPartitionedOn(node.getPartitionBy()) && !child.getProperties().isNodePartitionedOn(node.getPartitionBy())) {
                child = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode(), this.createPartitioning(node.getPartitionBy()), node.getHashSymbol()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitTopNRowNumber(TopNRowNumberNode node, PreferredProperties preferredProperties) {
            Function<PlanNode, PlanNode> addExchange;
            PreferredProperties preferredChildProperties;
            if (node.getPartitionBy().isEmpty()) {
                preferredChildProperties = PreferredProperties.any();
                addExchange = partial -> ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, partial);
            } else {
                preferredChildProperties = PreferredProperties.partitionedWithLocal((Set<Symbol>)ImmutableSet.copyOf(node.getPartitionBy()), LocalProperties.grouped(node.getPartitionBy())).mergeWithParent(preferredProperties);
                addExchange = partial -> ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, partial, this.createPartitioning(node.getPartitionBy()), node.getHashSymbol());
            }
            PlanWithProperties child = this.planChild(node, preferredChildProperties);
            if (!child.getProperties().isStreamPartitionedOn(node.getPartitionBy()) && !child.getProperties().isNodePartitionedOn(node.getPartitionBy())) {
                child = this.withDerivedProperties(new TopNRowNumberNode(this.idAllocator.getNextId(), child.getNode(), node.getSpecification(), node.getRowNumberSymbol(), node.getMaxRowCountPerPartition(), true, node.getHashSymbol()), child.getProperties());
                child = this.withDerivedProperties(addExchange.apply(child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitTopN(TopNNode node, PreferredProperties preferredProperties) {
            PlanWithProperties child;
            switch (node.getStep()) {
                case SINGLE: 
                case FINAL: {
                    child = this.planChild(node, PreferredProperties.undistributed());
                    if (child.getProperties().isSingleNode()) break;
                    child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode()), child.getProperties());
                    break;
                }
                case PARTIAL: {
                    child = this.planChild(node, PreferredProperties.any());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unsupported step for TopN [%s]", new Object[]{node.getStep()}));
                }
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitSort(SortNode node, PreferredProperties preferredProperties) {
            PlanWithProperties child = this.planChild(node, PreferredProperties.undistributed());
            if (child.getProperties().isSingleNode()) {
                ArrayList desiredProperties = new ArrayList();
                for (Symbol symbol : node.getOrderingScheme().getOrderBy()) {
                    desiredProperties.add(new SortingProperty((Object)symbol, node.getOrderingScheme().getOrdering(symbol)));
                }
                if (LocalProperties.match(child.getProperties().getLocalProperties(), desiredProperties).stream().noneMatch(Optional::isPresent)) {
                    return child;
                }
            }
            if (SystemSessionProperties.isDistributedSortEnabled(this.session)) {
                child = this.planChild(node, PreferredProperties.any());
                ExchangeNode source = ExchangeNode.roundRobinExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode());
                return this.withDerivedProperties(ExchangeNode.mergingExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, new SortNode(this.idAllocator.getNextId(), source, node.getOrderingScheme()), node.getOrderingScheme()), child.getProperties());
            }
            if (!child.getProperties().isSingleNode()) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitLimit(LimitNode node, PreferredProperties preferredProperties) {
            PlanWithProperties child = this.planChild(node, PreferredProperties.any());
            if (!child.getProperties().isSingleNode()) {
                child = this.withDerivedProperties(new LimitNode(this.idAllocator.getNextId(), child.getNode(), node.getCount(), true), child.getProperties());
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitDistinctLimit(DistinctLimitNode node, PreferredProperties preferredProperties) {
            PlanWithProperties child = this.planChild(node, PreferredProperties.any());
            if (!child.getProperties().isSingleNode()) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, new DistinctLimitNode(this.idAllocator.getNextId(), child.getNode(), node.getLimit(), true, node.getDistinctSymbols(), node.getHashSymbol())), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitFilter(FilterNode node, PreferredProperties preferredProperties) {
            if (node.getSource() instanceof TableScanNode) {
                return this.planTableScan((TableScanNode)node.getSource(), OriginalExpressionUtils.castToExpression(node.getPredicate()));
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, this.planChild(node, preferredProperties));
        }

        @Override
        public PlanWithProperties visitTableScan(TableScanNode node, PreferredProperties preferredProperties) {
            return this.planTableScan(node, (Expression)BooleanLiteral.TRUE_LITERAL);
        }

        @Override
        public PlanWithProperties visitTableWriter(TableWriterNode node, PreferredProperties preferredProperties) {
            PlanWithProperties source = node.getSource().accept(this, preferredProperties);
            Optional<PartitioningScheme> partitioningScheme = node.getPartitioningScheme();
            if (!partitioningScheme.isPresent()) {
                if (this.scaleWriters) {
                    partitioningScheme = Optional.of(new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), source.getNode().getOutputSymbols()));
                } else if (this.redistributeWrites) {
                    partitioningScheme = Optional.of(new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), source.getNode().getOutputSymbols()));
                }
            }
            if (!(!partitioningScheme.isPresent() || source.getProperties().isCompatibleTablePartitioningWith(partitioningScheme.get().getPartitioning(), false, AddExchanges.this.metadata, this.session) || source.getProperties().isRefinedPartitioningOver(partitioningScheme.get().getPartitioning(), false, AddExchanges.this.metadata, this.session) && AddExchanges.this.canPushdownPartialMerge(source.getNode(), this.partialMergePushdownStrategy))) {
                source = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, source.getNode(), partitioningScheme.get()), source.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, source);
        }

        private PlanWithProperties planTableScan(TableScanNode node, Expression predicate) {
            PlanNode plan = PickTableLayout.pushPredicateIntoTableScan(node, predicate, true, this.session, this.types, this.idAllocator, AddExchanges.this.metadata, AddExchanges.this.parser, AddExchanges.this.domainTranslator);
            return new PlanWithProperties(plan, this.derivePropertiesRecursively(plan));
        }

        @Override
        public PlanWithProperties visitValues(ValuesNode node, PreferredProperties preferredProperties) {
            return new PlanWithProperties(node, ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build());
        }

        @Override
        public PlanWithProperties visitExplainAnalyze(ExplainAnalyzeNode node, PreferredProperties preferredProperties) {
            PlanWithProperties child = this.planChild(node, PreferredProperties.any());
            if (child.getNode() instanceof ExchangeNode && ((ExchangeNode)child.getNode()).getType() == ExchangeNode.Type.GATHER) {
                return this.rebaseAndDeriveProperties((PlanNode)node, child);
            }
            child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode()), child.getProperties());
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitStatisticsWriterNode(StatisticsWriterNode node, PreferredProperties context) {
            PlanWithProperties child = this.planChild(node, PreferredProperties.any());
            if (child.getNode() instanceof ExchangeNode && ((ExchangeNode)child.getNode()).getType().equals((Object)ExchangeNode.Type.GATHER)) {
                return this.rebaseAndDeriveProperties((PlanNode)node, child);
            }
            if (!child.getProperties().isCoordinatorOnly()) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitTableFinish(TableFinishNode node, PreferredProperties preferredProperties) {
            PlanWithProperties child = this.planChild(node, PreferredProperties.any());
            if (child.getNode() instanceof ExchangeNode && ((ExchangeNode)child.getNode()).getType().equals((Object)ExchangeNode.Type.GATHER)) {
                return this.rebaseAndDeriveProperties((PlanNode)node, child);
            }
            if (!child.getProperties().isCoordinatorOnly()) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        private <T> SetMultimap<T, T> createMapping(List<T> keys, List<T> values) {
            Preconditions.checkArgument((keys.size() == values.size() ? 1 : 0) != 0, (Object)"Inputs must have the same size");
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            for (int i = 0; i < keys.size(); ++i) {
                builder.put(keys.get(i), values.get(i));
            }
            return builder.build();
        }

        private <T> Function<T, Optional<T>> createTranslator(SetMultimap<T, T> inputToOutput) {
            return input -> inputToOutput.get(input).stream().findAny();
        }

        private <T> Function<T, T> createDirectTranslator(SetMultimap<T, T> inputToOutput) {
            return input -> inputToOutput.get(input).iterator().next();
        }

        @Override
        public PlanWithProperties visitJoin(JoinNode node, PreferredProperties preferredProperties) {
            List leftSymbols = (List)node.getCriteria().stream().map(JoinNode.EquiJoinClause::getLeft).collect(ImmutableList.toImmutableList());
            List rightSymbols = (List)node.getCriteria().stream().map(JoinNode.EquiJoinClause::getRight).collect(ImmutableList.toImmutableList());
            JoinNode.DistributionType distributionType = node.getDistributionType().orElseThrow(() -> new IllegalArgumentException("distributionType not yet set"));
            if (distributionType == JoinNode.DistributionType.REPLICATED) {
                PlanWithProperties left = node.getLeft().accept(this, PreferredProperties.any());
                if (!node.getCriteria().isEmpty() && left.getProperties().isNodePartitionedOn(leftSymbols) && !left.getProperties().isSingleNode()) {
                    return this.planPartitionedJoin(node, leftSymbols, rightSymbols, left);
                }
                return this.planReplicatedJoin(node, left);
            }
            return this.planPartitionedJoin(node, leftSymbols, rightSymbols);
        }

        private PlanWithProperties planPartitionedJoin(JoinNode node, List<Symbol> leftSymbols, List<Symbol> rightSymbols) {
            return this.planPartitionedJoin(node, leftSymbols, rightSymbols, node.getLeft().accept(this, PreferredProperties.partitioned((Set<Symbol>)ImmutableSet.copyOf(leftSymbols))));
        }

        /*
         * Unable to fully structure code
         */
        private PlanWithProperties planPartitionedJoin(JoinNode node, List<Symbol> leftSymbols, List<Symbol> rightSymbols, PlanWithProperties left) {
            rightToLeft = this.createMapping(rightSymbols, leftSymbols);
            leftToRight = this.createMapping(leftSymbols, rightSymbols);
            if (left.getProperties().isNodePartitionedOn(leftSymbols) && !left.getProperties().isSingleNode()) {
                rightPartitioning = left.getProperties().translate(this.createTranslator(leftToRight)).getNodePartitioning().get();
                right = node.getRight().accept(this, PreferredProperties.partitioned(rightPartitioning));
                if (!right.getProperties().isCompatibleTablePartitioningWith(left.getProperties(), (Function<Symbol, Set<Symbol>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(java.lang.Object ), (Lcom/facebook/presto/sql/planner/Symbol;)Ljava/util/Set;)(rightToLeft), AddExchanges.access$100(AddExchanges.this), this.session)) {
                    if (!right.getProperties().isRefinedPartitioningOver(left.getProperties(), (Function<Symbol, Set<Symbol>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(java.lang.Object ), (Lcom/facebook/presto/sql/planner/Symbol;)Ljava/util/Set;)(rightToLeft), AddExchanges.access$100(AddExchanges.this), this.session) || !AddExchanges.access$200(AddExchanges.this, right.getNode(), this.partialMergePushdownStrategy)) {
                        right = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), this.selectExchangeScopeForPartitionedRemoteExchange(right.getNode()), right.getNode(), new PartitioningScheme(rightPartitioning, right.getNode().getOutputSymbols())), right.getProperties());
                    }
                }
            } else {
                right = node.getRight().accept(this, PreferredProperties.partitioned((Set<Symbol>)ImmutableSet.copyOf(rightSymbols)));
                if (right.getProperties().isNodePartitionedOn(rightSymbols) && !right.getProperties().isSingleNode()) {
                    leftPartitioning = right.getProperties().translate(this.createTranslator(rightToLeft)).getNodePartitioning().get();
                    left = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), this.selectExchangeScopeForPartitionedRemoteExchange(left.getNode()), left.getNode(), new PartitioningScheme(leftPartitioning, left.getNode().getOutputSymbols())), left.getProperties());
                } else {
                    left = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), this.selectExchangeScopeForPartitionedRemoteExchange(left.getNode()), left.getNode(), this.createPartitioning(leftSymbols), Optional.empty()), left.getProperties());
                    right = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), this.selectExchangeScopeForPartitionedRemoteExchange(right.getNode()), right.getNode(), this.createPartitioning(rightSymbols), Optional.empty()), right.getProperties());
                }
            }
            if (left.getProperties().isCompatibleTablePartitioningWith(right.getProperties(), (Function<Symbol, Set<Symbol>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(java.lang.Object ), (Lcom/facebook/presto/sql/planner/Symbol;)Ljava/util/Set;)(leftToRight), AddExchanges.access$100(AddExchanges.this), this.session)) ** GOTO lbl-1000
            if (right.getProperties().isRefinedPartitioningOver(left.getProperties(), (Function<Symbol, Set<Symbol>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(java.lang.Object ), (Lcom/facebook/presto/sql/planner/Symbol;)Ljava/util/Set;)(rightToLeft), AddExchanges.access$100(AddExchanges.this), this.session) && AddExchanges.access$200(AddExchanges.this, right.getNode(), this.partialMergePushdownStrategy)) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            Verify.verify((boolean)v0);
            if (!SystemSessionProperties.isColocatedJoinEnabled(this.session) && FragmentTableScanCounter.hasMultipleTableScans(new PlanNode[]{left.getNode(), right.getNode()})) {
                rightPartitioning = left.getProperties().translate(this.createTranslator(leftToRight)).getNodePartitioning().get();
                right = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), this.selectExchangeScopeForPartitionedRemoteExchange(right.getNode()), right.getNode(), new PartitioningScheme(rightPartitioning, right.getNode().getOutputSymbols())), right.getProperties());
            }
            return this.buildJoin(node, left, right, JoinNode.DistributionType.PARTITIONED);
        }

        private PlanWithProperties planReplicatedJoin(JoinNode node, PlanWithProperties left) {
            PlanWithProperties right = node.getRight().accept(this, PreferredProperties.any());
            if (left.getProperties().isSingleNode()) {
                if (!right.getProperties().isSingleNode() || !SystemSessionProperties.isColocatedJoinEnabled(this.session) && FragmentTableScanCounter.hasMultipleTableScans(left.getNode(), right.getNode())) {
                    right = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, right.getNode()), right.getProperties());
                }
            } else {
                right = this.withDerivedProperties(ExchangeNode.replicatedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, right.getNode()), right.getProperties());
            }
            return this.buildJoin(node, left, right, JoinNode.DistributionType.REPLICATED);
        }

        private PlanWithProperties buildJoin(JoinNode node, PlanWithProperties newLeft, PlanWithProperties newRight, JoinNode.DistributionType newDistributionType) {
            JoinNode result = new JoinNode(node.getId(), node.getType(), newLeft.getNode(), newRight.getNode(), node.getCriteria(), node.getOutputSymbols(), node.getFilter(), node.getLeftHashSymbol(), node.getRightHashSymbol(), Optional.of(newDistributionType));
            return new PlanWithProperties(result, this.deriveProperties((PlanNode)result, (List<ActualProperties>)ImmutableList.of((Object)newLeft.getProperties(), (Object)newRight.getProperties())));
        }

        @Override
        public PlanWithProperties visitSpatialJoin(SpatialJoinNode node, PreferredProperties preferredProperties) {
            SpatialJoinNode.DistributionType distributionType = node.getDistributionType();
            PlanWithProperties left = node.getLeft().accept(this, PreferredProperties.any());
            PlanWithProperties right = node.getRight().accept(this, PreferredProperties.any());
            if (distributionType == SpatialJoinNode.DistributionType.REPLICATED) {
                if (left.getProperties().isSingleNode()) {
                    if (!right.getProperties().isSingleNode()) {
                        right = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, right.getNode()), right.getProperties());
                    }
                } else {
                    right = this.withDerivedProperties(ExchangeNode.replicatedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, right.getNode()), right.getProperties());
                }
            } else {
                left = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, left.getNode(), this.createPartitioning((List<Symbol>)ImmutableList.of((Object)node.getLeftPartitionSymbol().get())), Optional.empty()), left.getProperties());
                right = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, right.getNode(), this.createPartitioning((List<Symbol>)ImmutableList.of((Object)node.getRightPartitionSymbol().get())), Optional.empty()), right.getProperties());
            }
            PlanNode newJoinNode = node.replaceChildren((List<PlanNode>)ImmutableList.of((Object)left.getNode(), (Object)right.getNode()));
            return new PlanWithProperties(newJoinNode, this.deriveProperties(newJoinNode, (List<ActualProperties>)ImmutableList.of((Object)left.getProperties(), (Object)right.getProperties())));
        }

        @Override
        public PlanWithProperties visitUnnest(UnnestNode node, PreferredProperties preferredProperties) {
            PreferredProperties translatedPreferred = preferredProperties.translate(symbol -> node.getReplicateSymbols().contains(symbol) ? Optional.of(symbol) : Optional.empty());
            return this.rebaseAndDeriveProperties((PlanNode)node, this.planChild(node, translatedPreferred));
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public PlanWithProperties visitSemiJoin(SemiJoinNode node, PreferredProperties preferredProperties) {
            block13: {
                block12: {
                    distributionType = node.getDistributionType().orElseThrow((Supplier<IllegalArgumentException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$visitSemiJoin$10(), ()Ljava/lang/IllegalArgumentException;)());
                    if (distributionType != SemiJoinNode.DistributionType.PARTITIONED) break block12;
                    sourceSymbols = ImmutableList.of((Object)node.getSourceJoinSymbol());
                    filteringSourceSymbols = ImmutableList.of((Object)node.getFilteringSourceJoinSymbol());
                    sourceToFiltering = this.createMapping((List<T>)sourceSymbols, (List<T>)filteringSourceSymbols);
                    filteringToSource = this.createMapping((List<T>)filteringSourceSymbols, (List<T>)sourceSymbols);
                    source = node.getSource().accept(this, PreferredProperties.partitioned((Set<Symbol>)ImmutableSet.copyOf((Collection)sourceSymbols)));
                    if (source.getProperties().isNodePartitionedOn((Collection<Symbol>)sourceSymbols) && !source.getProperties().isSingleNode()) {
                        filteringPartitioning = source.getProperties().translate(this.createTranslator(sourceToFiltering)).getNodePartitioning().get();
                        filteringSource = node.getFilteringSource().accept(this, PreferredProperties.partitionedWithNullsAndAnyReplicated(filteringPartitioning));
                        if (!source.getProperties().withReplicatedNulls(true).isCompatibleTablePartitioningWith(filteringSource.getProperties(), (Function<Symbol, Set<Symbol>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(java.lang.Object ), (Lcom/facebook/presto/sql/planner/Symbol;)Ljava/util/Set;)(sourceToFiltering), AddExchanges.access$100(AddExchanges.this), this.session)) {
                            if (!filteringSource.getProperties().withReplicatedNulls(true).isRefinedPartitioningOver(source.getProperties(), (Function<Symbol, Set<Symbol>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(java.lang.Object ), (Lcom/facebook/presto/sql/planner/Symbol;)Ljava/util/Set;)(filteringToSource), AddExchanges.access$100(AddExchanges.this), this.session) || !AddExchanges.access$200(AddExchanges.this, filteringSource.getNode(), this.partialMergePushdownStrategy)) {
                                filteringSource = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, filteringSource.getNode(), new PartitioningScheme(filteringPartitioning, filteringSource.getNode().getOutputSymbols(), Optional.empty(), true, Optional.empty())), filteringSource.getProperties());
                            }
                        }
                    } else {
                        filteringSource = node.getFilteringSource().accept(this, PreferredProperties.partitionedWithNullsAndAnyReplicated((Set<Symbol>)ImmutableSet.copyOf((Collection)filteringSourceSymbols)));
                        if (filteringSource.getProperties().isNodePartitionedOn((Collection<Symbol>)filteringSourceSymbols, true) && !filteringSource.getProperties().isSingleNode()) {
                            sourcePartitioning = filteringSource.getProperties().translate(this.createTranslator(filteringToSource)).getNodePartitioning().get();
                            source = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, source.getNode(), new PartitioningScheme(sourcePartitioning, source.getNode().getOutputSymbols())), source.getProperties());
                        } else {
                            source = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, source.getNode(), this.createPartitioning((List<Symbol>)sourceSymbols), Optional.empty()), source.getProperties());
                            filteringSource = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, filteringSource.getNode(), this.createPartitioning((List<Symbol>)filteringSourceSymbols), Optional.empty(), true), filteringSource.getProperties());
                        }
                    }
                    if (source.getProperties().withReplicatedNulls(true).isCompatibleTablePartitioningWith(filteringSource.getProperties(), (Function<Symbol, Set<Symbol>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(java.lang.Object ), (Lcom/facebook/presto/sql/planner/Symbol;)Ljava/util/Set;)(sourceToFiltering), AddExchanges.access$100(AddExchanges.this), this.session)) ** GOTO lbl-1000
                    if (filteringSource.getProperties().withReplicatedNulls(true).isRefinedPartitioningOver(source.getProperties(), (Function<Symbol, Set<Symbol>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(java.lang.Object ), (Lcom/facebook/presto/sql/planner/Symbol;)Ljava/util/Set;)(filteringToSource), AddExchanges.access$100(AddExchanges.this), this.session) && AddExchanges.access$200(AddExchanges.this, filteringSource.getNode(), this.partialMergePushdownStrategy)) lbl-1000:
                    // 2 sources

                    {
                        v0 = true;
                    } else {
                        v0 = false;
                    }
                    Verify.verify((boolean)v0);
                    if (!SystemSessionProperties.isColocatedJoinEnabled(this.session) && FragmentTableScanCounter.hasMultipleTableScans(new PlanNode[]{source.getNode(), filteringSource.getNode()})) {
                        filteringPartitioning = source.getProperties().translate(this.createTranslator(sourceToFiltering)).getNodePartitioning().get();
                        filteringSource = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, filteringSource.getNode(), new PartitioningScheme(filteringPartitioning, filteringSource.getNode().getOutputSymbols(), Optional.empty(), true, Optional.empty())), filteringSource.getProperties());
                    }
                    break block13;
                }
                source = node.getSource().accept(this, PreferredProperties.any());
                filteringSource = node.getFilteringSource().accept(this, PreferredProperties.any());
                if (source.getProperties().isSingleNode()) {
                    if (!filteringSource.getProperties().isSingleNode() || !SystemSessionProperties.isColocatedJoinEnabled(this.session) && FragmentTableScanCounter.hasMultipleTableScans(new PlanNode[]{source.getNode(), filteringSource.getNode()})) {
                        filteringSource = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, filteringSource.getNode()), filteringSource.getProperties());
                    }
                } else {
                    filteringSource = this.withDerivedProperties(ExchangeNode.replicatedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, filteringSource.getNode()), filteringSource.getProperties());
                }
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, (List<PlanWithProperties>)ImmutableList.of((Object)source, (Object)filteringSource));
        }

        @Override
        public PlanWithProperties visitIndexJoin(IndexJoinNode node, PreferredProperties preferredProperties) {
            List joinColumns = (List)node.getCriteria().stream().map(IndexJoinNode.EquiJoinClause::getProbe).collect(ImmutableList.toImmutableList());
            Object desiredLocalProperties = preferredProperties.getLocalProperties().isEmpty() ? LocalProperties.grouped(joinColumns) : ImmutableList.of();
            PlanWithProperties probeSource = node.getProbeSource().accept(this, PreferredProperties.partitionedWithLocal((Set<Symbol>)ImmutableSet.copyOf((Collection)joinColumns), (List<? extends LocalProperty<Symbol>>)desiredLocalProperties).mergeWithParent(preferredProperties));
            ActualProperties probeProperties = probeSource.getProperties();
            PlanWithProperties indexSource = node.getIndexSource().accept(this, PreferredProperties.any());
            if (this.shouldRepartitionForIndexJoin(joinColumns, preferredProperties, probeProperties)) {
                probeSource = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, probeSource.getNode(), this.createPartitioning(joinColumns), node.getProbeHashSymbol()), probeProperties);
            }
            PlanNode result = ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)probeSource.getNode(), (Object)node.getIndexSource()));
            return new PlanWithProperties(result, this.deriveProperties(result, (List<ActualProperties>)ImmutableList.of((Object)probeSource.getProperties(), (Object)indexSource.getProperties())));
        }

        private boolean shouldRepartitionForIndexJoin(List<Symbol> joinColumns, PreferredProperties parentPreferredProperties, ActualProperties probeProperties) {
            if (!this.distributedIndexJoins) {
                return false;
            }
            if (probeProperties.isSingleNode()) {
                return false;
            }
            Optional<Boolean> parentPartitioningPreferences = parentPreferredProperties.getGlobalProperties().flatMap(PreferredProperties.Global::getPartitioningProperties);
            boolean parentAlreadyPartitionedOnChild = parentPartitioningPreferences.map(partitioning -> probeProperties.isStreamPartitionedOn(partitioning.getPartitioningColumns())).orElse(false);
            if (this.preferStreamingOperators && parentAlreadyPartitionedOnChild) {
                return false;
            }
            if (!probeProperties.isStreamPartitionedOn(joinColumns)) {
                return true;
            }
            return probeProperties.isEffectivelySingleStream() && probeProperties.isStreamRepartitionEffective(joinColumns);
        }

        @Override
        public PlanWithProperties visitIndexSource(IndexSourceNode node, PreferredProperties preferredProperties) {
            return new PlanWithProperties(node, ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build());
        }

        private Function<Symbol, Optional<Symbol>> outputToInputTranslator(UnionNode node, int sourceIndex) {
            return symbol -> Optional.of(node.getSymbolMapping().get(symbol).get(sourceIndex));
        }

        private Partitioning selectUnionPartitioning(UnionNode node, PreferredProperties.PartitioningProperties parentPreference) {
            if (parentPreference.getPartitioning().isPresent()) {
                return parentPreference.getPartitioning().get();
            }
            boolean nullsAndAnyReplicated = parentPreference.isNullsAndAnyReplicated();
            for (int sourceIndex = 0; sourceIndex < node.getSources().size(); ++sourceIndex) {
                PreferredProperties.PartitioningProperties childPartitioning = parentPreference.translate(this.outputToInputTranslator(node, sourceIndex)).get();
                PreferredProperties childPreferred = PreferredProperties.builder().global(PreferredProperties.Global.distributed(childPartitioning.withNullsAndAnyReplicated(nullsAndAnyReplicated))).build();
                PlanWithProperties child = node.getSources().get(sourceIndex).accept(this, childPreferred);
                if (!child.getProperties().isNodePartitionedOn(childPartitioning.getPartitioningColumns(), nullsAndAnyReplicated) || child.getProperties().isSingleNode()) continue;
                Function<Symbol, Optional<Symbol>> childToParent = this.createTranslator(this.createMapping(node.sourceOutputLayout(sourceIndex), node.getOutputSymbols()));
                return child.getProperties().translate(childToParent).getNodePartitioning().get();
            }
            return this.createPartitioning((List<Symbol>)ImmutableList.copyOf(parentPreference.getPartitioningColumns()));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public PlanWithProperties visitUnion(UnionNode node, PreferredProperties parentPreference) {
            PlanNode result;
            Optional<PreferredProperties.Global> parentPartitioningPreference = parentPreference.getGlobalProperties();
            if (parentPartitioningPreference.isPresent() && parentPartitioningPreference.get().isDistributed() && parentPartitioningPreference.get().getPartitioningProperties().isPresent()) {
                PreferredProperties.PartitioningProperties parentPartitioningProperties = parentPartitioningPreference.get().getPartitioningProperties().get();
                boolean nullsAndAnyReplicated = parentPartitioningProperties.isNullsAndAnyReplicated();
                Partitioning desiredParentPartitioning = this.selectUnionPartitioning(node, parentPartitioningProperties);
                ImmutableList.Builder partitionedSources = ImmutableList.builder();
                ImmutableListMultimap.Builder outputToSourcesMapping = ImmutableListMultimap.builder();
                for (int sourceIndex = 0; sourceIndex < node.getSources().size(); ++sourceIndex) {
                    void var12_23;
                    Partitioning childPartitioning = desiredParentPartitioning.translate(this.createDirectTranslator(this.createMapping(node.getOutputSymbols(), node.sourceOutputLayout(sourceIndex))));
                    PreferredProperties childPreferred = PreferredProperties.builder().global(PreferredProperties.Global.distributed(PreferredProperties.PartitioningProperties.partitioned(childPartitioning).withNullsAndAnyReplicated(nullsAndAnyReplicated))).build();
                    PlanWithProperties planWithProperties = node.getSources().get(sourceIndex).accept(this, childPreferred);
                    if (!(planWithProperties.getProperties().isCompatibleTablePartitioningWith(childPartitioning, nullsAndAnyReplicated, AddExchanges.this.metadata, this.session) || planWithProperties.getProperties().isRefinedPartitioningOver(childPartitioning, nullsAndAnyReplicated, AddExchanges.this.metadata, this.session) && AddExchanges.this.canPushdownPartialMerge(planWithProperties.getNode(), this.partialMergePushdownStrategy))) {
                        PlanWithProperties planWithProperties2 = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, planWithProperties.getNode(), new PartitioningScheme(childPartitioning, planWithProperties.getNode().getOutputSymbols(), Optional.empty(), nullsAndAnyReplicated, Optional.empty())), planWithProperties.getProperties());
                    }
                    partitionedSources.add((Object)var12_23.getNode());
                    for (int column = 0; column < node.getOutputSymbols().size(); ++column) {
                        outputToSourcesMapping.put((Object)node.getOutputSymbols().get(column), (Object)node.sourceOutputLayout(sourceIndex).get(column));
                    }
                }
                UnionNode newNode = new UnionNode(node.getId(), (List<PlanNode>)partitionedSources.build(), (ListMultimap<Symbol, Symbol>)outputToSourcesMapping.build(), (List<Symbol>)ImmutableList.copyOf((Collection)outputToSourcesMapping.build().keySet()));
                return new PlanWithProperties(newNode, ActualProperties.builder().global(ActualProperties.Global.partitionedOn(desiredParentPartitioning, Optional.of(desiredParentPartitioning))).build().withReplicatedNulls(parentPartitioningProperties.isNullsAndAnyReplicated()));
            }
            ArrayList<PlanNode> singleNodeChildren = new ArrayList<PlanNode>();
            ArrayList<List<Symbol>> singleNodeOutputLayouts = new ArrayList<List<Symbol>>();
            ArrayList<PlanNode> distributedChildren = new ArrayList<PlanNode>();
            ArrayList<List<Symbol>> distributedOutputLayouts = new ArrayList<List<Symbol>>();
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanWithProperties child = node.getSources().get(i).accept(this, PreferredProperties.any());
                if (child.getProperties().isSingleNode()) {
                    singleNodeChildren.add(child.getNode());
                    singleNodeOutputLayouts.add(node.sourceOutputLayout(i));
                    continue;
                }
                distributedChildren.add(child.getNode());
                distributedOutputLayouts.add(node.sourceOutputLayout(i));
            }
            if (!distributedChildren.isEmpty() && singleNodeChildren.isEmpty()) {
                if (!parentPartitioningPreference.isPresent() || parentPartitioningPreference.get().isDistributed()) {
                    return this.arbitraryDistributeUnion(node, distributedChildren, distributedOutputLayouts);
                }
                result = new ExchangeNode(this.idAllocator.getNextId(), ExchangeNode.Type.GATHER, ExchangeNode.Scope.REMOTE_STREAMING, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), node.getOutputSymbols()), distributedChildren, distributedOutputLayouts, Optional.empty());
            } else if (!singleNodeChildren.isEmpty()) {
                if (!distributedChildren.isEmpty()) {
                    List exchangeOutputLayout = (List)node.getOutputSymbols().stream().map(outputSymbol -> this.symbolAllocator.newSymbol(outputSymbol.getName(), this.types.get((Symbol)outputSymbol))).collect(ImmutableList.toImmutableList());
                    ExchangeNode result2 = new ExchangeNode(this.idAllocator.getNextId(), ExchangeNode.Type.GATHER, ExchangeNode.Scope.REMOTE_STREAMING, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), exchangeOutputLayout), distributedChildren, distributedOutputLayouts, Optional.empty());
                    singleNodeChildren.add(result2);
                    singleNodeOutputLayouts.add(((PlanNode)result2).getOutputSymbols());
                }
                ImmutableListMultimap.Builder mappings = ImmutableListMultimap.builder();
                for (int i = 0; i < node.getOutputSymbols().size(); ++i) {
                    for (List list : singleNodeOutputLayouts) {
                        mappings.put((Object)node.getOutputSymbols().get(i), list.get(i));
                    }
                }
                result = new UnionNode(node.getId(), singleNodeChildren, (ListMultimap<Symbol, Symbol>)mappings.build(), (List<Symbol>)ImmutableList.copyOf((Collection)mappings.build().keySet()));
            } else {
                throw new IllegalStateException("both singleNodeChildren distributedChildren are empty");
            }
            return new PlanWithProperties(result, ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build());
        }

        private PlanWithProperties arbitraryDistributeUnion(UnionNode node, List<PlanNode> distributedChildren, List<List<Symbol>> distributedOutputLayouts) {
            if (FragmentTableScanCounter.getNumberOfTableScans(distributedChildren) == 0) {
                return new PlanWithProperties(node.replaceChildren(distributedChildren));
            }
            return new PlanWithProperties(new ExchangeNode(this.idAllocator.getNextId(), ExchangeNode.Type.REPARTITION, ExchangeNode.Scope.REMOTE_STREAMING, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), node.getOutputSymbols()), distributedChildren, distributedOutputLayouts, Optional.empty()));
        }

        @Override
        public PlanWithProperties visitApply(ApplyNode node, PreferredProperties preferredProperties) {
            throw new IllegalStateException("Unexpected node: " + node.getClass().getName());
        }

        @Override
        public PlanWithProperties visitLateralJoin(LateralJoinNode node, PreferredProperties preferredProperties) {
            throw new IllegalStateException("Unexpected node: " + node.getClass().getName());
        }

        private PlanWithProperties planChild(PlanNode node, PreferredProperties preferredProperties) {
            return ((PlanNode)Iterables.getOnlyElement(node.getSources())).accept(this, preferredProperties);
        }

        private PlanWithProperties rebaseAndDeriveProperties(PlanNode node, PlanWithProperties child) {
            return this.withDerivedProperties(ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)child.getNode())), child.getProperties());
        }

        private PlanWithProperties rebaseAndDeriveProperties(PlanNode node, List<PlanWithProperties> children) {
            PlanNode result = node.replaceChildren(children.stream().map(PlanWithProperties::getNode).collect(Collectors.toList()));
            return new PlanWithProperties(result, this.deriveProperties(result, children.stream().map(PlanWithProperties::getProperties).collect(Collectors.toList())));
        }

        private PlanWithProperties withDerivedProperties(PlanNode node, ActualProperties inputProperties) {
            return new PlanWithProperties(node, this.deriveProperties(node, inputProperties));
        }

        private ActualProperties deriveProperties(PlanNode result, ActualProperties inputProperties) {
            return this.deriveProperties(result, (List<ActualProperties>)ImmutableList.of((Object)inputProperties));
        }

        private ActualProperties deriveProperties(PlanNode result, List<ActualProperties> inputProperties) {
            ActualProperties outputProperties = PropertyDerivations.deriveProperties(result, inputProperties, AddExchanges.this.metadata, this.session, this.types, AddExchanges.this.parser);
            Verify.verify((result instanceof SemiJoinNode || inputProperties.stream().noneMatch(ActualProperties::isNullsAndAnyReplicated) || outputProperties.isNullsAndAnyReplicated() ? 1 : 0) != 0, (String)"SemiJoinNode is the only node that can strip null replication", (Object[])new Object[0]);
            return outputProperties;
        }

        private ActualProperties derivePropertiesRecursively(PlanNode result) {
            return PropertyDerivations.derivePropertiesRecursively(result, AddExchanges.this.metadata, this.session, this.types, AddExchanges.this.parser);
        }

        private Partitioning createPartitioning(List<Symbol> partitioningColumns) {
            if ("system".equals(this.partitioningProviderCatalog)) {
                return Partitioning.create(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, (List<Symbol>)ImmutableList.copyOf(partitioningColumns));
            }
            List partitioningTypes = (List)partitioningColumns.stream().map(column -> this.symbolAllocator.getTypes().get((Symbol)column)).collect(ImmutableList.toImmutableList());
            PartitioningHandle partitioningHandle = AddExchanges.this.metadata.getPartitioningHandleForExchange(this.session, this.partitioningProviderCatalog, this.hashPartitionCount, partitioningTypes);
            return Partitioning.create(partitioningHandle, partitioningColumns);
        }

        private ExchangeNode.Scope selectExchangeScopeForPartitionedRemoteExchange(PlanNode exchangeSource) {
            if (exchangeSource.getOutputSymbols().isEmpty()) {
                return ExchangeNode.Scope.REMOTE_STREAMING;
            }
            switch (this.exchangeMaterializationStrategy) {
                case ALL: {
                    return ExchangeNode.Scope.REMOTE_MATERIALIZED;
                }
                case NONE: {
                    return ExchangeNode.Scope.REMOTE_STREAMING;
                }
            }
            throw new IllegalStateException("Unexpected exchange materialization strategy: " + (Object)((Object)this.exchangeMaterializationStrategy));
        }

        private static /* synthetic */ IllegalArgumentException lambda$visitSemiJoin$10() {
            return new IllegalArgumentException("distributionType not yet set");
        }
    }
}

