/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class RemoveTrivialFilters
implements Rule<FilterNode> {
    private static final Pattern<FilterNode> PATTERN = Patterns.filter();

    @Override
    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
        Expression predicate = OriginalExpressionUtils.castToExpression(filterNode.getPredicate());
        if (predicate.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
            return Rule.Result.ofPlanNode(filterNode.getSource());
        }
        if (predicate.equals((Object)BooleanLiteral.FALSE_LITERAL)) {
            return Rule.Result.ofPlanNode(new ValuesNode(context.getIdAllocator().getNextId(), filterNode.getOutputSymbols(), (List<List<RowExpression>>)ImmutableList.of()));
        }
        return Rule.Result.empty();
    }
}

