/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.rule.ProjectOffPushDownRule;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.util.MoreLists;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class PruneValuesColumns
extends ProjectOffPushDownRule<ValuesNode> {
    public PruneValuesColumns() {
        super(Patterns.values());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(PlanNodeIdAllocator idAllocator, ValuesNode valuesNode, Set<Symbol> referencedOutputs) {
        List<Symbol> newOutputs = MoreLists.filteredCopy(valuesNode.getOutputSymbols(), referencedOutputs::contains);
        int[] mapping = new int[newOutputs.size()];
        for (int i = 0; i < mapping.length; ++i) {
            mapping[i] = valuesNode.getOutputSymbols().indexOf(newOutputs.get(i));
        }
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        for (List<RowExpression> row : valuesNode.getRows()) {
            rowsBuilder.add(Arrays.stream(mapping).mapToObj(row::get).collect(Collectors.toList()));
        }
        return Optional.of(new ValuesNode(valuesNode.getId(), newOutputs, (List<List<RowExpression>>)rowsBuilder.build()));
    }
}

