/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class PruneOrderByInAggregation
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation();
    private final FunctionManager functionManager;

    public PruneOrderByInAggregation(FunctionManager functionManager) {
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode node, Captures captures, Rule.Context context) {
        if (!node.hasOrderings()) {
            return Rule.Result.empty();
        }
        boolean anyRewritten = false;
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : node.getAggregations().entrySet()) {
            AggregationNode.Aggregation aggregation = entry.getValue();
            if (!aggregation.getCall().getOrderBy().isPresent()) {
                aggregations.put(entry);
                continue;
            }
            if (this.functionManager.getAggregateFunctionImplementation(aggregation.getFunctionHandle()).isOrderSensitive()) {
                aggregations.put(entry);
                continue;
            }
            anyRewritten = true;
            FunctionCall rewritten = new FunctionCall(aggregation.getCall().getName(), aggregation.getCall().isDistinct(), aggregation.getCall().getArguments(), aggregation.getCall().getFilter());
            aggregations.put((Object)entry.getKey(), (Object)new AggregationNode.Aggregation(rewritten, aggregation.getFunctionHandle(), aggregation.getMask()));
        }
        if (!anyRewritten) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(new AggregationNode(node.getId(), node.getSource(), (Map<Symbol, AggregationNode.Aggregation>)aggregations.build(), node.getGroupingSets(), node.getPreGroupedSymbols(), node.getStep(), node.getHashSymbol(), node.getGroupIdSymbol()));
    }
}

