/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.rule.ProjectOffPushDownRule;
import com.facebook.presto.sql.planner.iterative.rule.Util;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class PruneCrossJoinColumns
extends ProjectOffPushDownRule<JoinNode> {
    public PruneCrossJoinColumns() {
        super(Patterns.join().matching(JoinNode::isCrossJoin));
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(PlanNodeIdAllocator idAllocator, JoinNode joinNode, Set<Symbol> referencedOutputs) {
        Optional<PlanNode> newLeft = Util.restrictOutputs(idAllocator, joinNode.getLeft(), referencedOutputs);
        Optional<PlanNode> newRight = Util.restrictOutputs(idAllocator, joinNode.getRight(), referencedOutputs);
        if (!newLeft.isPresent() && !newRight.isPresent()) {
            return Optional.empty();
        }
        ImmutableList.Builder outputSymbolBuilder = ImmutableList.builder();
        outputSymbolBuilder.addAll(newLeft.orElse(joinNode.getLeft()).getOutputSymbols());
        outputSymbolBuilder.addAll(newRight.orElse(joinNode.getRight()).getOutputSymbols());
        return Optional.of(new JoinNode(idAllocator.getNextId(), joinNode.getType(), newLeft.orElse(joinNode.getLeft()), newRight.orElse(joinNode.getRight()), joinNode.getCriteria(), (List<Symbol>)outputSymbolBuilder.build(), joinNode.getFilter(), joinNode.getLeftHashSymbol(), joinNode.getRightHashSymbol(), joinNode.getDistributionType()));
    }
}

