/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.operator.scalar.TryFunction;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.ExpressionDomainTranslator;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.planner.LookupSymbolResolver;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolsExtractor;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PreconditionRules;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.NullLiteral;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PickTableLayout {
    private final Metadata metadata;
    private final SqlParser parser;
    private final ExpressionDomainTranslator domainTranslator;

    public PickTableLayout(Metadata metadata, SqlParser parser) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.parser = Objects.requireNonNull(parser, "parser is null");
        this.domainTranslator = new ExpressionDomainTranslator(new LiteralEncoder(metadata.getBlockEncodingSerde()));
    }

    public Set<Rule<?>> rules() {
        return ImmutableSet.of(PreconditionRules.checkRulesAreFiredBeforeAddExchangesRule(), (Object)this.pickTableLayoutForPredicate(), (Object)this.pickTableLayoutWithoutPredicate());
    }

    public PickTableLayoutForPredicate pickTableLayoutForPredicate() {
        return new PickTableLayoutForPredicate(this.metadata, this.parser, this.domainTranslator);
    }

    public PickTableLayoutWithoutPredicate pickTableLayoutWithoutPredicate() {
        return new PickTableLayoutWithoutPredicate(this.metadata);
    }

    public static PlanNode pushPredicateIntoTableScan(TableScanNode node, Expression predicate, boolean pruneWithPredicateExpression, Session session, TypeProvider types, PlanNodeIdAllocator idAllocator, Metadata metadata, SqlParser parser, ExpressionDomainTranslator domainTranslator) {
        Constraint constraint;
        Expression deterministicPredicate = ExpressionUtils.filterDeterministicConjuncts(predicate);
        ExpressionDomainTranslator.ExtractionResult decomposedPredicate = ExpressionDomainTranslator.fromPredicate(metadata, session, deterministicPredicate, types);
        TupleDomain newDomain = decomposedPredicate.getTupleDomain().transform(node.getAssignments()::get).intersect(node.getEnforcedConstraint());
        ImmutableBiMap assignments = ImmutableBiMap.copyOf(node.getAssignments()).inverse();
        if (pruneWithPredicateExpression) {
            Expression[] expressionArray = new Expression[2];
            expressionArray[0] = deterministicPredicate;
            expressionArray[1] = domainTranslator.toPredicate((TupleDomain<Symbol>)newDomain.simplify().transform(((Map)assignments)::get));
            LayoutConstraintEvaluator evaluator = new LayoutConstraintEvaluator(metadata, parser, session, types, node.getAssignments(), ExpressionUtils.combineConjuncts(expressionArray));
            constraint = new Constraint(newDomain, x$0 -> evaluator.isCandidate(x$0));
        } else {
            constraint = new Constraint(newDomain);
        }
        if (constraint.getSummary().isNone()) {
            return new ValuesNode(idAllocator.getNextId(), node.getOutputSymbols(), (List<List<RowExpression>>)ImmutableList.of());
        }
        TableLayoutResult layout = metadata.getLayout(session, node.getTable(), (Constraint<ColumnHandle>)constraint, Optional.of(node.getOutputSymbols().stream().map(node.getAssignments()::get).collect(ImmutableSet.toImmutableSet())));
        if (layout.getLayout().getPredicate().isNone()) {
            return new ValuesNode(idAllocator.getNextId(), node.getOutputSymbols(), (List<List<RowExpression>>)ImmutableList.of());
        }
        TableScanNode tableScan = new TableScanNode(node.getId(), layout.getLayout().getNewTableHandle(), node.getOutputSymbols(), node.getAssignments(), layout.getLayout().getPredicate(), TableLayoutResult.computeEnforced((TupleDomain<ColumnHandle>)newDomain, layout.getUnenforcedConstraint()));
        Expression[] expressionArray = new Expression[3];
        expressionArray[0] = domainTranslator.toPredicate((TupleDomain<Symbol>)layout.getUnenforcedConstraint().transform(((Map)assignments)::get));
        expressionArray[1] = ExpressionUtils.filterNonDeterministicConjuncts(predicate);
        expressionArray[2] = decomposedPredicate.getRemainingExpression();
        Expression resultingPredicate = ExpressionUtils.combineConjuncts(expressionArray);
        if (!BooleanLiteral.TRUE_LITERAL.equals((Object)resultingPredicate)) {
            return new FilterNode(idAllocator.getNextId(), tableScan, OriginalExpressionUtils.castToRowExpression(resultingPredicate));
        }
        return tableScan;
    }

    private static class LayoutConstraintEvaluator {
        private final Map<Symbol, ColumnHandle> assignments;
        private final ExpressionInterpreter evaluator;
        private final Set<ColumnHandle> arguments;

        public LayoutConstraintEvaluator(Metadata metadata, SqlParser parser, Session session, TypeProvider types, Map<Symbol, ColumnHandle> assignments, Expression expression) {
            this.assignments = assignments;
            Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(session, metadata, parser, types, expression, Collections.emptyList(), WarningCollector.NOOP);
            this.evaluator = ExpressionInterpreter.expressionOptimizer(expression, metadata, session, expressionTypes);
            this.arguments = (Set)SymbolsExtractor.extractUnique(expression).stream().map(assignments::get).collect(ImmutableSet.toImmutableSet());
        }

        private boolean isCandidate(Map<ColumnHandle, NullableValue> bindings) {
            if (Sets.intersection(bindings.keySet(), this.arguments).isEmpty()) {
                return true;
            }
            LookupSymbolResolver inputs = new LookupSymbolResolver(this.assignments, bindings);
            Boolean optimized = TryFunction.evaluate(() -> this.evaluator.optimize(inputs), true);
            return !Boolean.FALSE.equals(optimized) && optimized != null && !(optimized instanceof NullLiteral);
        }
    }

    private static final class PickTableLayoutWithoutPredicate
    implements Rule<TableScanNode> {
        private final Metadata metadata;
        private static final Pattern<TableScanNode> PATTERN = Patterns.tableScan();

        private PickTableLayoutWithoutPredicate(Metadata metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        }

        @Override
        public Pattern<TableScanNode> getPattern() {
            return PATTERN;
        }

        @Override
        public boolean isEnabled(Session session) {
            return SystemSessionProperties.isNewOptimizerEnabled(session);
        }

        @Override
        public Rule.Result apply(TableScanNode tableScanNode, Captures captures, Rule.Context context) {
            if (tableScanNode.getTable().getLayout().isPresent()) {
                return Rule.Result.empty();
            }
            TableLayoutResult layout = this.metadata.getLayout(context.getSession(), tableScanNode.getTable(), (Constraint<ColumnHandle>)Constraint.alwaysTrue(), Optional.of(tableScanNode.getOutputSymbols().stream().map(tableScanNode.getAssignments()::get).collect(ImmutableSet.toImmutableSet())));
            if (layout.getLayout().getPredicate().isNone()) {
                return Rule.Result.ofPlanNode(new ValuesNode(context.getIdAllocator().getNextId(), tableScanNode.getOutputSymbols(), (List<List<RowExpression>>)ImmutableList.of()));
            }
            return Rule.Result.ofPlanNode(new TableScanNode(tableScanNode.getId(), layout.getLayout().getNewTableHandle(), tableScanNode.getOutputSymbols(), tableScanNode.getAssignments(), layout.getLayout().getPredicate(), (TupleDomain<ColumnHandle>)TupleDomain.all()));
        }
    }

    private static final class PickTableLayoutForPredicate
    implements Rule<FilterNode> {
        private final Metadata metadata;
        private final SqlParser parser;
        private final ExpressionDomainTranslator domainTranslator;
        private static final Capture<TableScanNode> TABLE_SCAN = Capture.newCapture();
        private static final Pattern<FilterNode> PATTERN = Patterns.filter().with(Patterns.source().matching(Patterns.tableScan().capturedAs(TABLE_SCAN)));

        private PickTableLayoutForPredicate(Metadata metadata, SqlParser parser, ExpressionDomainTranslator domainTranslator) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.parser = Objects.requireNonNull(parser, "parser is null");
            this.domainTranslator = Objects.requireNonNull(domainTranslator, "domainTranslator is null");
        }

        @Override
        public Pattern<FilterNode> getPattern() {
            return PATTERN;
        }

        @Override
        public boolean isEnabled(Session session) {
            return SystemSessionProperties.isNewOptimizerEnabled(session);
        }

        @Override
        public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
            PlanNode rewritten;
            TableScanNode tableScan = (TableScanNode)captures.get(TABLE_SCAN);
            if (this.arePlansSame(filterNode, tableScan, rewritten = PickTableLayout.pushPredicateIntoTableScan(tableScan, OriginalExpressionUtils.castToExpression(filterNode.getPredicate()), false, context.getSession(), context.getSymbolAllocator().getTypes(), context.getIdAllocator(), this.metadata, this.parser, this.domainTranslator))) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(rewritten);
        }

        private boolean arePlansSame(FilterNode filter, TableScanNode tableScan, PlanNode rewritten) {
            if (!(rewritten instanceof FilterNode)) {
                return false;
            }
            FilterNode rewrittenFilter = (FilterNode)rewritten;
            if (!Objects.equals(filter.getPredicate(), rewrittenFilter.getPredicate())) {
                return false;
            }
            if (!(rewrittenFilter.getSource() instanceof TableScanNode)) {
                return false;
            }
            TableScanNode rewrittenTableScan = (TableScanNode)rewrittenFilter.getSource();
            if (!tableScan.getTable().equals(rewrittenTableScan.getTable())) {
                return false;
            }
            return Objects.equals(tableScan.getCurrentConstraint(), rewrittenTableScan.getCurrentConstraint()) && Objects.equals(tableScan.getEnforcedConstraint(), rewrittenTableScan.getEnforcedConstraint());
        }
    }
}

