/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class ImplementBernoulliSampleAsFilter
implements Rule<SampleNode> {
    private static final Pattern<SampleNode> PATTERN = Patterns.sample().with(Patterns.Sample.sampleType().equalTo((Object)SampleNode.Type.BERNOULLI));

    @Override
    public Pattern<SampleNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(SampleNode sample, Captures captures, Rule.Context context) {
        return Rule.Result.ofPlanNode(new FilterNode(sample.getId(), sample.getSource(), OriginalExpressionUtils.castToRowExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new FunctionCall(QualifiedName.of((String)"rand"), (List)ImmutableList.of()), (Expression)new DoubleLiteral(Double.toString(sample.getSampleRatio()))))));
    }
}

