/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.SortExpressionContext;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class SortExpressionExtractor {
    private SortExpressionExtractor() {
    }

    public static Optional<SortExpressionContext> extractSortExpression(Set<Symbol> buildSymbols, Expression filter) {
        List<Expression> filterConjuncts = ExpressionUtils.extractConjuncts(filter);
        SortExpressionVisitor visitor = new SortExpressionVisitor(buildSymbols);
        List sortExpressionCandidates = (List)filterConjuncts.stream().filter(DeterminismEvaluator::isDeterministic).map(arg_0 -> ((SortExpressionVisitor)visitor).process(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(SortExpressionContext::getSortExpression, Function.identity(), SortExpressionExtractor::merge)).values().stream().collect(ImmutableList.toImmutableList());
        return sortExpressionCandidates.stream().sorted(Comparator.comparing(context -> -1 * context.getSearchExpressions().size())).findFirst();
    }

    private static SortExpressionContext merge(SortExpressionContext left, SortExpressionContext right) {
        Preconditions.checkArgument((boolean)left.getSortExpression().equals((Object)right.getSortExpression()));
        ImmutableList.Builder searchExpressions = ImmutableList.builder();
        searchExpressions.addAll(left.getSearchExpressions());
        searchExpressions.addAll(right.getSearchExpressions());
        return new SortExpressionContext(left.getSortExpression(), (List<Expression>)searchExpressions.build());
    }

    private static Optional<SymbolReference> asBuildSymbolReference(Set<Symbol> buildLayout, Expression expression) {
        SymbolReference symbolReference;
        if (expression instanceof SymbolReference && buildLayout.contains(new Symbol((symbolReference = (SymbolReference)expression).getName()))) {
            return Optional.of(symbolReference);
        }
        return Optional.empty();
    }

    private static boolean hasBuildSymbolReference(Set<Symbol> buildSymbols, Expression expression) {
        return (Boolean)new BuildSymbolReferenceFinder(buildSymbols).process((Node)expression);
    }

    private static class BuildSymbolReferenceFinder
    extends AstVisitor<Boolean, Void> {
        private final Set<String> buildSymbols;

        public BuildSymbolReferenceFinder(Set<Symbol> buildSymbols) {
            this.buildSymbols = (Set)Objects.requireNonNull(buildSymbols, "buildSymbols is null").stream().map(Symbol::getName).collect(ImmutableSet.toImmutableSet());
        }

        protected Boolean visitNode(Node node, Void context) {
            for (Node child : node.getChildren()) {
                if (!((Boolean)this.process(child, context)).booleanValue()) continue;
                return true;
            }
            return false;
        }

        protected Boolean visitSymbolReference(SymbolReference symbolReference, Void context) {
            return this.buildSymbols.contains(symbolReference.getName());
        }
    }

    private static class SortExpressionVisitor
    extends AstVisitor<Optional<SortExpressionContext>, Void> {
        private final Set<Symbol> buildSymbols;

        public SortExpressionVisitor(Set<Symbol> buildSymbols) {
            this.buildSymbols = buildSymbols;
        }

        protected Optional<SortExpressionContext> visitExpression(Expression expression, Void context) {
            return Optional.empty();
        }

        protected Optional<SortExpressionContext> visitComparisonExpression(ComparisonExpression comparison, Void context) {
            switch (comparison.getOperator()) {
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    Optional sortChannel = SortExpressionExtractor.asBuildSymbolReference(this.buildSymbols, comparison.getRight());
                    boolean hasBuildReferencesOnOtherSide = SortExpressionExtractor.hasBuildSymbolReference(this.buildSymbols, comparison.getLeft());
                    if (!sortChannel.isPresent()) {
                        sortChannel = SortExpressionExtractor.asBuildSymbolReference(this.buildSymbols, comparison.getLeft());
                        hasBuildReferencesOnOtherSide = SortExpressionExtractor.hasBuildSymbolReference(this.buildSymbols, comparison.getRight());
                    }
                    if (sortChannel.isPresent() && !hasBuildReferencesOnOtherSide) {
                        return sortChannel.map(symbolReference -> new SortExpressionContext((Expression)symbolReference, Collections.singletonList(comparison)));
                    }
                    return Optional.empty();
                }
            }
            return Optional.empty();
        }
    }
}

