/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.sql.NodeUtils;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.FieldId;
import com.facebook.presto.sql.analyzer.RelationId;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.planner.GroupingOperationRewriter;
import com.facebook.presto.sql.planner.OrderingScheme;
import com.facebook.presto.sql.planner.PlanBuilder;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.RelationPlanner;
import com.facebook.presto.sql.planner.SubqueryPlanner;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.TranslationMap;
import com.facebook.presto.sql.planner.optimizations.WindowNodeUtil;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GroupBy;
import com.facebook.presto.sql.tree.GroupingOperation;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;

class QueryPlanner {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaDeclarationToSymbolMap;
    private final Metadata metadata;
    private final Session session;
    private final SubqueryPlanner subqueryPlanner;

    QueryPlanner(Analysis analysis, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaDeclarationToSymbolMap, Metadata metadata, Session session) {
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(lambdaDeclarationToSymbolMap, "lambdaDeclarationToSymbolMap is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(session, "session is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.idAllocator = idAllocator;
        this.lambdaDeclarationToSymbolMap = lambdaDeclarationToSymbolMap;
        this.metadata = metadata;
        this.session = session;
        this.subqueryPlanner = new SubqueryPlanner(analysis, symbolAllocator, idAllocator, lambdaDeclarationToSymbolMap, metadata, session);
    }

    public RelationPlan plan(Query query) {
        PlanBuilder builder = this.planQueryBody(query);
        List<Expression> orderBy = this.analysis.getOrderByExpressions((Node)query);
        builder = this.handleSubqueries(builder, (Node)query, orderBy);
        List<Expression> outputs = this.analysis.getOutputExpressions((Node)query);
        builder = this.handleSubqueries(builder, (Node)query, outputs);
        builder = this.project(builder, Iterables.concat(orderBy, outputs));
        builder = this.sort(builder, query);
        builder = this.project(builder, this.analysis.getOutputExpressions((Node)query));
        builder = this.limit(builder, query);
        return new RelationPlan(builder.getRoot(), this.analysis.getScope((Node)query), QueryPlanner.computeOutputs(builder, this.analysis.getOutputExpressions((Node)query)));
    }

    public RelationPlan plan(QuerySpecification node) {
        PlanBuilder builder = this.planFrom(node);
        RelationPlan fromRelationPlan = builder.getRelationPlan();
        builder = this.filter(builder, this.analysis.getWhere(node), (Node)node);
        builder = this.aggregate(builder, node);
        builder = this.filter(builder, this.analysis.getHaving(node), (Node)node);
        builder = this.window(builder, node);
        List<Expression> outputs = this.analysis.getOutputExpressions((Node)node);
        builder = this.handleSubqueries(builder, (Node)node, outputs);
        if (node.getOrderBy().isPresent()) {
            if (!this.analysis.isAggregation(node)) {
                builder = this.project(builder, outputs, fromRelationPlan);
                outputs = QueryPlanner.toSymbolReferences(QueryPlanner.computeOutputs(builder, outputs));
                builder = this.planBuilderFor(builder, this.analysis.getScope((Node)node.getOrderBy().get()));
            } else {
                List<Expression> orderByAggregates = this.analysis.getOrderByAggregates((OrderBy)node.getOrderBy().get());
                builder = this.project(builder, Iterables.concat(outputs, orderByAggregates));
                outputs = QueryPlanner.toSymbolReferences(QueryPlanner.computeOutputs(builder, outputs));
                List complexOrderByAggregatesToRemap = (List)orderByAggregates.stream().filter(expression -> !this.analysis.isColumnReference((Expression)expression)).collect(ImmutableList.toImmutableList());
                builder = this.planBuilderFor(builder, this.analysis.getScope((Node)node.getOrderBy().get()), complexOrderByAggregatesToRemap);
            }
            builder = this.window(builder, (OrderBy)node.getOrderBy().get());
        }
        List<Expression> orderBy = this.analysis.getOrderByExpressions((Node)node);
        builder = this.handleSubqueries(builder, (Node)node, orderBy);
        builder = this.project(builder, Iterables.concat(orderBy, outputs));
        builder = this.distinct(builder, node);
        builder = this.sort(builder, node);
        builder = this.project(builder, outputs);
        builder = this.limit(builder, node);
        return new RelationPlan(builder.getRoot(), this.analysis.getScope((Node)node), QueryPlanner.computeOutputs(builder, outputs));
    }

    public DeleteNode plan(Delete node) {
        RelationType descriptor = this.analysis.getOutputDescriptor((Node)node.getTable());
        TableHandle handle = this.analysis.getTableHandle(node.getTable());
        ColumnHandle rowIdHandle = this.metadata.getUpdateRowIdColumnHandle(this.session, handle);
        Type rowIdType = this.metadata.getColumnMetadata(this.session, handle, rowIdHandle).getType();
        ImmutableList.Builder outputSymbols = ImmutableList.builder();
        ImmutableMap.Builder columns = ImmutableMap.builder();
        ImmutableList.Builder fields = ImmutableList.builder();
        for (Field field : descriptor.getAllFields()) {
            Symbol symbol = this.symbolAllocator.newSymbol(field.getName().get(), field.getType());
            outputSymbols.add((Object)symbol);
            columns.put((Object)symbol, (Object)this.analysis.getColumn(field));
            fields.add((Object)field);
        }
        Field rowIdField = Field.newUnqualified(Optional.empty(), rowIdType);
        Symbol rowIdSymbol = this.symbolAllocator.newSymbol("$rowId", rowIdField.getType());
        outputSymbols.add((Object)rowIdSymbol);
        columns.put((Object)rowIdSymbol, (Object)rowIdHandle);
        fields.add((Object)rowIdField);
        TableScanNode tableScan = new TableScanNode(this.idAllocator.getNextId(), handle, (List<Symbol>)outputSymbols.build(), (Map<Symbol, ColumnHandle>)columns.build());
        Scope scope = Scope.builder().withRelationType(RelationId.anonymous(), new RelationType((List<Field>)fields.build())).build();
        RelationPlan relationPlan = new RelationPlan(tableScan, scope, (List<Symbol>)outputSymbols.build());
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis, this.lambdaDeclarationToSymbolMap);
        translations.setFieldMappings(relationPlan.getFieldMappings());
        PlanBuilder builder = new PlanBuilder(translations, relationPlan.getRoot(), this.analysis.getParameters());
        if (node.getWhere().isPresent()) {
            builder = this.filter(builder, (Expression)node.getWhere().get(), (Node)node);
        }
        Symbol rowId = builder.translate((Expression)new FieldReference(relationPlan.getDescriptor().indexOf(rowIdField)));
        ImmutableList outputs = ImmutableList.of((Object)this.symbolAllocator.newSymbol("partialrows", (Type)BigintType.BIGINT), (Object)this.symbolAllocator.newSymbol("fragment", (Type)VarbinaryType.VARBINARY));
        return new DeleteNode(this.idAllocator.getNextId(), builder.getRoot(), new TableWriterNode.DeleteHandle(handle, this.metadata.getTableMetadata(this.session, handle).getTable()), rowId, (List<Symbol>)outputs);
    }

    private static List<Symbol> computeOutputs(PlanBuilder builder, List<Expression> outputExpressions) {
        ImmutableList.Builder outputSymbols = ImmutableList.builder();
        for (Expression expression : outputExpressions) {
            outputSymbols.add((Object)builder.translate(expression));
        }
        return outputSymbols.build();
    }

    private PlanBuilder planQueryBody(Query query) {
        RelationPlan relationPlan = (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.metadata, this.session).process((Node)query.getQueryBody(), null);
        return this.planBuilderFor(relationPlan);
    }

    private PlanBuilder planFrom(QuerySpecification node) {
        RelationPlan relationPlan = node.getFrom().isPresent() ? (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.metadata, this.session).process((Node)node.getFrom().get(), null) : this.planImplicitTable();
        return this.planBuilderFor(relationPlan);
    }

    private PlanBuilder planBuilderFor(PlanBuilder builder, Scope scope, Iterable<? extends Expression> expressionsToRemap) {
        Map<Expression, Symbol> expressionsToSymbols = QueryPlanner.symbolsForExpressions(builder, expressionsToRemap);
        PlanBuilder newBuilder = this.planBuilderFor(builder, scope);
        expressionsToSymbols.entrySet().forEach(entry -> newBuilder.getTranslations().put((Expression)entry.getKey(), (Symbol)entry.getValue()));
        return newBuilder;
    }

    private PlanBuilder planBuilderFor(PlanBuilder builder, Scope scope) {
        return this.planBuilderFor(new RelationPlan(builder.getRoot(), scope, builder.getRoot().getOutputSymbols()));
    }

    private PlanBuilder planBuilderFor(RelationPlan relationPlan) {
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis, this.lambdaDeclarationToSymbolMap);
        translations.setFieldMappings(relationPlan.getFieldMappings());
        return new PlanBuilder(translations, relationPlan.getRoot(), this.analysis.getParameters());
    }

    private RelationPlan planImplicitTable() {
        Scope scope = Scope.create();
        return new RelationPlan(new ValuesNode(this.idAllocator.getNextId(), (List<Symbol>)ImmutableList.of(), (List<List<RowExpression>>)ImmutableList.of((Object)ImmutableList.of())), scope, (List<Symbol>)ImmutableList.of());
    }

    private PlanBuilder filter(PlanBuilder subPlan, Expression predicate, Node node) {
        if (predicate == null) {
            return subPlan;
        }
        Expression rewrittenBeforeSubqueries = subPlan.rewrite(predicate);
        subPlan = this.subqueryPlanner.handleSubqueries(subPlan, rewrittenBeforeSubqueries, node);
        Expression rewrittenAfterSubqueries = subPlan.rewrite(predicate);
        return subPlan.withNewRoot(new FilterNode(this.idAllocator.getNextId(), subPlan.getRoot(), OriginalExpressionUtils.castToRowExpression(rewrittenAfterSubqueries)));
    }

    private PlanBuilder project(PlanBuilder subPlan, Iterable<Expression> expressions, RelationPlan parentRelationPlan) {
        return this.project(subPlan, Iterables.concat(expressions, QueryPlanner.toSymbolReferences(parentRelationPlan.getFieldMappings())));
    }

    private PlanBuilder project(PlanBuilder subPlan, Iterable<Expression> expressions) {
        TranslationMap outputTranslations = new TranslationMap(subPlan.getRelationPlan(), this.analysis, this.lambdaDeclarationToSymbolMap);
        Assignments.Builder projections = Assignments.builder();
        for (Expression expression : expressions) {
            Symbol symbol;
            if (expression instanceof SymbolReference) {
                symbol = Symbol.from(expression);
                projections.put(symbol, expression);
                outputTranslations.put(expression, symbol);
                continue;
            }
            symbol = this.symbolAllocator.newSymbol(expression, this.analysis.getTypeWithCoercions(expression));
            projections.put(symbol, subPlan.rewrite(expression));
            outputTranslations.put(expression, symbol);
        }
        return new PlanBuilder(outputTranslations, new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), projections.build()), this.analysis.getParameters());
    }

    private Map<Symbol, Expression> coerce(Iterable<? extends Expression> expressions, PlanBuilder subPlan, TranslationMap translations) {
        ImmutableMap.Builder projections = ImmutableMap.builder();
        for (Expression expression : expressions) {
            Type type = this.analysis.getType(expression);
            Type coercion = this.analysis.getCoercion(expression);
            Symbol symbol = this.symbolAllocator.newSymbol(expression, (Type)MoreObjects.firstNonNull((Object)coercion, (Object)type));
            Expression rewritten = subPlan.rewrite(expression);
            if (coercion != null) {
                rewritten = new Cast(rewritten, coercion.getTypeSignature().toString(), false, this.metadata.getTypeManager().isTypeOnlyCoercion(type, coercion));
            }
            projections.put((Object)symbol, (Object)rewritten);
            translations.put(expression, symbol);
        }
        return projections.build();
    }

    private PlanBuilder explicitCoercionFields(PlanBuilder subPlan, Iterable<Expression> alreadyCoerced, Iterable<? extends Expression> uncoerced) {
        TranslationMap translations = new TranslationMap(subPlan.getRelationPlan(), this.analysis, this.lambdaDeclarationToSymbolMap);
        Assignments.Builder projections = Assignments.builder();
        projections.putAll(this.coerce(uncoerced, subPlan, translations));
        for (Expression expression : alreadyCoerced) {
            if (expression instanceof SymbolReference) {
                projections.put(Symbol.from(expression), expression);
                continue;
            }
            Symbol symbol = this.symbolAllocator.newSymbol(expression, this.analysis.getType(expression));
            Expression rewritten = subPlan.rewrite(expression);
            projections.put(symbol, rewritten);
            translations.put(expression, symbol);
        }
        return new PlanBuilder(translations, new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), projections.build()), this.analysis.getParameters());
    }

    private PlanBuilder explicitCoercionSymbols(PlanBuilder subPlan, Iterable<Symbol> alreadyCoerced, Iterable<? extends Expression> uncoerced) {
        TranslationMap translations = subPlan.copyTranslations();
        Assignments assignments = Assignments.builder().putAll(this.coerce(uncoerced, subPlan, translations)).putIdentities(alreadyCoerced).build();
        return new PlanBuilder(translations, new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), assignments), this.analysis.getParameters());
    }

    private PlanBuilder aggregate(PlanBuilder subPlan, QuerySpecification node) {
        if (!this.analysis.isAggregation(node)) {
            return subPlan;
        }
        ImmutableSet groupByExpressions = ImmutableSet.copyOf(this.analysis.getGroupByExpressions(node));
        ImmutableList.Builder arguments = ImmutableList.builder();
        this.analysis.getAggregates(node).stream().map(FunctionCall::getArguments).flatMap(Collection::stream).filter(exp -> !(exp instanceof LambdaExpression)).forEach(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
        this.analysis.getAggregates(node).stream().map(FunctionCall::getOrderBy).filter(Optional::isPresent).map(Optional::get).map(OrderBy::getSortItems).flatMap(Collection::stream).map(SortItem::getSortKey).forEach(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
        this.analysis.getAggregates(node).stream().map(FunctionCall::getFilter).filter(Optional::isPresent).map(Optional::get).forEach(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
        Iterable inputs = Iterables.concat((Iterable)groupByExpressions, (Iterable)arguments.build());
        subPlan = this.handleSubqueries(subPlan, (Node)node, inputs);
        if (!Iterables.isEmpty((Iterable)inputs)) {
            subPlan = this.project(subPlan, inputs);
        }
        TranslationMap argumentTranslations = new TranslationMap(subPlan.getRelationPlan(), this.analysis, this.lambdaDeclarationToSymbolMap);
        ImmutableList.Builder aggregationArgumentsBuilder = ImmutableList.builder();
        for (Expression argument : arguments.build()) {
            Symbol symbol = subPlan.translate(argument);
            argumentTranslations.put(argument, symbol);
            aggregationArgumentsBuilder.add((Object)symbol);
        }
        ImmutableList aggregationArguments = aggregationArgumentsBuilder.build();
        TranslationMap groupingTranslations = new TranslationMap(subPlan.getRelationPlan(), this.analysis, this.lambdaDeclarationToSymbolMap);
        LinkedHashMap<Symbol, Symbol> groupingSetMappings = new LinkedHashMap<Symbol, Symbol>();
        for (Expression expression : groupByExpressions) {
            Symbol input = subPlan.translate(expression);
            Symbol output = this.symbolAllocator.newSymbol(expression, this.analysis.getTypeWithCoercions(expression), "gid");
            groupingTranslations.put(expression, output);
            groupingSetMappings.put(output, input);
        }
        Object columnOnlyGroupingSets = ImmutableList.of((Object)ImmutableSet.of());
        ImmutableList groupingSets = ImmutableList.of((Object)ImmutableList.of());
        if (node.getGroupBy().isPresent()) {
            Analysis.GroupingSetAnalysis groupingSetAnalysis = this.analysis.getGroupingSets(node);
            columnOnlyGroupingSets = this.enumerateGroupingSets(groupingSetAnalysis);
            if (((GroupBy)node.getGroupBy().get()).isDistinct()) {
                columnOnlyGroupingSets = (List)columnOnlyGroupingSets.stream().distinct().collect(ImmutableList.toImmutableList());
            }
            ImmutableList.Builder groupingSetBuilder = ImmutableList.builder();
            Iterator iterator = columnOnlyGroupingSets.iterator();
            while (iterator.hasNext()) {
                Set groupingSet = (Set)iterator.next();
                ImmutableList.Builder columns = ImmutableList.builder();
                groupingSetAnalysis.getComplexExpressions().stream().map(groupingTranslations::get).forEach(arg_0 -> ((ImmutableList.Builder)columns).add(arg_0));
                groupingSet.stream().map(field -> groupingTranslations.get((Expression)new FieldReference(field.getFieldIndex()))).forEach(arg_0 -> ((ImmutableList.Builder)columns).add(arg_0));
                groupingSetBuilder.add((Object)columns.build());
            }
            groupingSets = groupingSetBuilder.build();
        }
        Optional<Object> groupIdSymbol = Optional.empty();
        if (groupingSets.size() > 1) {
            groupIdSymbol = Optional.of(this.symbolAllocator.newSymbol("groupId", (Type)BigintType.BIGINT));
            GroupIdNode groupId = new GroupIdNode(this.idAllocator.getNextId(), subPlan.getRoot(), (List<List<Symbol>>)groupingSets, groupingSetMappings, (List<Symbol>)aggregationArguments, (Symbol)groupIdSymbol.get());
            subPlan = new PlanBuilder(groupingTranslations, groupId, this.analysis.getParameters());
        } else {
            Assignments.Builder assignments = Assignments.builder();
            aggregationArguments.forEach(assignments::putIdentity);
            groupingSetMappings.forEach((key, value) -> assignments.put((Symbol)key, (Expression)value.toSymbolReference()));
            ProjectNode project = new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), assignments.build());
            subPlan = new PlanBuilder(groupingTranslations, project, this.analysis.getParameters());
        }
        TranslationMap aggregationTranslations = new TranslationMap(subPlan.getRelationPlan(), this.analysis, this.lambdaDeclarationToSymbolMap);
        aggregationTranslations.copyMappingsFrom(groupingTranslations);
        ImmutableMap.Builder aggregationsBuilder = ImmutableMap.builder();
        boolean needPostProjectionCoercion = false;
        for (FunctionCall aggregate : this.analysis.getAggregates(node)) {
            Expression rewritten = argumentTranslations.rewrite((Expression)aggregate);
            Symbol newSymbol = this.symbolAllocator.newSymbol(rewritten, this.analysis.getType((Expression)aggregate));
            if (rewritten instanceof Cast) {
                rewritten = ((Cast)rewritten).getExpression();
                needPostProjectionCoercion = true;
            }
            aggregationTranslations.put((Expression)aggregate, newSymbol);
            aggregationsBuilder.put((Object)newSymbol, (Object)new AggregationNode.Aggregation((FunctionCall)rewritten, this.analysis.getFunctionHandle(aggregate), Optional.empty()));
        }
        ImmutableMap aggregations = aggregationsBuilder.build();
        ImmutableSet.Builder globalGroupingSets = ImmutableSet.builder();
        for (int i = 0; i < groupingSets.size(); ++i) {
            if (!((List)groupingSets.get(i)).isEmpty()) continue;
            globalGroupingSets.add((Object)i);
        }
        ImmutableList.Builder groupingKeys = ImmutableList.builder();
        groupingSets.stream().flatMap(Collection::stream).distinct().forEach(arg_0 -> ((ImmutableList.Builder)groupingKeys).add(arg_0));
        groupIdSymbol.ifPresent(arg_0 -> ((ImmutableList.Builder)groupingKeys).add(arg_0));
        AggregationNode aggregationNode = new AggregationNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Map<Symbol, AggregationNode.Aggregation>)aggregations, AggregationNode.groupingSets((List<Symbol>)groupingKeys.build(), groupingSets.size(), (Set<Integer>)globalGroupingSets.build()), (List<Symbol>)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), groupIdSymbol);
        subPlan = new PlanBuilder(aggregationTranslations, aggregationNode, this.analysis.getParameters());
        if (needPostProjectionCoercion) {
            ImmutableList.Builder alreadyCoerced = ImmutableList.builder();
            alreadyCoerced.addAll((Iterable)groupByExpressions);
            groupIdSymbol.map(Symbol::toSymbolReference).ifPresent(arg_0 -> ((ImmutableList.Builder)alreadyCoerced).add(arg_0));
            subPlan = this.explicitCoercionFields(subPlan, (Iterable<Expression>)alreadyCoerced.build(), this.analysis.getAggregates(node));
        }
        return this.handleGroupingOperations(subPlan, node, groupIdSymbol, (List<Set<FieldId>>)columnOnlyGroupingSets);
    }

    /*
     * WARNING - void declaration
     */
    private List<Set<FieldId>> enumerateGroupingSets(Analysis.GroupingSetAnalysis groupingSetAnalysis) {
        void var4_8;
        ArrayList<Object> partialSets = new ArrayList<Object>();
        for (Set<FieldId> set : groupingSetAnalysis.getCubes()) {
            partialSets.add(ImmutableList.copyOf((Collection)Sets.powerSet(set)));
        }
        for (List list : groupingSetAnalysis.getRollups()) {
            List sets = (List)IntStream.rangeClosed(0, list.size()).mapToObj(i -> ImmutableSet.copyOf(rollup.subList(0, i))).collect(ImmutableList.toImmutableList());
            partialSets.add(sets);
        }
        partialSets.addAll(groupingSetAnalysis.getOrdinarySets());
        if (partialSets.isEmpty()) {
            return ImmutableList.of((Object)ImmutableSet.of());
        }
        ArrayList<Set<FieldId>> allSets = new ArrayList<Set<FieldId>>();
        ((List)partialSets.get(0)).stream().map(ImmutableSet::copyOf).forEach(allSets::add);
        boolean bl = true;
        while (var4_8 < partialSets.size()) {
            List groupingSets = (List)partialSets.get((int)var4_8);
            ImmutableList oldGroupingSetsCrossProduct = ImmutableList.copyOf(allSets);
            allSets.clear();
            for (Set existingSet : oldGroupingSetsCrossProduct) {
                for (Set groupingSet : groupingSets) {
                    ImmutableSet concatenatedSet = ImmutableSet.builder().addAll((Iterable)existingSet).addAll((Iterable)groupingSet).build();
                    allSets.add((Set<FieldId>)concatenatedSet);
                }
            }
            ++var4_8;
        }
        return allSets;
    }

    private PlanBuilder handleGroupingOperations(PlanBuilder subPlan, QuerySpecification node, Optional<Symbol> groupIdSymbol, List<Set<FieldId>> groupingSets) {
        if (this.analysis.getGroupingOperations(node).isEmpty()) {
            return subPlan;
        }
        TranslationMap newTranslations = subPlan.copyTranslations();
        Assignments.Builder projections = Assignments.builder();
        projections.putIdentities(subPlan.getRoot().getOutputSymbols());
        List descriptor = (List)groupingSets.stream().map(set -> (ImmutableSet)set.stream().map(FieldId::getFieldIndex).collect(ImmutableSet.toImmutableSet())).collect(ImmutableList.toImmutableList());
        for (GroupingOperation groupingOperation : this.analysis.getGroupingOperations(node)) {
            Expression rewritten = GroupingOperationRewriter.rewriteGroupingOperation(groupingOperation, descriptor, this.analysis.getColumnReferenceFields(), groupIdSymbol);
            Type coercion = this.analysis.getCoercion((Expression)groupingOperation);
            Symbol symbol = this.symbolAllocator.newSymbol(rewritten, this.analysis.getTypeWithCoercions((Expression)groupingOperation));
            if (coercion != null) {
                rewritten = new Cast(rewritten, coercion.getTypeSignature().toString(), false, this.metadata.getTypeManager().isTypeOnlyCoercion(this.analysis.getType((Expression)groupingOperation), coercion));
            }
            projections.put(symbol, rewritten);
            newTranslations.put((Expression)groupingOperation, symbol);
        }
        return new PlanBuilder(newTranslations, new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), projections.build()), this.analysis.getParameters());
    }

    private PlanBuilder window(PlanBuilder subPlan, OrderBy node) {
        return this.window(subPlan, (List<FunctionCall>)ImmutableList.copyOf(this.analysis.getOrderByWindowFunctions(node)));
    }

    private PlanBuilder window(PlanBuilder subPlan, QuerySpecification node) {
        return this.window(subPlan, (List<FunctionCall>)ImmutableList.copyOf(this.analysis.getWindowFunctions(node)));
    }

    private PlanBuilder window(PlanBuilder subPlan, List<FunctionCall> windowFunctions) {
        if (windowFunctions.isEmpty()) {
            return subPlan;
        }
        for (FunctionCall windowFunction : windowFunctions) {
            Object expression2;
            Window window = (Window)windowFunction.getWindow().get();
            WindowFrame.Type frameType = WindowFrame.Type.RANGE;
            FrameBound.Type frameStartType = FrameBound.Type.UNBOUNDED_PRECEDING;
            FrameBound.Type frameEndType = FrameBound.Type.CURRENT_ROW;
            Expression frameStart = null;
            Expression frameEnd = null;
            if (window.getFrame().isPresent()) {
                WindowFrame frame = (WindowFrame)window.getFrame().get();
                frameType = frame.getType();
                frameStartType = frame.getStart().getType();
                frameStart = frame.getStart().getValue().orElse(null);
                if (frame.getEnd().isPresent()) {
                    frameEndType = ((FrameBound)frame.getEnd().get()).getType();
                    frameEnd = ((FrameBound)frame.getEnd().get()).getValue().orElse(null);
                }
            }
            ImmutableList.Builder inputs = ImmutableList.builder().addAll((Iterable)windowFunction.getArguments()).addAll((Iterable)window.getPartitionBy()).addAll(Iterables.transform(NodeUtils.getSortItemsFromOrderBy(window.getOrderBy()), SortItem::getSortKey));
            if (frameStart != null) {
                inputs.add((Object)frameStart);
            }
            if (frameEnd != null) {
                inputs.add(frameEnd);
            }
            subPlan = subPlan.appendProjections((Iterable<Expression>)inputs.build(), this.symbolAllocator, this.idAllocator);
            ImmutableList.Builder partitionBySymbols = ImmutableList.builder();
            for (Object expression2 : window.getPartitionBy()) {
                partitionBySymbols.add((Object)subPlan.translate((Expression)expression2));
            }
            LinkedHashMap<Symbol, SortOrder> orderings = new LinkedHashMap<Symbol, SortOrder>();
            expression2 = NodeUtils.getSortItemsFromOrderBy(window.getOrderBy()).iterator();
            while (expression2.hasNext()) {
                SortItem item = (SortItem)expression2.next();
                Symbol symbol = subPlan.translate(item.getSortKey());
                orderings.putIfAbsent(symbol, QueryPlanner.toSortOrder(item));
            }
            Optional<Symbol> frameStartSymbol = Optional.empty();
            Optional<Symbol> frameEndSymbol = Optional.empty();
            if (frameStart != null) {
                frameStartSymbol = Optional.of(subPlan.translate(frameStart));
            }
            if (frameEnd != null) {
                frameEndSymbol = Optional.of(subPlan.translate(frameEnd));
            }
            WindowNode.Frame frame = new WindowNode.Frame(WindowNodeUtil.toWindowType(frameType), WindowNodeUtil.toBoundType(frameStartType), frameStartSymbol, WindowNodeUtil.toBoundType(frameEndType), frameEndSymbol, Optional.ofNullable(frameStart).map(Expression::toString), Optional.ofNullable(frameEnd).map(Expression::toString));
            TranslationMap outputTranslations = subPlan.copyTranslations();
            Expression rewritten = subPlan.rewrite((Expression)windowFunction);
            boolean needCoercion = rewritten instanceof Cast;
            if (rewritten instanceof Cast) {
                rewritten = ((Cast)rewritten).getExpression();
            }
            if (rewritten instanceof SymbolReference) {
                if (!needCoercion) continue;
                subPlan = this.explicitCoercionSymbols(subPlan, subPlan.getRoot().getOutputSymbols(), (Iterable<? extends Expression>)ImmutableList.of((Object)windowFunction));
                continue;
            }
            Type returnType = this.analysis.getType((Expression)windowFunction);
            Symbol newSymbol = this.symbolAllocator.newSymbol(rewritten, returnType);
            outputTranslations.put((Expression)windowFunction, newSymbol);
            WindowNode.Function function = new WindowNode.Function(Expressions.call(windowFunction.getName().toString(), this.analysis.getFunctionHandle(windowFunction), returnType, (List)((FunctionCall)rewritten).getArguments().stream().map(OriginalExpressionUtils::castToRowExpression).collect(ImmutableList.toImmutableList())), frame);
            List<Symbol> sourceSymbols = subPlan.getRoot().getOutputSymbols();
            ImmutableList.Builder orderBySymbols = ImmutableList.builder();
            orderBySymbols.addAll(orderings.keySet());
            Optional<OrderingScheme> orderingScheme = Optional.empty();
            if (!orderings.isEmpty()) {
                orderingScheme = Optional.of(new OrderingScheme((List<Symbol>)orderBySymbols.build(), orderings));
            }
            subPlan = new PlanBuilder(outputTranslations, new WindowNode(this.idAllocator.getNextId(), subPlan.getRoot(), new WindowNode.Specification((List<Symbol>)partitionBySymbols.build(), orderingScheme), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)newSymbol, (Object)function), Optional.empty(), (Set<Symbol>)ImmutableSet.of(), 0), this.analysis.getParameters());
            if (!needCoercion) continue;
            subPlan = this.explicitCoercionSymbols(subPlan, sourceSymbols, (Iterable<? extends Expression>)ImmutableList.of((Object)windowFunction));
        }
        return subPlan;
    }

    private PlanBuilder handleSubqueries(PlanBuilder subPlan, Node node, Iterable<Expression> inputs) {
        for (Expression input : inputs) {
            subPlan = this.subqueryPlanner.handleSubqueries(subPlan, subPlan.rewrite(input), node);
        }
        return subPlan;
    }

    private PlanBuilder distinct(PlanBuilder subPlan, QuerySpecification node) {
        if (node.getSelect().isDistinct()) {
            return subPlan.withNewRoot(new AggregationNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of(), AggregationNode.singleGroupingSet(subPlan.getRoot().getOutputSymbols()), (List<Symbol>)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty()));
        }
        return subPlan;
    }

    private PlanBuilder sort(PlanBuilder subPlan, Query node) {
        return this.sort(subPlan, node.getOrderBy(), node.getLimit(), this.analysis.getOrderByExpressions((Node)node));
    }

    private PlanBuilder sort(PlanBuilder subPlan, QuerySpecification node) {
        return this.sort(subPlan, node.getOrderBy(), node.getLimit(), this.analysis.getOrderByExpressions((Node)node));
    }

    private PlanBuilder sort(PlanBuilder subPlan, Optional<OrderBy> orderBy, Optional<String> limit, List<Expression> orderByExpressions) {
        if (!orderBy.isPresent()) {
            return subPlan;
        }
        Iterator sortItems = orderBy.get().getSortItems().iterator();
        ImmutableList.Builder orderBySymbols = ImmutableList.builder();
        HashMap<Symbol, SortOrder> orderings = new HashMap<Symbol, SortOrder>();
        for (Expression fieldOrExpression : orderByExpressions) {
            Symbol symbol = subPlan.translate(fieldOrExpression);
            SortItem sortItem = (SortItem)sortItems.next();
            if (orderings.containsKey(symbol)) continue;
            orderBySymbols.add((Object)symbol);
            orderings.put(symbol, QueryPlanner.toSortOrder(sortItem));
        }
        OrderingScheme orderingScheme = new OrderingScheme((List<Symbol>)orderBySymbols.build(), orderings);
        PlanNode planNode = limit.isPresent() && !limit.get().equalsIgnoreCase("all") ? new TopNNode(this.idAllocator.getNextId(), subPlan.getRoot(), Long.parseLong(limit.get()), orderingScheme, TopNNode.Step.SINGLE) : new SortNode(this.idAllocator.getNextId(), subPlan.getRoot(), orderingScheme);
        return subPlan.withNewRoot(planNode);
    }

    private PlanBuilder limit(PlanBuilder subPlan, Query node) {
        return this.limit(subPlan, node.getOrderBy(), node.getLimit());
    }

    private PlanBuilder limit(PlanBuilder subPlan, QuerySpecification node) {
        return this.limit(subPlan, node.getOrderBy(), node.getLimit());
    }

    private PlanBuilder limit(PlanBuilder subPlan, Optional<OrderBy> orderBy, Optional<String> limit) {
        if (!orderBy.isPresent() && limit.isPresent() && !limit.get().equalsIgnoreCase("all")) {
            long limitValue = Long.parseLong(limit.get());
            subPlan = subPlan.withNewRoot(new LimitNode(this.idAllocator.getNextId(), subPlan.getRoot(), limitValue, false));
        }
        return subPlan;
    }

    private static List<Expression> toSymbolReferences(List<Symbol> symbols) {
        return (List)symbols.stream().map(Symbol::toSymbolReference).collect(ImmutableList.toImmutableList());
    }

    private static Map<Expression, Symbol> symbolsForExpressions(PlanBuilder builder, Iterable<? extends Expression> expressions) {
        return (Map)Streams.stream(expressions).distinct().collect(ImmutableMap.toImmutableMap(expression -> expression, builder::translate));
    }

    public static SortOrder toSortOrder(SortItem sortItem) {
        if (sortItem.getOrdering() == SortItem.Ordering.ASCENDING) {
            if (sortItem.getNullOrdering() == SortItem.NullOrdering.FIRST) {
                return SortOrder.ASC_NULLS_FIRST;
            }
            return SortOrder.ASC_NULLS_LAST;
        }
        if (sortItem.getNullOrdering() == SortItem.NullOrdering.FIRST) {
            return SortOrder.DESC_NULLS_FIRST;
        }
        return SortOrder.DESC_NULLS_LAST;
    }
}

