/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.SpecialFormBytecodeGenerator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.InstructionNode;
import io.airlift.bytecode.instruction.LabelNode;
import io.airlift.bytecode.instruction.VariableInstruction;
import java.util.List;
import java.util.Optional;

public class SwitchCodeGenerator
implements SpecialFormBytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments, Optional<Variable> outputBlockVariable) {
        BytecodeNode elseValue;
        List<RowExpression> whenClauses;
        Scope scope = generatorContext.getScope();
        RowExpression value = arguments.get(0);
        BytecodeNode valueBytecode = generatorContext.generate(value, Optional.empty());
        RowExpression last = arguments.get(arguments.size() - 1);
        if (last instanceof SpecialFormExpression && ((SpecialFormExpression)last).getForm().equals((Object)SpecialFormExpression.Form.WHEN)) {
            whenClauses = arguments.subList(1, arguments.size());
            elseValue = new BytecodeBlock().append((BytecodeNode)generatorContext.wasNull().set(BytecodeExpressions.constantTrue())).pushJavaDefault(returnType.getJavaType());
        } else {
            whenClauses = arguments.subList(1, arguments.size() - 1);
            elseValue = generatorContext.generate(last, Optional.empty());
        }
        Class valueType = value.getType().getJavaType();
        LabelNode nullValue = new LabelNode("nullCondition");
        Variable tempVariable = scope.createTempVariable(valueType);
        BytecodeBlock block = new BytecodeBlock().append(valueBytecode).append(BytecodeUtils.ifWasNullClearPopAndGoto(scope, nullValue, Void.TYPE, valueType)).putVariable(tempVariable);
        InstructionNode getTempVariableNode = VariableInstruction.loadVariable((Variable)tempVariable);
        elseValue = new BytecodeBlock().visitLabel(nullValue).append(elseValue);
        for (RowExpression clause : Lists.reverse(whenClauses)) {
            Preconditions.checkArgument((clause instanceof SpecialFormExpression && ((SpecialFormExpression)clause).getForm().equals((Object)SpecialFormExpression.Form.WHEN) ? 1 : 0) != 0);
            RowExpression operand = (RowExpression)((SpecialFormExpression)clause).getArguments().get(0);
            RowExpression result = (RowExpression)((SpecialFormExpression)clause).getArguments().get(1);
            FunctionHandle equalsFunction = generatorContext.getFunctionManager().resolveOperator(OperatorType.EQUAL, TypeSignatureProvider.fromTypes(value.getType(), operand.getType()));
            BytecodeNode equalsCall = generatorContext.generateCall(OperatorType.EQUAL.name(), generatorContext.getFunctionManager().getScalarFunctionImplementation(equalsFunction), (List<BytecodeNode>)ImmutableList.of((Object)generatorContext.generate(operand, Optional.empty()), (Object)getTempVariableNode));
            BytecodeBlock condition = new BytecodeBlock().append(equalsCall).append((BytecodeNode)generatorContext.wasNull().set(BytecodeExpressions.constantFalse()));
            elseValue = new IfStatement("when", new Object[0]).condition((BytecodeNode)condition).ifTrue(generatorContext.generate(result, Optional.empty())).ifFalse(elseValue);
        }
        block.append(elseValue);
        outputBlockVariable.ifPresent(output -> block.append(SpecialFormBytecodeGenerator.generateWrite(generatorContext, returnType, output)));
        return block;
    }
}

