/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.sql.tree.DefaultExpressionTraversalVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public final class ExpressionTreeUtils {
    private ExpressionTreeUtils() {
    }

    static List<FunctionCall> extractAggregateFunctions(Map<NodeRef<FunctionCall>, FunctionHandle> functionHandles, Iterable<? extends Node> nodes, FunctionManager functionManager) {
        return ExpressionTreeUtils.extractExpressions(nodes, FunctionCall.class, ExpressionTreeUtils.isAggregationPredicate(functionHandles, functionManager));
    }

    static List<FunctionCall> extractWindowFunctions(Iterable<? extends Node> nodes) {
        return ExpressionTreeUtils.extractExpressions(nodes, FunctionCall.class, ExpressionTreeUtils::isWindowFunction);
    }

    public static <T extends Expression> List<T> extractExpressions(Iterable<? extends Node> nodes, Class<T> clazz) {
        return ExpressionTreeUtils.extractExpressions(nodes, clazz, Predicates.alwaysTrue());
    }

    private static Predicate<FunctionCall> isAggregationPredicate(Map<NodeRef<FunctionCall>, FunctionHandle> functionHandles, FunctionManager functionManager) {
        return functionCall -> (functionManager.getFunctionMetadata((FunctionHandle)functionHandles.get(NodeRef.of((Node)functionCall))).getFunctionKind() == FunctionKind.AGGREGATE || functionCall.getFilter().isPresent()) && !functionCall.getWindow().isPresent() || functionCall.getOrderBy().isPresent();
    }

    private static boolean isWindowFunction(FunctionCall functionCall) {
        return functionCall.getWindow().isPresent();
    }

    private static <T extends Expression> List<T> extractExpressions(Iterable<? extends Node> nodes, Class<T> clazz, Predicate<T> predicate) {
        Objects.requireNonNull(nodes, "nodes is null");
        Objects.requireNonNull(clazz, "clazz is null");
        Objects.requireNonNull(predicate, "predicate is null");
        return (List)ImmutableList.copyOf(nodes).stream().flatMap(node -> ExpressionTreeUtils.linearizeNodes(node).stream()).filter(clazz::isInstance).map(clazz::cast).filter(predicate).collect(ImmutableList.toImmutableList());
    }

    private static List<Node> linearizeNodes(Node node) {
        final ImmutableList.Builder nodes = ImmutableList.builder();
        new DefaultExpressionTraversalVisitor<Node, Void>(){

            public Node process(Node node, Void context) {
                Node result = (Node)super.process(node, (Object)context);
                nodes.add((Object)node);
                return result;
            }
        }.process(node, null);
        return nodes.build();
    }
}

