/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.security.DenyAllAccessControl;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalParseResult;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.FunctionType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.NodeUtils;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.ExpressionAnalysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.FieldId;
import com.facebook.presto.sql.analyzer.RelationId;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.ResolvedField;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.SemanticExceptions;
import com.facebook.presto.sql.analyzer.StatementAnalyzer;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AtTimeZone;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BinaryLiteral;
import com.facebook.presto.sql.tree.BindExpression;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CharLiteral;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CurrentPath;
import com.facebook.presto.sql.tree.CurrentTime;
import com.facebook.presto.sql.tree.CurrentUser;
import com.facebook.presto.sql.tree.DecimalLiteral;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.GroupingOperation;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QuantifiedComparisonExpression;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.StackableAstVisitor;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.TimeLiteral;
import com.facebook.presto.sql.tree.TimestampLiteral;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.type.ArrayParametricType;
import com.facebook.presto.type.IntervalDayTimeType;
import com.facebook.presto.type.IntervalYearMonthType;
import com.facebook.presto.type.JsonType;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.util.DateTimeUtils;
import com.facebook.presto.util.LegacyRowFieldOrdinalAccessUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ExpressionAnalyzer {
    private static final int MAX_NUMBER_GROUPING_ARGUMENTS_BIGINT = 63;
    private static final int MAX_NUMBER_GROUPING_ARGUMENTS_INTEGER = 31;
    private final FunctionManager functionManager;
    private final TypeManager typeManager;
    private final Function<Node, StatementAnalyzer> statementAnalyzerFactory;
    private final TypeProvider symbolTypes;
    private final boolean isDescribe;
    private final boolean legacyRowFieldOrdinalAccess;
    private final Map<NodeRef<FunctionCall>, FunctionHandle> resolvedFunctions = new LinkedHashMap<NodeRef<FunctionCall>, FunctionHandle>();
    private final Set<NodeRef<SubqueryExpression>> scalarSubqueries = new LinkedHashSet<NodeRef<SubqueryExpression>>();
    private final Set<NodeRef<ExistsPredicate>> existsSubqueries = new LinkedHashSet<NodeRef<ExistsPredicate>>();
    private final Map<NodeRef<Expression>, Type> expressionCoercions = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Set<NodeRef<Expression>> typeOnlyCoercions = new LinkedHashSet<NodeRef<Expression>>();
    private final Set<NodeRef<InPredicate>> subqueryInPredicates = new LinkedHashSet<NodeRef<InPredicate>>();
    private final Map<NodeRef<Expression>, FieldId> columnReferences = new LinkedHashMap<NodeRef<Expression>, FieldId>();
    private final Map<NodeRef<Expression>, Type> expressionTypes = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Set<NodeRef<QuantifiedComparisonExpression>> quantifiedComparisons = new LinkedHashSet<NodeRef<QuantifiedComparisonExpression>>();
    private final Map<NodeRef<Identifier>, LambdaArgumentDeclaration> lambdaArgumentReferences = new LinkedHashMap<NodeRef<Identifier>, LambdaArgumentDeclaration>();
    private final Set<NodeRef<FunctionCall>> windowFunctions = new LinkedHashSet<NodeRef<FunctionCall>>();
    private final Multimap<QualifiedObjectName, String> tableColumnReferences = HashMultimap.create();
    private final Session session;
    private final List<Expression> parameters;
    private final WarningCollector warningCollector;

    public ExpressionAnalyzer(FunctionManager functionManager, TypeManager typeManager, Function<Node, StatementAnalyzer> statementAnalyzerFactory, Session session, TypeProvider symbolTypes, List<Expression> parameters, WarningCollector warningCollector, boolean isDescribe) {
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.statementAnalyzerFactory = Objects.requireNonNull(statementAnalyzerFactory, "statementAnalyzerFactory is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.symbolTypes = Objects.requireNonNull(symbolTypes, "symbolTypes is null");
        this.parameters = Objects.requireNonNull(parameters, "parameters is null");
        this.isDescribe = isDescribe;
        this.legacyRowFieldOrdinalAccess = SystemSessionProperties.isLegacyRowFieldOrdinalAccessEnabled(session);
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
    }

    public Map<NodeRef<FunctionCall>, FunctionHandle> getResolvedFunctions() {
        return Collections.unmodifiableMap(this.resolvedFunctions);
    }

    public Map<NodeRef<Expression>, Type> getExpressionTypes() {
        return Collections.unmodifiableMap(this.expressionTypes);
    }

    public Type setExpressionType(Expression expression, Type type) {
        Objects.requireNonNull(expression, "expression cannot be null");
        Objects.requireNonNull(type, "type cannot be null");
        this.expressionTypes.put((NodeRef<Expression>)NodeRef.of((Node)expression), type);
        return type;
    }

    private Type getExpressionType(Expression expression) {
        Objects.requireNonNull(expression, "expression cannot be null");
        Type type = this.expressionTypes.get(NodeRef.of((Node)expression));
        Preconditions.checkState((type != null ? 1 : 0) != 0, (String)"Expression not yet analyzed: %s", (Object)expression);
        return type;
    }

    public Map<NodeRef<Expression>, Type> getExpressionCoercions() {
        return Collections.unmodifiableMap(this.expressionCoercions);
    }

    public Set<NodeRef<Expression>> getTypeOnlyCoercions() {
        return Collections.unmodifiableSet(this.typeOnlyCoercions);
    }

    public Set<NodeRef<InPredicate>> getSubqueryInPredicates() {
        return Collections.unmodifiableSet(this.subqueryInPredicates);
    }

    public Map<NodeRef<Expression>, FieldId> getColumnReferences() {
        return Collections.unmodifiableMap(this.columnReferences);
    }

    public Map<NodeRef<Identifier>, LambdaArgumentDeclaration> getLambdaArgumentReferences() {
        return Collections.unmodifiableMap(this.lambdaArgumentReferences);
    }

    public Type analyze(Expression expression, Scope scope) {
        Visitor visitor = new Visitor(scope, this.warningCollector);
        return visitor.process((Node)expression, (StackableAstVisitor.StackableAstVisitorContext<Context>)new StackableAstVisitor.StackableAstVisitorContext((Object)Context.notInLambda(scope)));
    }

    private Type analyze(Expression expression, Scope baseScope, Context context) {
        Visitor visitor = new Visitor(baseScope, this.warningCollector);
        return visitor.process((Node)expression, (StackableAstVisitor.StackableAstVisitorContext<Context>)new StackableAstVisitor.StackableAstVisitorContext((Object)context));
    }

    public Set<NodeRef<SubqueryExpression>> getScalarSubqueries() {
        return Collections.unmodifiableSet(this.scalarSubqueries);
    }

    public Set<NodeRef<ExistsPredicate>> getExistsSubqueries() {
        return Collections.unmodifiableSet(this.existsSubqueries);
    }

    public Set<NodeRef<QuantifiedComparisonExpression>> getQuantifiedComparisons() {
        return Collections.unmodifiableSet(this.quantifiedComparisons);
    }

    public Set<NodeRef<FunctionCall>> getWindowFunctions() {
        return Collections.unmodifiableSet(this.windowFunctions);
    }

    public Multimap<QualifiedObjectName, String> getTableColumnReferences() {
        return this.tableColumnReferences;
    }

    public static FunctionHandle resolveFunction(Session session, FunctionCall node, List<TypeSignatureProvider> argumentTypes, FunctionManager functionManager) {
        try {
            return functionManager.resolveFunction(session, node.getName(), argumentTypes);
        }
        catch (PrestoException e) {
            if (e.getErrorCode().getCode() == StandardErrorCode.FUNCTION_NOT_FOUND.toErrorCode().getCode()) {
                throw new SemanticException(SemanticErrorCode.FUNCTION_NOT_FOUND, (Node)node, e.getMessage(), new Object[0]);
            }
            if (e.getErrorCode().getCode() == StandardErrorCode.AMBIGUOUS_FUNCTION_CALL.toErrorCode().getCode()) {
                throw new SemanticException(SemanticErrorCode.AMBIGUOUS_FUNCTION_CALL, (Node)node, e.getMessage(), new Object[0]);
            }
            throw e;
        }
    }

    public static Map<NodeRef<Expression>, Type> getExpressionTypes(Session session, Metadata metadata, SqlParser sqlParser, TypeProvider types, Expression expression, List<Expression> parameters, WarningCollector warningCollector) {
        return ExpressionAnalyzer.getExpressionTypes(session, metadata, sqlParser, types, expression, parameters, warningCollector, false);
    }

    public static Map<NodeRef<Expression>, Type> getExpressionTypes(Session session, Metadata metadata, SqlParser sqlParser, TypeProvider types, Expression expression, List<Expression> parameters, WarningCollector warningCollector, boolean isDescribe) {
        return ExpressionAnalyzer.getExpressionTypes(session, metadata, sqlParser, types, (Iterable<Expression>)ImmutableList.of((Object)expression), parameters, warningCollector, isDescribe);
    }

    public static Map<NodeRef<Expression>, Type> getExpressionTypes(Session session, Metadata metadata, SqlParser sqlParser, TypeProvider types, Iterable<Expression> expressions, List<Expression> parameters, WarningCollector warningCollector, boolean isDescribe) {
        return ExpressionAnalyzer.analyzeExpressions(session, metadata, sqlParser, types, expressions, parameters, warningCollector, isDescribe).getExpressionTypes();
    }

    public static ExpressionAnalysis analyzeExpressions(Session session, Metadata metadata, SqlParser sqlParser, TypeProvider types, Iterable<Expression> expressions, List<Expression> parameters, WarningCollector warningCollector, boolean isDescribe) {
        Analysis analysis = new Analysis(null, parameters, isDescribe);
        ExpressionAnalyzer analyzer = ExpressionAnalyzer.create(analysis, session, metadata, sqlParser, new DenyAllAccessControl(), types, warningCollector);
        for (Expression expression : expressions) {
            analyzer.analyze(expression, Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(new Field[0])).build());
        }
        return new ExpressionAnalysis(analyzer.getExpressionTypes(), analyzer.getExpressionCoercions(), analyzer.getSubqueryInPredicates(), analyzer.getScalarSubqueries(), analyzer.getExistsSubqueries(), analyzer.getColumnReferences(), analyzer.getTypeOnlyCoercions(), analyzer.getQuantifiedComparisons(), analyzer.getLambdaArgumentReferences(), analyzer.getWindowFunctions());
    }

    public static ExpressionAnalysis analyzeExpression(Session session, Metadata metadata, AccessControl accessControl, SqlParser sqlParser, Scope scope, Analysis analysis, Expression expression, WarningCollector warningCollector) {
        ExpressionAnalyzer analyzer = ExpressionAnalyzer.create(analysis, session, metadata, sqlParser, accessControl, TypeProvider.empty(), warningCollector);
        analyzer.analyze(expression, scope);
        Map<NodeRef<Expression>, Type> expressionTypes = analyzer.getExpressionTypes();
        Map<NodeRef<Expression>, Type> expressionCoercions = analyzer.getExpressionCoercions();
        Set<NodeRef<Expression>> typeOnlyCoercions = analyzer.getTypeOnlyCoercions();
        Map<NodeRef<FunctionCall>, FunctionHandle> resolvedFunctions = analyzer.getResolvedFunctions();
        analysis.addTypes(expressionTypes);
        analysis.addCoercions(expressionCoercions, typeOnlyCoercions);
        analysis.addFunctionHandles(resolvedFunctions);
        analysis.addColumnReferences(analyzer.getColumnReferences());
        analysis.addLambdaArgumentReferences(analyzer.getLambdaArgumentReferences());
        analysis.addTableColumnReferences(accessControl, session.getIdentity(), analyzer.getTableColumnReferences());
        return new ExpressionAnalysis(expressionTypes, expressionCoercions, analyzer.getSubqueryInPredicates(), analyzer.getScalarSubqueries(), analyzer.getExistsSubqueries(), analyzer.getColumnReferences(), analyzer.getTypeOnlyCoercions(), analyzer.getQuantifiedComparisons(), analyzer.getLambdaArgumentReferences(), analyzer.getWindowFunctions());
    }

    private static ExpressionAnalyzer create(Analysis analysis, Session session, Metadata metadata, SqlParser sqlParser, AccessControl accessControl, TypeProvider types, WarningCollector warningCollector) {
        return new ExpressionAnalyzer(metadata.getFunctionManager(), metadata.getTypeManager(), node -> new StatementAnalyzer(analysis, metadata, sqlParser, accessControl, session, warningCollector), session, types, analysis.getParameters(), warningCollector, analysis.isDescribe());
    }

    public static ExpressionAnalyzer createConstantAnalyzer(Metadata metadata, Session session, List<Expression> parameters, WarningCollector warningCollector) {
        return ExpressionAnalyzer.createWithoutSubqueries(metadata.getFunctionManager(), metadata.getTypeManager(), session, parameters, SemanticErrorCode.EXPRESSION_NOT_CONSTANT, "Constant expression cannot contain a subquery", warningCollector, false);
    }

    public static ExpressionAnalyzer createConstantAnalyzer(Metadata metadata, Session session, List<Expression> parameters, WarningCollector warningCollector, boolean isDescribe) {
        return ExpressionAnalyzer.createWithoutSubqueries(metadata.getFunctionManager(), metadata.getTypeManager(), session, parameters, SemanticErrorCode.EXPRESSION_NOT_CONSTANT, "Constant expression cannot contain a subquery", warningCollector, isDescribe);
    }

    public static ExpressionAnalyzer createWithoutSubqueries(FunctionManager functionManager, TypeManager typeManager, Session session, List<Expression> parameters, SemanticErrorCode errorCode, String message, WarningCollector warningCollector, boolean isDescribe) {
        return ExpressionAnalyzer.createWithoutSubqueries(functionManager, typeManager, session, TypeProvider.empty(), parameters, (? super Node node) -> new SemanticException(errorCode, (Node)node, message, new Object[0]), warningCollector, isDescribe);
    }

    public static ExpressionAnalyzer createWithoutSubqueries(FunctionManager functionManager, TypeManager typeManager, Session session, TypeProvider symbolTypes, List<Expression> parameters, Function<? super Node, ? extends RuntimeException> statementAnalyzerRejection, WarningCollector warningCollector, boolean isDescribe) {
        return new ExpressionAnalyzer(functionManager, typeManager, node -> {
            throw (RuntimeException)statementAnalyzerRejection.apply((Node)node);
        }, session, symbolTypes, parameters, warningCollector, isDescribe);
    }

    private static class Context {
        private final Scope scope;
        private final List<Type> functionInputTypes;
        private final Map<FieldId, LambdaArgumentDeclaration> fieldToLambdaArgumentDeclaration;

        private Context(Scope scope, List<Type> functionInputTypes, Map<FieldId, LambdaArgumentDeclaration> fieldToLambdaArgumentDeclaration) {
            this.scope = Objects.requireNonNull(scope, "scope is null");
            this.functionInputTypes = functionInputTypes;
            this.fieldToLambdaArgumentDeclaration = fieldToLambdaArgumentDeclaration;
        }

        public static Context notInLambda(Scope scope) {
            return new Context(scope, null, null);
        }

        public static Context inLambda(Scope scope, Map<FieldId, LambdaArgumentDeclaration> fieldToLambdaArgumentDeclaration) {
            return new Context(scope, null, Objects.requireNonNull(fieldToLambdaArgumentDeclaration, "fieldToLambdaArgumentDeclaration is null"));
        }

        public Context expectingLambda(List<Type> functionInputTypes) {
            return new Context(this.scope, Objects.requireNonNull(functionInputTypes, "functionInputTypes is null"), this.fieldToLambdaArgumentDeclaration);
        }

        public Context notExpectingLambda() {
            return new Context(this.scope, null, this.fieldToLambdaArgumentDeclaration);
        }

        Scope getScope() {
            return this.scope;
        }

        public boolean isInLambda() {
            return this.fieldToLambdaArgumentDeclaration != null;
        }

        public boolean isExpectingLambda() {
            return this.functionInputTypes != null;
        }

        public Map<FieldId, LambdaArgumentDeclaration> getFieldToLambdaArgumentDeclaration() {
            Preconditions.checkState((boolean)this.isInLambda());
            return this.fieldToLambdaArgumentDeclaration;
        }

        public List<Type> getFunctionInputTypes() {
            Preconditions.checkState((boolean)this.isExpectingLambda());
            return this.functionInputTypes;
        }
    }

    private class Visitor
    extends StackableAstVisitor<Type, Context> {
        private final Scope baseScope;
        private final WarningCollector warningCollector;

        public Visitor(Scope baseScope, WarningCollector warningCollector) {
            this.baseScope = Objects.requireNonNull(baseScope, "baseScope is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        }

        public Type process(Node node, @Nullable StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type;
            if (node instanceof Expression && (type = (Type)ExpressionAnalyzer.this.expressionTypes.get(NodeRef.of((Node)((Expression)node)))) != null) {
                return type;
            }
            return (Type)super.process(node, context);
        }

        protected Type visitRow(Row node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            List types = (List)node.getItems().stream().map(child -> this.process((Node)child, context)).collect(ImmutableList.toImmutableList());
            RowType type = RowType.anonymous((List)types);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)type);
        }

        protected Type visitCurrentTime(CurrentTime node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            DateType type;
            if (node.getPrecision() != null) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "non-default precision not yet supported", new Object[0]);
            }
            switch (node.getFunction()) {
                case DATE: {
                    type = DateType.DATE;
                    break;
                }
                case TIME: {
                    type = TimeWithTimeZoneType.TIME_WITH_TIME_ZONE;
                    break;
                }
                case LOCALTIME: {
                    type = TimeType.TIME;
                    break;
                }
                case TIMESTAMP: {
                    type = TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE;
                    break;
                }
                case LOCALTIMESTAMP: {
                    type = TimestampType.TIMESTAMP;
                    break;
                }
                default: {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "%s not yet supported", node.getFunction().getName());
                }
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)type);
        }

        protected Type visitSymbolReference(SymbolReference node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Optional<ResolvedField> resolvedField;
            if (((Context)context.getContext()).isInLambda() && (resolvedField = ((Context)context.getContext()).getScope().tryResolveField((Expression)node, QualifiedName.of((String)node.getName()))).isPresent() && ((Context)context.getContext()).getFieldToLambdaArgumentDeclaration().containsKey(FieldId.from(resolvedField.get()))) {
                return ExpressionAnalyzer.this.setExpressionType((Expression)node, resolvedField.get().getType());
            }
            Type type = ExpressionAnalyzer.this.symbolTypes.get(Symbol.from((Expression)node));
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        protected Type visitIdentifier(Identifier node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ResolvedField resolvedField = ((Context)context.getContext()).getScope().resolveField((Expression)node, QualifiedName.of((String)node.getValue()));
            return this.handleResolvedField((Expression)node, resolvedField, context);
        }

        private Type handleResolvedField(Expression node, ResolvedField resolvedField, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return this.handleResolvedField(node, FieldId.from(resolvedField), resolvedField.getField(), context);
        }

        private Type handleResolvedField(Expression node, FieldId fieldId, Field field, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            FieldId previous;
            LambdaArgumentDeclaration lambdaArgumentDeclaration;
            if (((Context)context.getContext()).isInLambda() && (lambdaArgumentDeclaration = ((Context)context.getContext()).getFieldToLambdaArgumentDeclaration().get(fieldId)) != null) {
                ExpressionAnalyzer.this.lambdaArgumentReferences.put(NodeRef.of((Node)((Identifier)node)), lambdaArgumentDeclaration);
                return ExpressionAnalyzer.this.setExpressionType(node, field.getType());
            }
            if (field.getOriginTable().isPresent() && field.getOriginColumnName().isPresent()) {
                ExpressionAnalyzer.this.tableColumnReferences.put((Object)field.getOriginTable().get(), (Object)field.getOriginColumnName().get());
            }
            Preconditions.checkState(((previous = ExpressionAnalyzer.this.columnReferences.put(NodeRef.of((Node)node), fieldId)) == null ? 1 : 0) != 0, (String)"%s already known to refer to %s", (Object)node, (Object)previous);
            return ExpressionAnalyzer.this.setExpressionType(node, field.getType());
        }

        protected Type visitDereferenceExpression(DereferenceExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            OptionalInt rowIndex;
            Type baseType;
            QualifiedName qualifiedName = DereferenceExpression.getQualifiedName((DereferenceExpression)node);
            if (qualifiedName != null) {
                Scope scope = ((Context)context.getContext()).getScope();
                Optional<ResolvedField> resolvedField = scope.tryResolveField((Expression)node, qualifiedName);
                if (resolvedField.isPresent()) {
                    return this.handleResolvedField((Expression)node, resolvedField.get(), context);
                }
                if (!scope.isColumnReference(qualifiedName)) {
                    throw SemanticExceptions.missingAttributeException((Expression)node, qualifiedName);
                }
            }
            if (!((baseType = this.process((Node)node.getBase(), context)) instanceof RowType)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getBase(), "Expression %s is not of type ROW", node.getBase());
            }
            RowType rowType = (RowType)baseType;
            String fieldName = node.getField().getValue();
            Type rowFieldType = null;
            for (RowType.Field rowField : rowType.getFields()) {
                if (!fieldName.equalsIgnoreCase(rowField.getName().orElse(null))) continue;
                rowFieldType = rowField.getType();
                break;
            }
            if (ExpressionAnalyzer.this.legacyRowFieldOrdinalAccess && rowFieldType == null && (rowIndex = LegacyRowFieldOrdinalAccessUtil.parseAnonymousRowFieldOrdinalAccess(fieldName, rowType.getFields())).isPresent()) {
                rowFieldType = ((RowType.Field)rowType.getFields().get(rowIndex.getAsInt())).getType();
            }
            if (rowFieldType == null) {
                throw SemanticExceptions.missingAttributeException((Expression)node);
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, rowFieldType);
        }

        protected Type visitNotExpression(NotExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.coerceType(context, node.getValue(), (Type)BooleanType.BOOLEAN, "Value of logical NOT expression");
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitLogicalBinaryExpression(LogicalBinaryExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.coerceType(context, node.getLeft(), (Type)BooleanType.BOOLEAN, "Left side of logical expression");
            this.coerceType(context, node.getRight(), (Type)BooleanType.BOOLEAN, "Right side of logical expression");
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitComparisonExpression(ComparisonExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            OperatorType operatorType = OperatorType.valueOf((String)node.getOperator().name());
            return this.getOperator(context, (Expression)node, operatorType, node.getLeft(), node.getRight());
        }

        protected Type visitIsNullPredicate(IsNullPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.process((Node)node.getValue(), context);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitIsNotNullPredicate(IsNotNullPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.process((Node)node.getValue(), context);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitNullIfExpression(NullIfExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type firstType = this.process((Node)node.getFirst(), context);
            Type secondType = this.process((Node)node.getSecond(), context);
            if (!ExpressionAnalyzer.this.typeManager.getCommonSuperType(firstType, secondType).isPresent()) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Types are not comparable with NULLIF: %s vs %s", firstType, secondType);
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, firstType);
        }

        protected Type visitIfExpression(IfExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.coerceType(context, node.getCondition(), (Type)BooleanType.BOOLEAN, "IF condition");
            Type type = node.getFalseValue().isPresent() ? this.coerceToSingleType(context, (Node)node, "Result types for IF must be the same: %s vs %s", node.getTrueValue(), (Expression)node.getFalseValue().get()) : this.process((Node)node.getTrueValue(), context);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        protected Type visitSearchedCaseExpression(SearchedCaseExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            for (WhenClause whenClause : node.getWhenClauses()) {
                this.coerceType(context, whenClause.getOperand(), (Type)BooleanType.BOOLEAN, "CASE WHEN clause");
            }
            Type type = this.coerceToSingleType(context, "All CASE results must be the same type: %s", this.getCaseResultExpressions(node.getWhenClauses(), node.getDefaultValue()));
            ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
            for (WhenClause whenClause : node.getWhenClauses()) {
                Type whenClauseType = this.process((Node)whenClause.getResult(), context);
                ExpressionAnalyzer.this.setExpressionType((Expression)whenClause, whenClauseType);
            }
            return type;
        }

        protected Type visitSimpleCaseExpression(SimpleCaseExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            for (WhenClause whenClause : node.getWhenClauses()) {
                this.coerceToSingleType(context, (Node)whenClause, "CASE operand type does not match WHEN clause operand type: %s vs %s", node.getOperand(), whenClause.getOperand());
            }
            Type type = this.coerceToSingleType(context, "All CASE results must be the same type: %s", this.getCaseResultExpressions(node.getWhenClauses(), node.getDefaultValue()));
            ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
            for (WhenClause whenClause : node.getWhenClauses()) {
                Type whenClauseType = this.process((Node)whenClause.getResult(), context);
                ExpressionAnalyzer.this.setExpressionType((Expression)whenClause, whenClauseType);
            }
            return type;
        }

        private List<Expression> getCaseResultExpressions(List<WhenClause> whenClauses, Optional<Expression> defaultValue) {
            ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
            for (WhenClause whenClause : whenClauses) {
                resultExpressions.add(whenClause.getResult());
            }
            defaultValue.ifPresent(resultExpressions::add);
            return resultExpressions;
        }

        protected Type visitCoalesceExpression(CoalesceExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type = this.coerceToSingleType(context, "All COALESCE operands must be the same type: %s", node.getOperands());
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        protected Type visitArithmeticUnary(ArithmeticUnaryExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            switch (node.getSign()) {
                case PLUS: {
                    Type type = this.process((Node)node.getValue(), context);
                    if (!(type.equals(DoubleType.DOUBLE) || type.equals(RealType.REAL) || type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT))) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Unary '+' operator cannot by applied to %s type", type);
                    }
                    return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
                }
                case MINUS: {
                    return this.getOperator(context, (Expression)node, OperatorType.NEGATION, node.getValue());
                }
            }
            throw new UnsupportedOperationException("Unsupported unary operator: " + node.getSign());
        }

        protected Type visitArithmeticBinary(ArithmeticBinaryExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return this.getOperator(context, (Expression)node, OperatorType.valueOf((String)node.getOperator().name()), node.getLeft(), node.getRight());
        }

        protected Type visitLikePredicate(LikePredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type valueType = this.process((Node)node.getValue(), context);
            if (!(valueType instanceof CharType) && !(valueType instanceof VarcharType)) {
                this.coerceType(context, node.getValue(), (Type)VarcharType.VARCHAR, "Left side of LIKE expression");
            }
            Type patternType = this.getVarcharType(node.getPattern(), context);
            this.coerceType(context, node.getPattern(), patternType, "Pattern for LIKE expression");
            if (node.getEscape().isPresent()) {
                Expression escape = (Expression)node.getEscape().get();
                Type escapeType = this.getVarcharType(escape, context);
                this.coerceType(context, escape, escapeType, "Escape for LIKE expression");
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        private Type getVarcharType(Expression value, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type = this.process((Node)value, context);
            if (!(type instanceof VarcharType)) {
                return VarcharType.VARCHAR;
            }
            return type;
        }

        protected Type visitSubscriptExpression(SubscriptExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return this.getOperator(context, (Expression)node, OperatorType.SUBSCRIPT, node.getBase(), node.getIndex());
        }

        protected Type visitArrayConstructor(ArrayConstructor node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type = this.coerceToSingleType(context, "All ARRAY elements must be the same type: %s", node.getValues());
            Type arrayType = ExpressionAnalyzer.this.typeManager.getParameterizedType(ArrayParametricType.ARRAY.getName(), (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)type.getTypeSignature())));
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, arrayType);
        }

        protected Type visitStringLiteral(StringLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            VarcharType type = VarcharType.createVarcharType((int)SliceUtf8.countCodePoints((Slice)node.getSlice()));
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)type);
        }

        protected Type visitCharLiteral(CharLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            CharType type = CharType.createCharType((long)node.getValue().length());
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)type);
        }

        protected Type visitBinaryLiteral(BinaryLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)VarbinaryType.VARBINARY);
        }

        protected Type visitLongLiteral(LongLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (node.getValue() >= Integer.MIN_VALUE && node.getValue() <= Integer.MAX_VALUE) {
                return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)IntegerType.INTEGER);
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BigintType.BIGINT);
        }

        protected Type visitDoubleLiteral(DoubleLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)DoubleType.DOUBLE);
        }

        protected Type visitDecimalLiteral(DecimalLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            DecimalParseResult parseResult = Decimals.parse((String)node.getValue());
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)parseResult.getType());
        }

        protected Type visitBooleanLiteral(BooleanLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitGenericLiteral(GenericLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type;
            try {
                type = ExpressionAnalyzer.this.typeManager.getType(TypeSignature.parseTypeSignature((String)node.getType()));
            }
            catch (IllegalArgumentException e) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Unknown type: " + node.getType(), new Object[0]);
            }
            if (!JsonType.JSON.equals(type)) {
                try {
                    ExpressionAnalyzer.this.functionManager.lookupCast(CastType.CAST, VarcharType.VARCHAR.getTypeSignature(), type.getTypeSignature());
                }
                catch (IllegalArgumentException e) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "No literal form for type %s", type);
                }
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        protected Type visitTimeLiteral(TimeLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            boolean hasTimeZone;
            try {
                hasTimeZone = DateTimeUtils.timeHasTimeZone(node.getValue());
            }
            catch (IllegalArgumentException e) {
                throw new SemanticException(SemanticErrorCode.INVALID_LITERAL, (Node)node, "'%s' is not a valid time literal", node.getValue());
            }
            TimeWithTimeZoneType type = hasTimeZone ? TimeWithTimeZoneType.TIME_WITH_TIME_ZONE : TimeType.TIME;
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)type);
        }

        protected Type visitTimestampLiteral(TimestampLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            try {
                if (SystemSessionProperties.isLegacyTimestamp(ExpressionAnalyzer.this.session)) {
                    DateTimeUtils.parseTimestampLiteral(ExpressionAnalyzer.this.session.getTimeZoneKey(), node.getValue());
                } else {
                    DateTimeUtils.parseTimestampLiteral(node.getValue());
                }
            }
            catch (Exception e) {
                throw new SemanticException(SemanticErrorCode.INVALID_LITERAL, (Node)node, "'%s' is not a valid timestamp literal", node.getValue());
            }
            Object type = DateTimeUtils.timestampHasTimeZone(node.getValue()) ? TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE : TimestampType.TIMESTAMP;
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)type);
        }

        protected Type visitIntervalLiteral(IntervalLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Object type = node.isYearToMonth() ? IntervalYearMonthType.INTERVAL_YEAR_MONTH : IntervalDayTimeType.INTERVAL_DAY_TIME;
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)type);
        }

        protected Type visitNullLiteral(NullLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)UnknownType.UNKNOWN);
        }

        protected Type visitFunctionCall(FunctionCall node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (node.getWindow().isPresent()) {
                Type type;
                for (Expression expression : ((Window)node.getWindow().get()).getPartitionBy()) {
                    this.process((Node)expression, context);
                    type = ExpressionAnalyzer.this.getExpressionType(expression);
                    if (type.isComparable()) continue;
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "%s is not comparable, and therefore cannot be used in window function PARTITION BY", type);
                }
                for (SortItem sortItem : NodeUtils.getSortItemsFromOrderBy(((Window)node.getWindow().get()).getOrderBy())) {
                    this.process((Node)sortItem.getSortKey(), context);
                    type = ExpressionAnalyzer.this.getExpressionType(sortItem.getSortKey());
                    if (type.isOrderable()) continue;
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "%s is not orderable, and therefore cannot be used in window function ORDER BY", type);
                }
                if (((Window)node.getWindow().get()).getFrame().isPresent()) {
                    Type type2;
                    WindowFrame frame = (WindowFrame)((Window)node.getWindow().get()).getFrame().get();
                    if (frame.getStart().getValue().isPresent() && !(type2 = this.process((Node)frame.getStart().getValue().get(), context)).equals(IntegerType.INTEGER) && !type2.equals(BigintType.BIGINT)) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Window frame start value type must be INTEGER or BIGINT(actual %s)", type2);
                    }
                    if (frame.getEnd().isPresent() && ((FrameBound)frame.getEnd().get()).getValue().isPresent() && !(type2 = this.process((Node)((FrameBound)frame.getEnd().get()).getValue().get(), context)).equals(IntegerType.INTEGER) && !type2.equals(BigintType.BIGINT)) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Window frame end value type must be INTEGER or BIGINT (actual %s)", type2);
                    }
                }
                ExpressionAnalyzer.this.windowFunctions.add(NodeRef.of((Node)node));
            }
            if (node.getFilter().isPresent()) {
                Expression expression = (Expression)node.getFilter().get();
                this.process((Node)expression, context);
            }
            ImmutableList.Builder argumentTypesBuilder = ImmutableList.builder();
            for (Expression expression : node.getArguments()) {
                if (expression instanceof LambdaExpression || expression instanceof BindExpression) {
                    argumentTypesBuilder.add((Object)new TypeSignatureProvider(types -> {
                        ExpressionAnalyzer innerExpressionAnalyzer = new ExpressionAnalyzer(ExpressionAnalyzer.this.functionManager, ExpressionAnalyzer.this.typeManager, ExpressionAnalyzer.this.statementAnalyzerFactory, ExpressionAnalyzer.this.session, ExpressionAnalyzer.this.symbolTypes, ExpressionAnalyzer.this.parameters, this.warningCollector, ExpressionAnalyzer.this.isDescribe);
                        if (((Context)context.getContext()).isInLambda()) {
                            for (LambdaArgumentDeclaration argument : ((Context)context.getContext()).getFieldToLambdaArgumentDeclaration().values()) {
                                innerExpressionAnalyzer.setExpressionType((Expression)argument, ExpressionAnalyzer.this.getExpressionType((Expression)argument));
                            }
                        }
                        Type type = innerExpressionAnalyzer.analyze(expression, this.baseScope, ((Context)context.getContext()).expectingLambda((List<Type>)types));
                        if (expression instanceof LambdaExpression) {
                            Analyzer.verifyNoAggregateWindowOrGroupingFunctions(innerExpressionAnalyzer.getResolvedFunctions(), ExpressionAnalyzer.this.functionManager, ((LambdaExpression)expression).getBody(), "Lambda expression");
                        }
                        return type.getTypeSignature();
                    }));
                    continue;
                }
                argumentTypesBuilder.add((Object)new TypeSignatureProvider(this.process((Node)expression, context).getTypeSignature()));
            }
            ImmutableList argumentTypes = argumentTypesBuilder.build();
            FunctionHandle function = ExpressionAnalyzer.resolveFunction(ExpressionAnalyzer.this.session, node, (List<TypeSignatureProvider>)argumentTypes, ExpressionAnalyzer.this.functionManager);
            FunctionMetadata functionMetadata = ExpressionAnalyzer.this.functionManager.getFunctionMetadata(function);
            if (node.getOrderBy().isPresent()) {
                for (SortItem sortItem : ((OrderBy)node.getOrderBy().get()).getSortItems()) {
                    Type sortKeyType = this.process((Node)sortItem.getSortKey(), context);
                    if (sortKeyType.isOrderable()) continue;
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "ORDER BY can only be applied to orderable types (actual: %s)", sortKeyType.getDisplayName());
                }
            }
            for (int i = 0; i < node.getArguments().size(); ++i) {
                Expression expression = (Expression)node.getArguments().get(i);
                Type expectedType = ExpressionAnalyzer.this.typeManager.getType((TypeSignature)functionMetadata.getArgumentTypes().get(i));
                Objects.requireNonNull(expectedType, String.format("Type %s not found", functionMetadata.getArgumentTypes().get(i)));
                if (node.isDistinct() && !expectedType.isComparable()) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "DISTINCT can only be applied to comparable types (actual: %s)", expectedType);
                }
                if (((TypeSignatureProvider)argumentTypes.get(i)).hasDependency()) {
                    FunctionType expectedFunctionType = (FunctionType)expectedType;
                    this.process((Node)expression, (StackableAstVisitor.StackableAstVisitorContext<Context>)new StackableAstVisitor.StackableAstVisitorContext((Object)((Context)context.getContext()).expectingLambda(expectedFunctionType.getArgumentTypes())));
                    continue;
                }
                Type actualType = ExpressionAnalyzer.this.typeManager.getType(((TypeSignatureProvider)argumentTypes.get(i)).getTypeSignature());
                this.coerceType(expression, actualType, expectedType, String.format("Function %s argument %d", function, i));
            }
            ExpressionAnalyzer.this.resolvedFunctions.put(NodeRef.of((Node)node), function);
            Type type = ExpressionAnalyzer.this.typeManager.getType(functionMetadata.getReturnType());
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        protected Type visitAtTimeZone(AtTimeZone node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type valueType = this.process((Node)node.getValue(), context);
            this.process((Node)node.getTimeZone(), context);
            if (!(valueType.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE) || valueType.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE) || valueType.equals(TimeType.TIME) || valueType.equals(TimestampType.TIMESTAMP))) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getValue(), "Type of value must be a time or timestamp with or without time zone (actual %s)", valueType);
            }
            Type resultType = valueType;
            if (valueType.equals(TimeType.TIME)) {
                resultType = TimeWithTimeZoneType.TIME_WITH_TIME_ZONE;
            } else if (valueType.equals(TimestampType.TIMESTAMP)) {
                resultType = TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE;
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, resultType);
        }

        protected Type visitCurrentUser(CurrentUser node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)VarcharType.VARCHAR);
        }

        protected Type visitCurrentPath(CurrentPath node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)VarcharType.VARCHAR);
        }

        protected Type visitParameter(Parameter node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (ExpressionAnalyzer.this.isDescribe) {
                return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)UnknownType.UNKNOWN);
            }
            if (ExpressionAnalyzer.this.parameters.size() == 0) {
                throw new SemanticException(SemanticErrorCode.INVALID_PARAMETER_USAGE, (Node)node, "query takes no parameters", new Object[0]);
            }
            if (node.getPosition() >= ExpressionAnalyzer.this.parameters.size()) {
                throw new SemanticException(SemanticErrorCode.INVALID_PARAMETER_USAGE, (Node)node, "invalid parameter index %s, max value is %s", node.getPosition(), ExpressionAnalyzer.this.parameters.size() - 1);
            }
            Type resultType = this.process((Node)ExpressionAnalyzer.this.parameters.get(node.getPosition()), context);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, resultType);
        }

        protected Type visitExtract(Extract node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type = this.process((Node)node.getExpression(), context);
            if (!this.isDateTimeType(type)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getExpression(), "Type of argument to extract must be DATE, TIME, TIMESTAMP, or INTERVAL (actual %s)", type);
            }
            Extract.Field field = node.getField();
            if (!(field != Extract.Field.TIMEZONE_HOUR && field != Extract.Field.TIMEZONE_MINUTE || type.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE) || type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE))) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getExpression(), "Type of argument to extract time zone field must have a time zone (actual %s)", type);
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BigintType.BIGINT);
        }

        private boolean isDateTimeType(Type type) {
            return type.equals(DateType.DATE) || type.equals(TimeType.TIME) || type.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE) || type.equals(TimestampType.TIMESTAMP) || type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE) || type.equals((Object)IntervalDayTimeType.INTERVAL_DAY_TIME) || type.equals((Object)IntervalYearMonthType.INTERVAL_YEAR_MONTH);
        }

        protected Type visitBetweenPredicate(BetweenPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return this.getOperator(context, (Expression)node, OperatorType.BETWEEN, node.getValue(), node.getMin(), node.getMax());
        }

        public Type visitTryExpression(TryExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type = this.process((Node)node.getInnerExpression(), context);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        public Type visitCast(Cast node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type;
            try {
                type = ExpressionAnalyzer.this.typeManager.getType(TypeSignature.parseTypeSignature((String)node.getType()));
            }
            catch (IllegalArgumentException e) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Unknown type: " + node.getType(), new Object[0]);
            }
            if (type.equals((Object)UnknownType.UNKNOWN)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "UNKNOWN is not a valid type", new Object[0]);
            }
            Type value = this.process((Node)node.getExpression(), context);
            if (!value.equals((Object)UnknownType.UNKNOWN) && !node.isTypeOnly()) {
                try {
                    ExpressionAnalyzer.this.functionManager.lookupCast(CastType.CAST, value.getTypeSignature(), type.getTypeSignature());
                }
                catch (OperatorNotFoundException e) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Cannot cast %s to %s", value, type);
                }
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        protected Type visitInPredicate(InPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Expression value = node.getValue();
            this.process((Node)value, context);
            Expression valueList = node.getValueList();
            this.process((Node)valueList, context);
            if (valueList instanceof InListExpression) {
                InListExpression inListExpression = (InListExpression)valueList;
                this.coerceToSingleType(context, "IN value and list items must be the same type: %s", (List<Expression>)ImmutableList.builder().add((Object)value).addAll((Iterable)inListExpression.getValues()).build());
            } else if (valueList instanceof SubqueryExpression) {
                this.coerceToSingleType(context, (Node)node, "value and result of subquery must be of the same type for IN expression: %s vs %s", value, valueList);
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitInListExpression(InListExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type = this.coerceToSingleType(context, "All IN list values must be the same type: %s", node.getValues());
            ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
            return type;
        }

        protected Type visitSubqueryExpression(SubqueryExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (((Context)context.getContext()).isInLambda()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Lambda expression cannot contain subqueries", new Object[0]);
            }
            StatementAnalyzer analyzer = (StatementAnalyzer)ExpressionAnalyzer.this.statementAnalyzerFactory.apply(node);
            Scope subqueryScope = Scope.builder().withParent(((Context)context.getContext()).getScope()).build();
            Scope queryScope = analyzer.analyze((Node)node.getQuery(), subqueryScope);
            if (queryScope.getRelationType().getVisibleFieldCount() != 1) {
                throw new SemanticException(SemanticErrorCode.MULTIPLE_FIELDS_FROM_SUBQUERY, (Node)node, "Multiple columns returned by subquery are not yet supported. Found %s", queryScope.getRelationType().getVisibleFieldCount());
            }
            Node previousNode = context.getPreviousNode().orElse(null);
            if (previousNode instanceof InPredicate && ((InPredicate)previousNode).getValue() != node) {
                ExpressionAnalyzer.this.subqueryInPredicates.add(NodeRef.of((Node)((InPredicate)previousNode)));
            } else if (previousNode instanceof QuantifiedComparisonExpression) {
                ExpressionAnalyzer.this.quantifiedComparisons.add(NodeRef.of((Node)((QuantifiedComparisonExpression)previousNode)));
            } else {
                ExpressionAnalyzer.this.scalarSubqueries.add(NodeRef.of((Node)node));
            }
            Type type = ((Field)Iterables.getOnlyElement(queryScope.getRelationType().getVisibleFields())).getType();
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        protected Type visitExists(ExistsPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            StatementAnalyzer analyzer = (StatementAnalyzer)ExpressionAnalyzer.this.statementAnalyzerFactory.apply(node);
            Scope subqueryScope = Scope.builder().withParent(((Context)context.getContext()).getScope()).build();
            analyzer.analyze((Node)node.getSubquery(), subqueryScope);
            ExpressionAnalyzer.this.existsSubqueries.add(NodeRef.of((Node)node));
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Expression value = node.getValue();
            this.process((Node)value, context);
            Expression subquery = node.getSubquery();
            this.process((Node)subquery, context);
            Type comparisonType = this.coerceToSingleType(context, (Node)node, "Value expression and result of subquery must be of the same type for quantified comparison: %s vs %s", value, subquery);
            switch (node.getOperator()) {
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: {
                    if (comparisonType.isOrderable()) break;
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Type [%s] must be orderable in order to be used in quantified comparison", comparisonType);
                }
                case EQUAL: 
                case NOT_EQUAL: {
                    if (comparisonType.isComparable()) break;
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Type [%s] must be comparable in order to be used in quantified comparison", comparisonType);
                }
                default: {
                    throw new IllegalStateException(String.format("Unexpected comparison type: %s", node.getOperator()));
                }
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        public Type visitFieldReference(FieldReference node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Field field = this.baseScope.getRelationType().getFieldByIndex(node.getFieldIndex());
            return this.handleResolvedField((Expression)node, new FieldId(this.baseScope.getRelationId(), node.getFieldIndex()), field, context);
        }

        protected Type visitLambdaExpression(LambdaExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (!((Context)context.getContext()).isExpectingLambda()) {
                throw new SemanticException(SemanticErrorCode.STANDALONE_LAMBDA, (Node)node, "Lambda expression should always be used inside a function", new Object[0]);
            }
            List<Type> types = ((Context)context.getContext()).getFunctionInputTypes();
            List lambdaArguments = node.getArguments();
            if (types.size() != lambdaArguments.size()) {
                throw new SemanticException(SemanticErrorCode.INVALID_PARAMETER_USAGE, (Node)node, String.format("Expected a lambda that takes %s argument(s) but got %s", types.size(), lambdaArguments.size()), new Object[0]);
            }
            ImmutableList.Builder fields = ImmutableList.builder();
            for (int i = 0; i < lambdaArguments.size(); ++i) {
                LambdaArgumentDeclaration lambdaArgument = (LambdaArgumentDeclaration)lambdaArguments.get(i);
                Type type = types.get(i);
                fields.add((Object)Field.newUnqualified(lambdaArgument.getName().getValue(), type));
                ExpressionAnalyzer.this.setExpressionType((Expression)lambdaArgument, type);
            }
            Scope lambdaScope = Scope.builder().withParent(((Context)context.getContext()).getScope()).withRelationType(RelationId.of((Node)node), new RelationType((List<Field>)fields.build())).build();
            ImmutableMap.Builder fieldToLambdaArgumentDeclaration = ImmutableMap.builder();
            if (((Context)context.getContext()).isInLambda()) {
                fieldToLambdaArgumentDeclaration.putAll(((Context)context.getContext()).getFieldToLambdaArgumentDeclaration());
            }
            for (LambdaArgumentDeclaration lambdaArgument : lambdaArguments) {
                ResolvedField resolvedField = lambdaScope.resolveField((Expression)lambdaArgument, QualifiedName.of((String)lambdaArgument.getName().getValue()));
                fieldToLambdaArgumentDeclaration.put((Object)FieldId.from(resolvedField), (Object)lambdaArgument);
            }
            Type returnType = this.process((Node)node.getBody(), (StackableAstVisitor.StackableAstVisitorContext<Context>)new StackableAstVisitor.StackableAstVisitorContext((Object)Context.inLambda(lambdaScope, (Map<FieldId, LambdaArgumentDeclaration>)fieldToLambdaArgumentDeclaration.build())));
            FunctionType functionType = new FunctionType(types, returnType);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)functionType);
        }

        protected Type visitBindExpression(BindExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Verify.verify((boolean)((Context)context.getContext()).isExpectingLambda(), (String)"bind expression found when lambda is not expected", (Object[])new Object[0]);
            StackableAstVisitor.StackableAstVisitorContext innerContext = new StackableAstVisitor.StackableAstVisitorContext((Object)((Context)context.getContext()).notExpectingLambda());
            ImmutableList.Builder functionInputTypesBuilder = ImmutableList.builder();
            for (Expression value : node.getValues()) {
                functionInputTypesBuilder.add((Object)this.process((Node)value, (StackableAstVisitor.StackableAstVisitorContext<Context>)innerContext));
            }
            functionInputTypesBuilder.addAll(((Context)context.getContext()).getFunctionInputTypes());
            ImmutableList functionInputTypes = functionInputTypesBuilder.build();
            FunctionType functionType = (FunctionType)this.process((Node)node.getFunction(), (StackableAstVisitor.StackableAstVisitorContext<Context>)new StackableAstVisitor.StackableAstVisitorContext((Object)((Context)context.getContext()).expectingLambda((List<Type>)functionInputTypes)));
            List argumentTypes = functionType.getArgumentTypes();
            int numCapturedValues = node.getValues().size();
            Verify.verify((argumentTypes.size() == functionInputTypes.size() ? 1 : 0) != 0);
            for (int i = 0; i < numCapturedValues; ++i) {
                Verify.verify((boolean)((Type)functionInputTypes.get(i)).equals(argumentTypes.get(i)));
            }
            FunctionType result = new FunctionType(argumentTypes.subList(numCapturedValues, argumentTypes.size()), functionType.getReturnType());
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)result);
        }

        protected Type visitExpression(Expression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "not yet implemented: " + node.getClass().getName(), new Object[0]);
        }

        protected Type visitNode(Node node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, node, "not yet implemented: " + node.getClass().getName(), new Object[0]);
        }

        public Type visitGroupingOperation(GroupingOperation node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (node.getGroupingColumns().size() > 63) {
                throw new SemanticException(SemanticErrorCode.INVALID_PROCEDURE_ARGUMENTS, (Node)node, String.format("GROUPING supports up to %d column arguments", 63), new Object[0]);
            }
            for (Expression columnArgument : node.getGroupingColumns()) {
                this.process((Node)columnArgument, context);
            }
            if (node.getGroupingColumns().size() <= 31) {
                return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)IntegerType.INTEGER);
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BigintType.BIGINT);
        }

        private Type getOperator(StackableAstVisitor.StackableAstVisitorContext<Context> context, Expression node, OperatorType operatorType, Expression ... arguments) {
            FunctionMetadata operatorMetadata;
            ImmutableList.Builder argumentTypes = ImmutableList.builder();
            for (Expression expression : arguments) {
                argumentTypes.add((Object)this.process((Node)expression, context));
            }
            try {
                operatorMetadata = ExpressionAnalyzer.this.functionManager.getFunctionMetadata(ExpressionAnalyzer.this.functionManager.resolveOperator(operatorType, TypeSignatureProvider.fromTypes((List<? extends Type>)argumentTypes.build())));
            }
            catch (OperatorNotFoundException e) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "%s", e.getMessage());
            }
            catch (PrestoException e) {
                if (e.getErrorCode().getCode() == StandardErrorCode.AMBIGUOUS_FUNCTION_CALL.toErrorCode().getCode()) {
                    throw new SemanticException(SemanticErrorCode.AMBIGUOUS_FUNCTION_CALL, (Node)node, e.getMessage(), new Object[0]);
                }
                throw e;
            }
            for (int i = 0; i < arguments.length; ++i) {
                Expression expression = arguments[i];
                Type type = ExpressionAnalyzer.this.typeManager.getType((TypeSignature)operatorMetadata.getArgumentTypes().get(i));
                this.coerceType(context, expression, type, String.format("Operator %s argument %d", operatorMetadata, i));
            }
            Type type = ExpressionAnalyzer.this.typeManager.getType(operatorMetadata.getReturnType());
            return ExpressionAnalyzer.this.setExpressionType(node, type);
        }

        private void coerceType(Expression expression, Type actualType, Type expectedType, String message) {
            if (!actualType.equals(expectedType)) {
                if (!ExpressionAnalyzer.this.typeManager.canCoerce(actualType, expectedType)) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)expression, message + " must evaluate to a %s (actual: %s)", expectedType, actualType);
                }
                this.addOrReplaceExpressionCoercion(expression, actualType, expectedType);
            }
        }

        private void coerceType(StackableAstVisitor.StackableAstVisitorContext<Context> context, Expression expression, Type expectedType, String message) {
            Type actualType = this.process((Node)expression, context);
            this.coerceType(expression, actualType, expectedType, message);
        }

        private Type coerceToSingleType(StackableAstVisitor.StackableAstVisitorContext<Context> context, Node node, String message, Expression first, Expression second) {
            Optional superTypeOptional;
            UnknownType firstType = UnknownType.UNKNOWN;
            if (first != null) {
                firstType = this.process((Node)first, context);
            }
            UnknownType secondType = UnknownType.UNKNOWN;
            if (second != null) {
                secondType = this.process((Node)second, context);
            }
            if ((superTypeOptional = ExpressionAnalyzer.this.typeManager.getCommonSuperType((Type)firstType, (Type)secondType)).isPresent() && ExpressionAnalyzer.this.typeManager.canCoerce((Type)firstType, (Type)superTypeOptional.get()) && ExpressionAnalyzer.this.typeManager.canCoerce((Type)secondType, (Type)superTypeOptional.get())) {
                Type superType = (Type)superTypeOptional.get();
                if (!((Object)((Object)firstType)).equals(superType)) {
                    this.addOrReplaceExpressionCoercion(first, (Type)firstType, superType);
                }
                if (!((Object)((Object)secondType)).equals(superType)) {
                    this.addOrReplaceExpressionCoercion(second, (Type)secondType, superType);
                }
                return superType;
            }
            throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, node, message, new Object[]{firstType, secondType});
        }

        private Type coerceToSingleType(StackableAstVisitor.StackableAstVisitorContext<Context> context, String message, List<Expression> expressions) {
            UnknownType superType = UnknownType.UNKNOWN;
            for (Expression expression : expressions) {
                Optional newSuperType = ExpressionAnalyzer.this.typeManager.getCommonSuperType((Type)superType, this.process((Node)expression, context));
                if (!newSuperType.isPresent()) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)expression, message, new Object[]{superType});
                }
                superType = (Type)newSuperType.get();
            }
            for (Expression expression : expressions) {
                Type type = this.process((Node)expression, context);
                if (type.equals((Object)superType)) continue;
                if (!ExpressionAnalyzer.this.typeManager.canCoerce(type, (Type)superType)) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)expression, message, new Object[]{superType});
                }
                this.addOrReplaceExpressionCoercion(expression, type, (Type)superType);
            }
            return superType;
        }

        private void addOrReplaceExpressionCoercion(Expression expression, Type type, Type superType) {
            NodeRef ref = NodeRef.of((Node)expression);
            ExpressionAnalyzer.this.expressionCoercions.put(ref, superType);
            if (ExpressionAnalyzer.this.typeManager.isTypeOnlyCoercion(type, superType)) {
                ExpressionAnalyzer.this.typeOnlyCoercions.add(ref);
            } else if (ExpressionAnalyzer.this.typeOnlyCoercions.contains(ref)) {
                ExpressionAnalyzer.this.typeOnlyCoercions.remove(ref);
            }
        }
    }
}

