/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.Session;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.split.BufferingSplitSource;
import com.facebook.presto.split.ConnectorAwareSplitSource;
import com.facebook.presto.split.SplitSource;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class SplitManager {
    private final ConcurrentMap<ConnectorId, ConnectorSplitManager> splitManagers = new ConcurrentHashMap<ConnectorId, ConnectorSplitManager>();
    private final int minScheduleSplitBatchSize;
    private final Metadata metadata;

    @Inject
    public SplitManager(MetadataManager metadata, QueryManagerConfig config) {
        this.metadata = metadata;
        this.minScheduleSplitBatchSize = config.getMinScheduleSplitBatchSize();
    }

    public void addConnectorSplitManager(ConnectorId connectorId, ConnectorSplitManager connectorSplitManager) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(connectorSplitManager, "connectorSplitManager is null");
        Preconditions.checkState((this.splitManagers.putIfAbsent(connectorId, connectorSplitManager) == null ? 1 : 0) != 0, (String)"SplitManager for connector '%s' is already registered", (Object)connectorId);
    }

    public void removeConnectorSplitManager(ConnectorId connectorId) {
        this.splitManagers.remove(connectorId);
    }

    public SplitSource getSplits(Session session, TableHandle table, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy) {
        ConnectorTableLayoutHandle layout;
        ConnectorId connectorId = table.getConnectorId();
        ConnectorSplitManager splitManager = this.getConnectorSplitManager(connectorId);
        ConnectorSession connectorSession = session.toConnectorSession(connectorId);
        if (!table.getLayout().isPresent()) {
            TableLayoutResult result = this.metadata.getLayout(session, table, (Constraint<ColumnHandle>)Constraint.alwaysTrue(), Optional.empty());
            layout = result.getLayout().getLayoutHandle();
        } else {
            layout = table.getLayout().get();
        }
        ConnectorSplitSource source = splitManager.getSplits(table.getTransaction(), connectorSession, layout, splitSchedulingStrategy);
        SplitSource splitSource = new ConnectorAwareSplitSource(connectorId, table.getTransaction(), source);
        if (this.minScheduleSplitBatchSize > 1) {
            splitSource = new BufferingSplitSource(splitSource, this.minScheduleSplitBatchSize);
        }
        return splitSource;
    }

    private ConnectorSplitManager getConnectorSplitManager(ConnectorId connectorId) {
        ConnectorSplitManager result = (ConnectorSplitManager)this.splitManagers.get(connectorId);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"No split manager for connector '%s'", (Object)connectorId);
        return result;
    }
}

