/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.split.SplitSource;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;

public class SampledSplitSource
implements SplitSource {
    private final SplitSource splitSource;
    private final double sampleRatio;

    public SampledSplitSource(SplitSource splitSource, double sampleRatio) {
        this.splitSource = Objects.requireNonNull(splitSource, "dataSource is null");
        this.sampleRatio = sampleRatio;
    }

    @Override
    @Nullable
    public ConnectorId getConnectorId() {
        return this.splitSource.getConnectorId();
    }

    @Override
    public ConnectorTransactionHandle getTransactionHandle() {
        return this.splitSource.getTransactionHandle();
    }

    @Override
    public ListenableFuture<SplitSource.SplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, Lifespan lifespan, int maxSize) {
        ListenableFuture<SplitSource.SplitBatch> batch = this.splitSource.getNextBatch(partitionHandle, lifespan, maxSize);
        return Futures.transform(batch, splitBatch -> new SplitSource.SplitBatch((List)splitBatch.getSplits().stream().filter(input -> ThreadLocalRandom.current().nextDouble() < this.sampleRatio).collect(ImmutableList.toImmutableList()), splitBatch.isLastBatch()), (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public void rewind(ConnectorPartitionHandle partitionHandle) {
        this.splitSource.rewind(partitionHandle);
    }

    @Override
    public void close() {
        this.splitSource.close();
    }

    @Override
    public boolean isFinished() {
        return this.splitSource.isFinished();
    }
}

