/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.execution.TaskId;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import java.util.Objects;

public class RemoteSplit
implements ConnectorSplit {
    private final URI location;
    private final TaskId remoteSourceTaskId;

    @JsonCreator
    public RemoteSplit(@JsonProperty(value="location") URI location, @JsonProperty(value="remoteSourceTaskId") TaskId remoteSourceTaskId) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.remoteSourceTaskId = Objects.requireNonNull(remoteSourceTaskId, "remoteSourceTaskId is null");
    }

    @JsonProperty
    public URI getLocation() {
        return this.location;
    }

    @JsonProperty
    public TaskId getRemoteSourceTaskId() {
        return this.remoteSourceTaskId;
    }

    public Object getInfo() {
        return this;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public List<HostAddress> getAddresses() {
        return ImmutableList.of();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("location", (Object)this.location).add("remoteSourceTaskId", (Object)this.remoteSourceTaskId).toString();
    }
}

