/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.split.SplitSource;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class ConnectorAwareSplitSource
implements SplitSource {
    private final ConnectorId connectorId;
    private final ConnectorTransactionHandle transactionHandle;
    private final ConnectorSplitSource source;

    public ConnectorAwareSplitSource(ConnectorId connectorId, ConnectorTransactionHandle transactionHandle, ConnectorSplitSource source) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.transactionHandle = Objects.requireNonNull(transactionHandle, "transactionHandle is null");
        this.source = Objects.requireNonNull(source, "source is null");
    }

    @Override
    public ConnectorId getConnectorId() {
        return this.connectorId;
    }

    @Override
    public ConnectorTransactionHandle getTransactionHandle() {
        return this.transactionHandle;
    }

    @Override
    public ListenableFuture<SplitSource.SplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, Lifespan lifespan, int maxSize) {
        ListenableFuture nextBatch = MoreFutures.toListenableFuture((CompletableFuture)this.source.getNextBatch(partitionHandle, maxSize));
        return Futures.transform((ListenableFuture)nextBatch, splitBatch -> {
            ImmutableList.Builder result = ImmutableList.builder();
            for (ConnectorSplit connectorSplit : splitBatch.getSplits()) {
                result.add((Object)new Split(this.connectorId, this.transactionHandle, connectorSplit, lifespan));
            }
            return new SplitSource.SplitBatch((List<Split>)result.build(), splitBatch.isNoMoreSplits());
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public void rewind(ConnectorPartitionHandle partitionHandle) {
        this.source.rewind(partitionHandle);
    }

    @Override
    public void close() {
        this.source.close();
    }

    @Override
    public boolean isFinished() {
        return this.source.isFinished();
    }

    public String toString() {
        return this.connectorId + ":" + this.source;
    }
}

