/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.client.QueryResults;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.CostCalculatorUsingExchanges;
import com.facebook.presto.cost.CostCalculatorWithEstimatedExchanges;
import com.facebook.presto.cost.CostComparator;
import com.facebook.presto.cost.StatsCalculatorModule;
import com.facebook.presto.cost.TaskCountEstimator;
import com.facebook.presto.event.QueryMonitor;
import com.facebook.presto.event.QueryMonitorConfig;
import com.facebook.presto.execution.AddColumnTask;
import com.facebook.presto.execution.CallTask;
import com.facebook.presto.execution.ClusterSizeMonitor;
import com.facebook.presto.execution.CommitTask;
import com.facebook.presto.execution.CreateRoleTask;
import com.facebook.presto.execution.CreateSchemaTask;
import com.facebook.presto.execution.CreateTableTask;
import com.facebook.presto.execution.CreateViewTask;
import com.facebook.presto.execution.DataDefinitionExecution;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.DeallocateTask;
import com.facebook.presto.execution.DropColumnTask;
import com.facebook.presto.execution.DropRoleTask;
import com.facebook.presto.execution.DropSchemaTask;
import com.facebook.presto.execution.DropTableTask;
import com.facebook.presto.execution.DropViewTask;
import com.facebook.presto.execution.ExplainAnalyzeContext;
import com.facebook.presto.execution.ForQueryExecution;
import com.facebook.presto.execution.GrantRolesTask;
import com.facebook.presto.execution.GrantTask;
import com.facebook.presto.execution.PrepareTask;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryExecutionMBean;
import com.facebook.presto.execution.QueryIdGenerator;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryPerformanceFetcher;
import com.facebook.presto.execution.QueryPreparer;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.RenameColumnTask;
import com.facebook.presto.execution.RenameSchemaTask;
import com.facebook.presto.execution.RenameTableTask;
import com.facebook.presto.execution.ResetSessionTask;
import com.facebook.presto.execution.RevokeRolesTask;
import com.facebook.presto.execution.RevokeTask;
import com.facebook.presto.execution.RollbackTask;
import com.facebook.presto.execution.SetPathTask;
import com.facebook.presto.execution.SetRoleTask;
import com.facebook.presto.execution.SetSessionTask;
import com.facebook.presto.execution.SqlQueryExecution;
import com.facebook.presto.execution.SqlQueryManager;
import com.facebook.presto.execution.StartTransactionTask;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.UseTask;
import com.facebook.presto.execution.resourceGroups.InternalResourceGroupManager;
import com.facebook.presto.execution.resourceGroups.LegacyResourceGroupConfigurationManager;
import com.facebook.presto.execution.resourceGroups.ResourceGroupManager;
import com.facebook.presto.execution.scheduler.AllAtOnceExecutionPolicy;
import com.facebook.presto.execution.scheduler.ExecutionPolicy;
import com.facebook.presto.execution.scheduler.PhasedExecutionPolicy;
import com.facebook.presto.execution.scheduler.SplitSchedulerStats;
import com.facebook.presto.failureDetector.FailureDetectorModule;
import com.facebook.presto.memory.ClusterMemoryManager;
import com.facebook.presto.memory.ForMemoryManager;
import com.facebook.presto.memory.LowMemoryKiller;
import com.facebook.presto.memory.MemoryManagerConfig;
import com.facebook.presto.memory.NoneLowMemoryKiller;
import com.facebook.presto.memory.TotalReservationLowMemoryKiller;
import com.facebook.presto.memory.TotalReservationOnBlockedNodesLowMemoryKiller;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.operator.ForScheduler;
import com.facebook.presto.server.ClusterStatsResource;
import com.facebook.presto.server.EmbeddedDiscoveryConfig;
import com.facebook.presto.server.ForStatementResource;
import com.facebook.presto.server.ForWorkerInfo;
import com.facebook.presto.server.GenerateTraceTokenRequestFilter;
import com.facebook.presto.server.NodeResource;
import com.facebook.presto.server.QueryResource;
import com.facebook.presto.server.QuerySessionSupplier;
import com.facebook.presto.server.QueryStateInfoResource;
import com.facebook.presto.server.ResourceGroupStateInfoResource;
import com.facebook.presto.server.SessionSupplier;
import com.facebook.presto.server.StageResource;
import com.facebook.presto.server.StatementHttpExecutionMBean;
import com.facebook.presto.server.WebUiResource;
import com.facebook.presto.server.WorkerResource;
import com.facebook.presto.server.protocol.StatementResource;
import com.facebook.presto.server.remotetask.HttpRemoteTaskFactory;
import com.facebook.presto.server.remotetask.RemoteTaskStats;
import com.facebook.presto.spi.memory.ClusterMemoryPoolManager;
import com.facebook.presto.spi.resourceGroups.QueryType;
import com.facebook.presto.spi.security.SelectedRole;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.planner.PlanFragmenter;
import com.facebook.presto.sql.planner.PlanOptimizers;
import com.facebook.presto.sql.tree.AddColumn;
import com.facebook.presto.sql.tree.Call;
import com.facebook.presto.sql.tree.Commit;
import com.facebook.presto.sql.tree.CreateRole;
import com.facebook.presto.sql.tree.CreateSchema;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.Deallocate;
import com.facebook.presto.sql.tree.DropColumn;
import com.facebook.presto.sql.tree.DropRole;
import com.facebook.presto.sql.tree.DropSchema;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.DropView;
import com.facebook.presto.sql.tree.Grant;
import com.facebook.presto.sql.tree.GrantRoles;
import com.facebook.presto.sql.tree.Prepare;
import com.facebook.presto.sql.tree.RenameColumn;
import com.facebook.presto.sql.tree.RenameSchema;
import com.facebook.presto.sql.tree.RenameTable;
import com.facebook.presto.sql.tree.ResetSession;
import com.facebook.presto.sql.tree.Revoke;
import com.facebook.presto.sql.tree.RevokeRoles;
import com.facebook.presto.sql.tree.Rollback;
import com.facebook.presto.sql.tree.SetPath;
import com.facebook.presto.sql.tree.SetRole;
import com.facebook.presto.sql.tree.SetSession;
import com.facebook.presto.sql.tree.StartTransaction;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.Use;
import com.facebook.presto.transaction.ForTransactionManager;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.transaction.TransactionManagerConfig;
import com.facebook.presto.util.StatementUtils;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.discovery.server.EmbeddedDiscoveryModule;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.http.server.HttpServerBinder;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.json.JsonCodecBinder;
import io.airlift.units.Duration;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.weakref.jmx.ObjectNames;
import org.weakref.jmx.guice.ExportBinder;

public class CoordinatorModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        HttpServerBinder.httpServerBinder((Binder)binder).bindResource("/ui", "webapp").withWelcomeFile("index.html");
        HttpServerBinder.httpServerBinder((Binder)binder).bindResource("/tableau", "webapp/tableau");
        this.install(ConditionalModule.installModuleIf(EmbeddedDiscoveryConfig.class, EmbeddedDiscoveryConfig::isEnabled, (Module)new EmbeddedDiscoveryModule()));
        DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("presto-coordinator");
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(QueryInfo.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskInfo.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(QueryResults.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(SelectedRole.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(StatementResource.class);
        ExportBinder.newExporter((Binder)binder).export(StatementResource.class).withGeneratedName();
        binder.bind(StatementHttpExecutionMBean.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(StatementHttpExecutionMBean.class).withGeneratedName();
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(WebUiResource.class);
        binder.install((Module)new FailureDetectorModule());
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(NodeResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(WorkerResource.class);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("workerInfo", ForWorkerInfo.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(QueryMonitorConfig.class);
        binder.bind(QueryMonitor.class).in(Scopes.SINGLETON);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(QueryResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(StageResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(QueryStateInfoResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ResourceGroupStateInfoResource.class);
        binder.bind(QueryIdGenerator.class).in(Scopes.SINGLETON);
        binder.bind(QueryManager.class).to(SqlQueryManager.class).in(Scopes.SINGLETON);
        binder.bind(QueryPreparer.class).in(Scopes.SINGLETON);
        binder.bind(SessionSupplier.class).to(QuerySessionSupplier.class).in(Scopes.SINGLETON);
        binder.bind(InternalResourceGroupManager.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(InternalResourceGroupManager.class).withGeneratedName();
        binder.bind(ResourceGroupManager.class).to(InternalResourceGroupManager.class);
        binder.bind(LegacyResourceGroupConfigurationManager.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(QueryManager.class).withGeneratedName();
        binder.bind(ClusterMemoryManager.class).in(Scopes.SINGLETON);
        binder.bind(ClusterMemoryPoolManager.class).to(ClusterMemoryManager.class).in(Scopes.SINGLETON);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("memoryManager", ForMemoryManager.class).withTracing().withConfigDefaults(config -> {
            config.setIdleTimeout(new Duration(30.0, TimeUnit.SECONDS));
            config.setRequestTimeout(new Duration(10.0, TimeUnit.SECONDS));
        });
        this.bindLowMemoryKiller("none", NoneLowMemoryKiller.class);
        this.bindLowMemoryKiller("total-reservation", TotalReservationLowMemoryKiller.class);
        this.bindLowMemoryKiller("total-reservation-on-blocked-nodes", TotalReservationOnBlockedNodesLowMemoryKiller.class);
        ExportBinder.newExporter((Binder)binder).export(ClusterMemoryManager.class).withGeneratedName();
        binder.bind(ClusterSizeMonitor.class).in(Scopes.SINGLETON);
        binder.install((Module)new StatsCalculatorModule());
        binder.bind(TaskCountEstimator.class).in(Scopes.SINGLETON);
        binder.bind(CostCalculator.class).to(CostCalculatorUsingExchanges.class).in(Scopes.SINGLETON);
        binder.bind(CostCalculator.class).annotatedWith(CostCalculator.EstimatedExchanges.class).to(CostCalculatorWithEstimatedExchanges.class).in(Scopes.SINGLETON);
        binder.bind(CostComparator.class).in(Scopes.SINGLETON);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ClusterStatsResource.class);
        binder.bind(PlanFragmenter.class).in(Scopes.SINGLETON);
        binder.bind(PlanOptimizers.class).in(Scopes.SINGLETON);
        binder.bind(QueryExplainer.class).in(Scopes.SINGLETON);
        binder.bind(ExplainAnalyzeContext.class).in(Scopes.SINGLETON);
        binder.bind(RemoteTaskFactory.class).to(HttpRemoteTaskFactory.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(RemoteTaskFactory.class).withGeneratedName();
        binder.bind(RemoteTaskStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(RemoteTaskStats.class).withGeneratedName();
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("scheduler", ForScheduler.class).withTracing().withFilter(GenerateTraceTokenRequestFilter.class).withConfigDefaults(config -> {
            config.setIdleTimeout(new Duration(30.0, TimeUnit.SECONDS));
            config.setRequestTimeout(new Duration(10.0, TimeUnit.SECONDS));
            config.setMaxConnectionsPerServer(250);
        });
        binder.bind(ScheduledExecutorService.class).annotatedWith(ForScheduler.class).toInstance((Object)Executors.newSingleThreadScheduledExecutor(Threads.threadsNamed((String)"stage-scheduler")));
        binder.bind(ExecutorService.class).annotatedWith(ForQueryExecution.class).toInstance((Object)Executors.newCachedThreadPool(Threads.threadsNamed((String)"query-execution-%s")));
        binder.bind(QueryExecutionMBean.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(QueryExecutionMBean.class).as(ObjectNames.generatedNameOf(QueryExecution.class));
        MapBinder executionBinder = MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<? extends Statement>>(){}, (TypeLiteral)new TypeLiteral<QueryExecution.QueryExecutionFactory<?>>(){});
        binder.bind(SplitSchedulerStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(SplitSchedulerStats.class).withGeneratedName();
        binder.bind(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        StatementUtils.getAllQueryTypes().entrySet().stream().filter(entry -> entry.getValue() != QueryType.DATA_DEFINITION).forEach(entry -> executionBinder.addBinding(entry.getKey()).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON));
        binder.bind(DataDefinitionExecution.DataDefinitionExecutionFactory.class).in(Scopes.SINGLETON);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, CreateSchema.class, CreateSchemaTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, DropSchema.class, DropSchemaTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, RenameSchema.class, RenameSchemaTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, AddColumn.class, AddColumnTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, CreateTable.class, CreateTableTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, RenameTable.class, RenameTableTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, RenameColumn.class, RenameColumnTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, DropColumn.class, DropColumnTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, DropTable.class, DropTableTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, CreateView.class, CreateViewTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, DropView.class, DropViewTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, Use.class, UseTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, SetSession.class, SetSessionTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, ResetSession.class, ResetSessionTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, StartTransaction.class, StartTransactionTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, Commit.class, CommitTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, Rollback.class, RollbackTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, Call.class, CallTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, CreateRole.class, CreateRoleTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, DropRole.class, DropRoleTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, GrantRoles.class, GrantRolesTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, RevokeRoles.class, RevokeRolesTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, SetRole.class, SetRoleTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, Grant.class, GrantTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, Revoke.class, RevokeTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, Prepare.class, PrepareTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, Deallocate.class, DeallocateTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, SetPath.class, SetPathTask.class);
        MapBinder executionPolicyBinder = MapBinder.newMapBinder((Binder)binder, String.class, ExecutionPolicy.class);
        executionPolicyBinder.addBinding((Object)"all-at-once").to(AllAtOnceExecutionPolicy.class);
        executionPolicyBinder.addBinding((Object)"phased").to(PhasedExecutionPolicy.class);
        binder.bind(ExecutorCleanup.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public static ResourceGroupManager<?> getResourceGroupManager(ResourceGroupManager manager) {
        return manager;
    }

    @Provides
    @Singleton
    public static QueryPerformanceFetcher createQueryPerformanceFetcher(QueryManager queryManager) {
        return queryManager::getFullQueryInfo;
    }

    @Provides
    @Singleton
    @ForStatementResource
    public static ExecutorService createStatementResponseCoreExecutor() {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"statement-response-%s"));
    }

    @Provides
    @Singleton
    @ForStatementResource
    public static BoundedExecutor createStatementResponseExecutor(@ForStatementResource ExecutorService coreExecutor, TaskManagerConfig config) {
        return new BoundedExecutor((Executor)coreExecutor, config.getHttpResponseThreads());
    }

    @Provides
    @Singleton
    @ForStatementResource
    public static ScheduledExecutorService createStatementTimeoutExecutor(TaskManagerConfig config) {
        return Executors.newScheduledThreadPool(config.getHttpTimeoutThreads(), Threads.daemonThreadsNamed((String)"statement-timeout-%s"));
    }

    @Provides
    @Singleton
    @ForTransactionManager
    public static ScheduledExecutorService createTransactionIdleCheckExecutor() {
        return Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"transaction-idle-check"));
    }

    @Provides
    @Singleton
    @ForTransactionManager
    public static ExecutorService createTransactionFinishingExecutor() {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"transaction-finishing-%s"));
    }

    @Provides
    @Singleton
    public static TransactionManager createTransactionManager(TransactionManagerConfig config, CatalogManager catalogManager, @ForTransactionManager ScheduledExecutorService idleCheckExecutor, @ForTransactionManager ExecutorService finishingExecutor) {
        return InMemoryTransactionManager.create(config, idleCheckExecutor, catalogManager, finishingExecutor);
    }

    private static <T extends Statement> void bindDataDefinitionTask(Binder binder, MapBinder<Class<? extends Statement>, QueryExecution.QueryExecutionFactory<?>> executionBinder, Class<T> statement, Class<? extends DataDefinitionTask<T>> task) {
        Verify.verify((StatementUtils.getAllQueryTypes().get(statement) == QueryType.DATA_DEFINITION ? 1 : 0) != 0);
        MapBinder taskBinder = MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<? extends Statement>>(){}, (TypeLiteral)new TypeLiteral<DataDefinitionTask<?>>(){});
        taskBinder.addBinding(statement).to(task).in(Scopes.SINGLETON);
        executionBinder.addBinding(statement).to(DataDefinitionExecution.DataDefinitionExecutionFactory.class).in(Scopes.SINGLETON);
    }

    private void bindLowMemoryKiller(String name, Class<? extends LowMemoryKiller> clazz) {
        this.install(ConditionalModule.installModuleIf(MemoryManagerConfig.class, config -> name.equals(config.getLowMemoryKillerPolicy()), binder -> binder.bind(LowMemoryKiller.class).to(clazz).in(Scopes.SINGLETON)));
    }

    public static class ExecutorCleanup {
        private final List<ExecutorService> executors;

        @Inject
        public ExecutorCleanup(@ForStatementResource ExecutorService statementResponseExecutor, @ForStatementResource ScheduledExecutorService statementTimeoutExecutor, @ForQueryExecution ExecutorService queryExecutionExecutor, @ForScheduler ScheduledExecutorService schedulerExecutor, @ForTransactionManager ExecutorService transactionFinishingExecutor, @ForTransactionManager ScheduledExecutorService transactionIdleExecutor) {
            this.executors = ImmutableList.builder().add((Object)statementResponseExecutor).add((Object)statementTimeoutExecutor).add((Object)queryExecutionExecutor).add((Object)schedulerExecutor).add((Object)transactionFinishingExecutor).add((Object)transactionIdleExecutor).build();
        }

        @PreDestroy
        public void shutdown() {
            this.executors.forEach(ExecutorService::shutdownNow);
        }
    }
}

