/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@ScalarFunction(value="array_sort")
@Description(value="Sorts the given array in ascending order according to the natural ordering of its elements.")
public final class ArraySortFunction {
    private final PageBuilder pageBuilder;
    private static final int INITIAL_LENGTH = 128;
    private List<Integer> positions = Ints.asList((int[])new int[128]);

    @TypeParameter(value="E")
    public ArraySortFunction(@TypeParameter(value="E") Type elementType) {
        this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)elementType));
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block sort(@OperatorDependency(operator=OperatorType.LESS_THAN, argumentTypes={"E", "E"}) MethodHandle lessThanFunction, final @TypeParameter(value="E") Type type, final @SqlType(value="array(E)") Block block) {
        int arrayLength = block.getPositionCount();
        if (this.positions.size() < arrayLength) {
            this.positions = Ints.asList((int[])new int[arrayLength]);
        }
        for (int i = 0; i < arrayLength; ++i) {
            this.positions.set(i, i);
        }
        Collections.sort(this.positions.subList(0, arrayLength), new Comparator<Integer>(){

            @Override
            public int compare(Integer p1, Integer p2) {
                boolean nullLeft = block.isNull(p1.intValue());
                boolean nullRight = block.isNull(p2.intValue());
                if (nullLeft && nullRight) {
                    return 0;
                }
                if (nullLeft) {
                    return 1;
                }
                if (nullRight) {
                    return -1;
                }
                try {
                    return type.compareTo(block, p1.intValue(), block, p2.intValue());
                }
                catch (PrestoException e) {
                    if (e.getErrorCode() == StandardErrorCode.NOT_SUPPORTED.toErrorCode()) {
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Array contains elements not supported for comparison", (Throwable)e);
                    }
                    throw e;
                }
            }
        });
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        BlockBuilder blockBuilder = this.pageBuilder.getBlockBuilder(0);
        for (int i = 0; i < arrayLength; ++i) {
            type.appendTo(block, this.positions.get(i).intValue(), blockBuilder);
        }
        this.pageBuilder.declarePositions(arrayLength);
        return blockBuilder.getRegion(blockBuilder.getPositionCount() - arrayLength, arrayLength);
    }
}

