/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.builder;

import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.HashCollisionsCounter;
import com.facebook.presto.operator.MergeHashSort;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.Work;
import com.facebook.presto.operator.WorkProcessor;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.builder.HashAggregationBuilder;
import com.facebook.presto.operator.aggregation.builder.InMemoryHashAggregationBuilder;
import com.facebook.presto.operator.aggregation.builder.MergingHashAggregationBuilder;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spiller.Spiller;
import com.facebook.presto.spiller.SpillerFactory;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public class SpillableHashAggregationBuilder
implements HashAggregationBuilder {
    private InMemoryHashAggregationBuilder hashAggregationBuilder;
    private final SpillerFactory spillerFactory;
    private final List<AccumulatorFactory> accumulatorFactories;
    private final AggregationNode.Step step;
    private final int expectedGroups;
    private final List<Type> groupByTypes;
    private final List<Integer> groupByChannels;
    private final Optional<Integer> hashChannel;
    private final OperatorContext operatorContext;
    private final LocalMemoryContext localUserMemoryContext;
    private final LocalMemoryContext localRevocableMemoryContext;
    private final long memoryLimitForMerge;
    private final long memoryLimitForMergeWithMemory;
    private Optional<Spiller> spiller = Optional.empty();
    private Optional<MergingHashAggregationBuilder> merger = Optional.empty();
    private Optional<MergeHashSort> mergeHashSort = Optional.empty();
    private ListenableFuture<?> spillInProgress = Futures.immediateFuture(null);
    private final JoinCompiler joinCompiler;
    private long emptyHashAggregationBuilderSize;
    private long hashCollisions;
    private double expectedHashCollisions;

    public SpillableHashAggregationBuilder(List<AccumulatorFactory> accumulatorFactories, AggregationNode.Step step, int expectedGroups, List<Type> groupByTypes, List<Integer> groupByChannels, Optional<Integer> hashChannel, OperatorContext operatorContext, DataSize memoryLimitForMerge, DataSize memoryLimitForMergeWithMemory, SpillerFactory spillerFactory, JoinCompiler joinCompiler) {
        this.accumulatorFactories = accumulatorFactories;
        this.step = step;
        this.expectedGroups = expectedGroups;
        this.groupByTypes = groupByTypes;
        this.groupByChannels = groupByChannels;
        this.hashChannel = hashChannel;
        this.operatorContext = operatorContext;
        this.localUserMemoryContext = operatorContext.localUserMemoryContext();
        this.localRevocableMemoryContext = operatorContext.localRevocableMemoryContext();
        this.memoryLimitForMerge = memoryLimitForMerge.toBytes();
        this.memoryLimitForMergeWithMemory = memoryLimitForMergeWithMemory.toBytes();
        this.spillerFactory = spillerFactory;
        this.joinCompiler = joinCompiler;
        this.rebuildHashAggregationBuilder();
    }

    @Override
    public Work<?> processPage(Page page) {
        Preconditions.checkState((boolean)this.hasPreviousSpillCompletedSuccessfully(), (Object)"Previous spill hasn't yet finished");
        return this.hashAggregationBuilder.processPage(page);
    }

    @Override
    public void updateMemory() {
        Preconditions.checkState((boolean)this.spillInProgress.isDone());
        this.localUserMemoryContext.setBytes(this.emptyHashAggregationBuilderSize);
        this.localRevocableMemoryContext.setBytes(this.hashAggregationBuilder.getSizeInMemory() - this.emptyHashAggregationBuilderSize);
    }

    public long getSizeInMemory() {
        return this.hashAggregationBuilder.getSizeInMemory() + this.hashAggregationBuilder.getGroupIdsSortingSize();
    }

    @Override
    public void recordHashCollisions(HashCollisionsCounter hashCollisionsCounter) {
        hashCollisionsCounter.recordHashCollision(this.hashCollisions, this.expectedHashCollisions);
        this.hashCollisions = 0L;
        this.expectedHashCollisions = 0.0;
    }

    @Override
    public boolean isFull() {
        return false;
    }

    private boolean hasPreviousSpillCompletedSuccessfully() {
        if (this.spillInProgress.isDone()) {
            MoreFutures.getFutureValue(this.spillInProgress);
            return true;
        }
        return false;
    }

    @Override
    public ListenableFuture<?> startMemoryRevoke() {
        Preconditions.checkState((boolean)this.spillInProgress.isDone());
        this.spillToDisk();
        return this.spillInProgress;
    }

    @Override
    public void finishMemoryRevoke() {
        this.updateMemory();
    }

    private boolean shouldMergeWithMemory(long memorySize) {
        return memorySize < this.memoryLimitForMergeWithMemory;
    }

    @Override
    public WorkProcessor<Page> buildResult() {
        Preconditions.checkState((boolean)this.hasPreviousSpillCompletedSuccessfully(), (Object)"Previous spill hasn't yet finished");
        if (!this.spiller.isPresent()) {
            return this.hashAggregationBuilder.buildResult();
        }
        if (this.shouldMergeWithMemory(this.getSizeInMemory())) {
            return this.mergeFromDiskAndMemory();
        }
        MoreFutures.getFutureValue(this.spillToDisk());
        return this.mergeFromDisk();
    }

    @Override
    public void close() {
        try (Closer closer = Closer.create();){
            if (this.hashAggregationBuilder != null) {
                closer.register(this.hashAggregationBuilder::close);
            }
            this.merger.ifPresent(arg_0 -> ((Closer)closer).register(arg_0));
            this.spiller.ifPresent(arg_0 -> ((Closer)closer).register(arg_0));
            this.mergeHashSort.ifPresent(arg_0 -> ((Closer)closer).register(arg_0));
            closer.register(() -> this.localUserMemoryContext.setBytes(0L));
            closer.register(() -> this.localRevocableMemoryContext.setBytes(0L));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ListenableFuture<?> spillToDisk() {
        Preconditions.checkState((boolean)this.hasPreviousSpillCompletedSuccessfully(), (Object)"Previous spill hasn't yet finished");
        this.hashAggregationBuilder.setOutputPartial();
        if (!this.spiller.isPresent()) {
            this.spiller = Optional.of(this.spillerFactory.create(this.hashAggregationBuilder.buildTypes(), this.operatorContext.getSpillContext(), this.operatorContext.newAggregateSystemMemoryContext()));
        }
        this.spillInProgress = this.spiller.get().spill(this.hashAggregationBuilder.buildHashSortedResult().iterator());
        this.rebuildHashAggregationBuilder();
        return this.spillInProgress;
    }

    private WorkProcessor<Page> mergeFromDiskAndMemory() {
        Preconditions.checkState((boolean)this.spiller.isPresent());
        this.hashAggregationBuilder.setOutputPartial();
        this.mergeHashSort = Optional.of(new MergeHashSort(this.operatorContext.newAggregateSystemMemoryContext()));
        WorkProcessor<Page> mergedSpilledPages = this.mergeHashSort.get().merge(this.groupByTypes, this.hashAggregationBuilder.buildIntermediateTypes(), (List<WorkProcessor<Page>>)ImmutableList.builder().addAll((Iterable)this.spiller.get().getSpills().stream().map(WorkProcessor::fromIterator).collect(ImmutableList.toImmutableList())).add(this.hashAggregationBuilder.buildHashSortedResult()).build(), this.operatorContext.getDriverContext().getYieldSignal());
        return this.mergeSortedPages(mergedSpilledPages, Math.max(this.memoryLimitForMerge - this.memoryLimitForMergeWithMemory, 1L));
    }

    private WorkProcessor<Page> mergeFromDisk() {
        Preconditions.checkState((boolean)this.spiller.isPresent());
        this.mergeHashSort = Optional.of(new MergeHashSort(this.operatorContext.newAggregateSystemMemoryContext()));
        WorkProcessor<Page> mergedSpilledPages = this.mergeHashSort.get().merge(this.groupByTypes, this.hashAggregationBuilder.buildIntermediateTypes(), (List)this.spiller.get().getSpills().stream().map(WorkProcessor::fromIterator).collect(ImmutableList.toImmutableList()), this.operatorContext.getDriverContext().getYieldSignal());
        return this.mergeSortedPages(mergedSpilledPages, this.memoryLimitForMerge);
    }

    private WorkProcessor<Page> mergeSortedPages(WorkProcessor<Page> sortedPages, long memoryLimitForMerge) {
        this.merger = Optional.of(new MergingHashAggregationBuilder(this.accumulatorFactories, this.step, this.expectedGroups, this.groupByTypes, this.hashChannel, this.operatorContext, sortedPages, this.operatorContext.newLocalSystemMemoryContext(SpillableHashAggregationBuilder.class.getSimpleName()), memoryLimitForMerge, this.hashAggregationBuilder.getKeyChannels(), this.joinCompiler));
        return this.merger.get().buildResult();
    }

    private void rebuildHashAggregationBuilder() {
        if (this.hashAggregationBuilder != null) {
            this.hashCollisions += this.hashAggregationBuilder.getHashCollisions();
            this.expectedHashCollisions += this.hashAggregationBuilder.getExpectedHashCollisions();
            this.hashAggregationBuilder.close();
        }
        this.hashAggregationBuilder = new InMemoryHashAggregationBuilder(this.accumulatorFactories, this.step, this.expectedGroups, this.groupByTypes, this.groupByChannels, this.hashChannel, this.operatorContext, Optional.of(DataSize.succinctBytes((long)0L)), this.joinCompiler, false, false);
        this.emptyHashAggregationBuilderSize = this.hashAggregationBuilder.getSizeInMemory();
    }
}

