/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.AverageAggregations;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.state.DoubleState;
import com.facebook.presto.operator.aggregation.state.LongState;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.DynamicClassLoader;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class RealAverageAggregation
extends SqlAggregationFunction {
    public static final RealAverageAggregation REAL_AVERAGE_AGGREGATION = new RealAverageAggregation();
    private static final String NAME = "avg";
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(RealAverageAggregation.class, "input", LongState.class, DoubleState.class, Long.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(RealAverageAggregation.class, "combine", LongState.class, DoubleState.class, LongState.class, DoubleState.class);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(RealAverageAggregation.class, "output", LongState.class, DoubleState.class, BlockBuilder.class);

    protected RealAverageAggregation() {
        super(NAME, (List<TypeVariableConstraint>)ImmutableList.of(), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"real"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"real")));
    }

    @Override
    public String getDescription() {
        return "Returns the average value of the argument";
    }

    @Override
    public InternalAggregationFunction specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionManager functionManager) {
        DynamicClassLoader classLoader = new DynamicClassLoader(AverageAggregations.class.getClassLoader());
        Class<LongState> longStateInterface = LongState.class;
        Class<DoubleState> doubleStateInterface = DoubleState.class;
        AccumulatorStateSerializer<LongState> longStateSerializer = StateCompiler.generateStateSerializer(longStateInterface, classLoader);
        AccumulatorStateSerializer<DoubleState> doubleStateSerializer = StateCompiler.generateStateSerializer(doubleStateInterface, classLoader);
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, TypeSignature.parseTypeSignature((String)"real"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"real"))), (List<AggregationMetadata.ParameterMetadata>)ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, (Type)RealType.REAL)), INPUT_FUNCTION, COMBINE_FUNCTION, OUTPUT_FUNCTION, (List<AggregationMetadata.AccumulatorStateDescriptor>)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(longStateInterface, longStateSerializer, StateCompiler.generateStateFactory(longStateInterface, classLoader)), (Object)new AggregationMetadata.AccumulatorStateDescriptor(doubleStateInterface, doubleStateSerializer, StateCompiler.generateStateFactory(doubleStateInterface, classLoader))), (Type)RealType.REAL);
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(NAME, (List<Type>)ImmutableList.of((Object)RealType.REAL), (List<Type>)ImmutableList.of((Object)longStateSerializer.getSerializedType(), (Object)doubleStateSerializer.getSerializedType()), (Type)RealType.REAL, true, false, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type value) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, value), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void input(LongState count, DoubleState sum, long value) {
        count.setLong(count.getLong() + 1L);
        sum.setDouble(sum.getDouble() + (double)Float.intBitsToFloat((int)value));
    }

    public static void combine(LongState count, DoubleState sum, LongState otherCount, DoubleState otherSum) {
        count.setLong(count.getLong() + otherCount.getLong());
        sum.setDouble(sum.getDouble() + otherSum.getDouble());
    }

    public static void output(LongState count, DoubleState sum, BlockBuilder out) {
        if (count.getLong() == 0L) {
            out.appendNull();
        } else {
            RealType.REAL.writeLong(out, (long)Float.floatToIntBits((float)(sum.getDouble() / (double)count.getLong())));
        }
    }
}

