/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.ApproximateLongPercentileArrayAggregations;
import com.facebook.presto.operator.aggregation.FloatingPointBitsConverterUtil;
import com.facebook.presto.operator.aggregation.state.DigestAndPercentileArrayState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.RealType;
import io.airlift.stats.QuantileDigest;
import java.util.List;

@AggregationFunction(value="approx_percentile")
public class ApproximateRealPercentileArrayAggregations {
    private ApproximateRealPercentileArrayAggregations() {
    }

    @InputFunction
    public static void input(@AggregationState DigestAndPercentileArrayState state, @SqlType(value="real") long value, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        ApproximateLongPercentileArrayAggregations.input(state, FloatingPointBitsConverterUtil.floatToSortableInt(Float.intBitsToFloat((int)value)), percentilesArrayBlock);
    }

    @InputFunction
    public static void weightedInput(@AggregationState DigestAndPercentileArrayState state, @SqlType(value="real") long value, @SqlType(value="bigint") long weight, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        ApproximateLongPercentileArrayAggregations.weightedInput(state, FloatingPointBitsConverterUtil.floatToSortableInt(Float.intBitsToFloat((int)value)), weight, percentilesArrayBlock);
    }

    @CombineFunction
    public static void combine(@AggregationState DigestAndPercentileArrayState state, @AggregationState DigestAndPercentileArrayState otherState) {
        ApproximateLongPercentileArrayAggregations.combine(state, otherState);
    }

    @OutputFunction(value="array(real)")
    public static void output(@AggregationState DigestAndPercentileArrayState state, BlockBuilder out) {
        QuantileDigest digest = state.getDigest();
        List<Double> percentiles = state.getPercentiles();
        if (percentiles == null || digest == null) {
            out.appendNull();
            return;
        }
        BlockBuilder blockBuilder = out.beginBlockEntry();
        for (int i = 0; i < percentiles.size(); ++i) {
            Double percentile = percentiles.get(i);
            RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(FloatingPointBitsConverterUtil.sortableIntToFloat((int)digest.getQuantile(percentile.doubleValue()))));
        }
        out.closeEntry();
    }
}

