/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.JoinBridgeManager;
import com.facebook.presto.operator.NestedLoopJoinBridge;
import com.facebook.presto.operator.NestedLoopJoinPages;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import java.io.Closeable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;

public class NestedLoopJoinOperator
implements Operator,
Closeable {
    private final ListenableFuture<NestedLoopJoinPages> nestedLoopJoinPagesFuture;
    private final OperatorContext operatorContext;
    private final Runnable afterClose;
    private List<Page> buildPages;
    private Page probePage;
    private Iterator<Page> buildPageIterator;
    private NestedLoopPageBuilder nestedLoopPageBuilder;
    private boolean finishing;
    private boolean closed;

    private NestedLoopJoinOperator(OperatorContext operatorContext, NestedLoopJoinBridge joinBridge, Runnable afterClose) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.nestedLoopJoinPagesFuture = joinBridge.getPagesFuture();
        this.afterClose = Objects.requireNonNull(afterClose, "afterClose is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        boolean finished;
        boolean bl = finished = this.finishing && this.probePage == null;
        if (finished) {
            this.close();
        }
        return finished;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.nestedLoopJoinPagesFuture;
    }

    @Override
    public boolean needsInput() {
        Optional nestedLoopJoinPages;
        if (this.finishing || this.probePage != null) {
            return false;
        }
        if (this.buildPages == null && (nestedLoopJoinPages = MoreFutures.tryGetFutureValue(this.nestedLoopJoinPagesFuture)).isPresent()) {
            this.buildPages = ((NestedLoopJoinPages)nestedLoopJoinPages.get()).getPages();
        }
        return this.buildPages != null;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is finishing");
        Preconditions.checkState((this.buildPages != null ? 1 : 0) != 0, (Object)"Page source has not been built yet");
        Preconditions.checkState((this.probePage == null ? 1 : 0) != 0, (Object)"Current page has not been completely processed yet");
        Preconditions.checkState((this.buildPageIterator == null || !this.buildPageIterator.hasNext() ? 1 : 0) != 0, (Object)"Current buildPageIterator has not been completely processed yet");
        if (page.getPositionCount() > 0) {
            this.probePage = page;
            this.buildPageIterator = this.buildPages.iterator();
        }
    }

    @Override
    public Page getOutput() {
        if (this.probePage == null || this.buildPages == null) {
            return null;
        }
        if (this.nestedLoopPageBuilder != null && this.nestedLoopPageBuilder.hasNext()) {
            return this.nestedLoopPageBuilder.next();
        }
        if (this.buildPageIterator.hasNext()) {
            this.nestedLoopPageBuilder = new NestedLoopPageBuilder(this.probePage, this.buildPageIterator.next());
            return this.nestedLoopPageBuilder.next();
        }
        this.probePage = null;
        return null;
    }

    @Override
    public void close() {
        this.buildPages = null;
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.afterClose.run();
    }

    @VisibleForTesting
    static class NestedLoopPageBuilder
    implements Iterator<Page> {
        private final int numberOfProbeColumns;
        private final int numberOfBuildColumns;
        private final boolean buildPageLarger;
        private final Page largePage;
        private final Page smallPage;
        private final int maxRowIndex;
        private int rowIndex;
        private final int noColumnShortcutResult;

        NestedLoopPageBuilder(Page probePage, Page buildPage) {
            Objects.requireNonNull(probePage, "probePage is null");
            Preconditions.checkArgument((probePage.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"probePage has no rows");
            Objects.requireNonNull(buildPage, "buildPage is null");
            Preconditions.checkArgument((buildPage.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"buildPage has no rows");
            this.numberOfProbeColumns = probePage.getChannelCount();
            this.numberOfBuildColumns = buildPage.getChannelCount();
            this.rowIndex = -1;
            this.buildPageLarger = buildPage.getPositionCount() > probePage.getPositionCount();
            this.maxRowIndex = Math.min(buildPage.getPositionCount(), probePage.getPositionCount()) - 1;
            this.largePage = this.buildPageLarger ? buildPage : probePage;
            this.smallPage = this.buildPageLarger ? probePage : buildPage;
            this.noColumnShortcutResult = NestedLoopPageBuilder.calculateUseNoColumnShortcut(this.numberOfProbeColumns, this.numberOfBuildColumns, probePage.getPositionCount(), buildPage.getPositionCount());
        }

        private static int calculateUseNoColumnShortcut(int numberOfProbeColumns, int numberOfBuildColumns, int positionCountProbe, int positionCountBuild) {
            if (numberOfProbeColumns == 0 && numberOfBuildColumns == 0) {
                try {
                    return Math.multiplyExact(positionCountProbe, positionCountBuild);
                }
                catch (ArithmeticException arithmeticException) {
                    // empty catch block
                }
            }
            return -1;
        }

        @Override
        public boolean hasNext() {
            return this.rowIndex < this.maxRowIndex;
        }

        @Override
        public Page next() {
            int i;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.noColumnShortcutResult >= 0) {
                this.rowIndex = this.maxRowIndex;
                return new Page(this.noColumnShortcutResult, new Block[0]);
            }
            ++this.rowIndex;
            Block[] blocks = new Block[this.numberOfProbeColumns + this.numberOfBuildColumns];
            int indexForRleBlocks = this.buildPageLarger ? 0 : this.numberOfProbeColumns;
            int indexForPageBlocks = this.buildPageLarger ? this.numberOfProbeColumns : 0;
            for (i = 0; i < this.smallPage.getChannelCount(); ++i) {
                Block block = this.smallPage.getBlock(i).getSingleValueBlock(this.rowIndex);
                blocks[indexForRleBlocks] = new RunLengthEncodedBlock(block, this.largePage.getPositionCount());
                ++indexForRleBlocks;
            }
            for (i = 0; i < this.largePage.getChannelCount(); ++i) {
                blocks[indexForPageBlocks + i] = this.largePage.getBlock(i);
            }
            return new Page(this.largePage.getPositionCount(), blocks);
        }
    }

    public static class NestedLoopJoinOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final JoinBridgeManager<NestedLoopJoinBridge> joinBridgeManager;
        private boolean closed;

        public NestedLoopJoinOperatorFactory(int operatorId, PlanNodeId planNodeId, JoinBridgeManager<NestedLoopJoinBridge> nestedLoopJoinBridgeManager) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.joinBridgeManager = nestedLoopJoinBridgeManager;
            this.joinBridgeManager.incrementProbeFactoryCount();
        }

        private NestedLoopJoinOperatorFactory(NestedLoopJoinOperatorFactory other) {
            Objects.requireNonNull(other, "other is null");
            this.operatorId = other.operatorId;
            this.planNodeId = other.planNodeId;
            this.joinBridgeManager = other.joinBridgeManager;
            this.closed = false;
            this.joinBridgeManager.incrementProbeFactoryCount();
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            NestedLoopJoinBridge nestedLoopJoinBridge = this.joinBridgeManager.getJoinBridge(driverContext.getLifespan());
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, NestedLoopJoinOperator.class.getSimpleName());
            this.joinBridgeManager.probeOperatorCreated(driverContext.getLifespan());
            return new NestedLoopJoinOperator(operatorContext, nestedLoopJoinBridge, () -> this.joinBridgeManager.probeOperatorClosed(driverContext.getLifespan()));
        }

        @Override
        public void noMoreOperators() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.joinBridgeManager.probeOperatorFactoryClosedForAllLifespans();
        }

        @Override
        public void noMoreOperators(Lifespan lifespan) {
            this.joinBridgeManager.probeOperatorFactoryClosed(lifespan);
        }

        @Override
        public OperatorFactory duplicate() {
            return new NestedLoopJoinOperatorFactory(this);
        }
    }
}

