/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.Unnester;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public class MapUnnester
implements Unnester {
    private final Type keyType;
    private final Type valueType;
    private Block block;
    private int position;
    private int positionCount;

    public MapUnnester(Type keyType, Type valueType) {
        this.keyType = Objects.requireNonNull(keyType, "keyType is null");
        this.valueType = Objects.requireNonNull(valueType, "valueType is null");
    }

    @Override
    public boolean hasNext() {
        return this.position < this.positionCount;
    }

    @Override
    public final int getChannelCount() {
        return 2;
    }

    @Override
    public final void appendNext(PageBuilder pageBuilder, int outputChannelOffset) {
        Preconditions.checkState((this.block != null ? 1 : 0) != 0, (Object)"block is null");
        BlockBuilder keyBlockBuilder = pageBuilder.getBlockBuilder(outputChannelOffset);
        BlockBuilder valueBlockBuilder = pageBuilder.getBlockBuilder(outputChannelOffset + 1);
        this.keyType.appendTo(this.block, this.position++, keyBlockBuilder);
        this.valueType.appendTo(this.block, this.position++, valueBlockBuilder);
    }

    @Override
    public void setBlock(@Nullable Block mapBlock) {
        this.block = mapBlock;
        this.position = 0;
        this.positionCount = mapBlock == null ? 0 : mapBlock.getPositionCount();
    }
}

