/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.Unnester;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.ColumnarRow;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ArrayOfRowsUnnester
implements Unnester {
    private final List<Type> fieldTypes;
    private ColumnarRow columnarRow;
    private int position;
    private int nonNullPosition;
    private int positionCount;

    public ArrayOfRowsUnnester(Type elementType) {
        Objects.requireNonNull(elementType, "elementType is null");
        Preconditions.checkArgument((boolean)(elementType instanceof RowType), (Object)"elementType is not of RowType");
        this.fieldTypes = ImmutableList.copyOf((Collection)elementType.getTypeParameters());
    }

    @Override
    public int getChannelCount() {
        return this.fieldTypes.size();
    }

    @Override
    public void appendNext(PageBuilder pageBuilder, int outputChannelOffset) {
        Preconditions.checkState((this.columnarRow != null ? 1 : 0) != 0, (Object)"columnarRow is null");
        for (int i = 0; i < this.fieldTypes.size(); ++i) {
            BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(outputChannelOffset + i);
            if (this.columnarRow.isNull(this.position)) {
                blockBuilder.appendNull();
                continue;
            }
            this.fieldTypes.get(i).appendTo(this.columnarRow.getField(i), this.nonNullPosition, blockBuilder);
        }
        if (!this.columnarRow.isNull(this.position)) {
            ++this.nonNullPosition;
        }
        ++this.position;
    }

    @Override
    public boolean hasNext() {
        return this.position < this.positionCount;
    }

    @Override
    public void setBlock(Block block) {
        this.position = 0;
        this.nonNullPosition = 0;
        if (block == null) {
            this.columnarRow = null;
            this.positionCount = 0;
        } else {
            this.columnarRow = ColumnarRow.toColumnarRow((Block)block);
            this.positionCount = block.getPositionCount();
        }
    }
}

