/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.spi.CatalogSchemaName;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.Signature;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class StaticFunctionHandle
implements FunctionHandle {
    private static final CatalogSchemaName STATIC_FUNCTION_NAMESPACE_CATALOG_SCHEMA_NAME = new CatalogSchemaName("static", "system");
    private final Signature signature;

    @JsonCreator
    public StaticFunctionHandle(@JsonProperty(value="signature") Signature signature) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        StaticFunctionHandle.checkArgument(signature.getTypeVariableConstraints().isEmpty(), "%s has unbound type parameters", signature);
    }

    @JsonProperty
    public Signature getSignature() {
        return this.signature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StaticFunctionHandle that = (StaticFunctionHandle)o;
        return Objects.equals(this.signature, that.signature);
    }

    public CatalogSchemaName getCatalogSchemaName() {
        return STATIC_FUNCTION_NAMESPACE_CATALOG_SCHEMA_NAME;
    }

    public int hashCode() {
        return Objects.hash(this.signature);
    }

    public String toString() {
        return this.signature.toString();
    }

    private static void checkArgument(boolean condition, String message, Object ... args) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }
}

