/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.spi.function.OperatorType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;

public final class OperatorSignatureUtils {
    private static final String OPERATOR_PREFIX = "$operator$";

    private OperatorSignatureUtils() {
    }

    public static String mangleOperatorName(OperatorType operatorType) {
        return OperatorSignatureUtils.mangleOperatorName(operatorType.name());
    }

    public static String mangleOperatorName(String operatorName) {
        return OPERATOR_PREFIX + operatorName;
    }

    @VisibleForTesting
    public static OperatorType unmangleOperator(String mangledName) {
        Preconditions.checkArgument((boolean)mangledName.startsWith(OPERATOR_PREFIX), (String)"%s is not a mangled operator name", (Object)mangledName);
        return OperatorType.valueOf((String)mangledName.substring(OPERATOR_PREFIX.length()));
    }
}

