/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler.group;

import com.facebook.presto.execution.scheduler.BucketNodeMap;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.Split;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ToIntFunction;

public class DynamicBucketNodeMap
extends BucketNodeMap {
    private final int bucketCount;
    private final Int2ObjectMap<InternalNode> bucketToNode = new Int2ObjectOpenHashMap();

    public DynamicBucketNodeMap(ToIntFunction<Split> splitToBucket, int bucketCount) {
        super(splitToBucket);
        Preconditions.checkArgument((bucketCount > 0 ? 1 : 0) != 0, (Object)"bucketCount must be positive");
        this.bucketCount = bucketCount;
    }

    @Override
    public Optional<InternalNode> getAssignedNode(int bucketedId) {
        return Optional.ofNullable(this.bucketToNode.get(bucketedId));
    }

    @Override
    public int getBucketCount() {
        return this.bucketCount;
    }

    @Override
    public void assignBucketToNode(int bucketedId, InternalNode node) {
        Preconditions.checkArgument((bucketedId >= 0 && bucketedId < this.bucketCount ? 1 : 0) != 0);
        Objects.requireNonNull(node, "node is null");
        Preconditions.checkState((!this.bucketToNode.containsKey(bucketedId) ? 1 : 0) != 0, (Object)"bucket already assigned");
        this.bucketToNode.put(bucketedId, (Object)node);
    }

    @Override
    public boolean isDynamic() {
        return true;
    }
}

