/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.BasicStageStats;
import com.facebook.presto.execution.StageState;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.spi.eventlistener.StageGcStatistics;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.stats.Distribution;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;

@Immutable
public class StageStats {
    private final DateTime schedulingComplete;
    private final Distribution.DistributionSnapshot getSplitDistribution;
    private final int totalTasks;
    private final int runningTasks;
    private final int completedTasks;
    private final int totalDrivers;
    private final int queuedDrivers;
    private final int runningDrivers;
    private final int blockedDrivers;
    private final int completedDrivers;
    private final double cumulativeUserMemory;
    private final DataSize userMemoryReservation;
    private final DataSize totalMemoryReservation;
    private final DataSize peakUserMemoryReservation;
    private final Duration totalScheduledTime;
    private final Duration totalCpuTime;
    private final Duration totalBlockedTime;
    private final boolean fullyBlocked;
    private final Set<BlockedReason> blockedReasons;
    private final DataSize rawInputDataSize;
    private final long rawInputPositions;
    private final DataSize processedInputDataSize;
    private final long processedInputPositions;
    private final DataSize bufferedDataSize;
    private final DataSize outputDataSize;
    private final long outputPositions;
    private final DataSize physicalWrittenDataSize;
    private final StageGcStatistics gcInfo;
    private final List<OperatorStats> operatorSummaries;

    @JsonCreator
    public StageStats(@JsonProperty(value="schedulingComplete") DateTime schedulingComplete, @JsonProperty(value="getSplitDistribution") Distribution.DistributionSnapshot getSplitDistribution, @JsonProperty(value="totalTasks") int totalTasks, @JsonProperty(value="runningTasks") int runningTasks, @JsonProperty(value="completedTasks") int completedTasks, @JsonProperty(value="totalDrivers") int totalDrivers, @JsonProperty(value="queuedDrivers") int queuedDrivers, @JsonProperty(value="runningDrivers") int runningDrivers, @JsonProperty(value="blockedDrivers") int blockedDrivers, @JsonProperty(value="completedDrivers") int completedDrivers, @JsonProperty(value="cumulativeUserMemory") double cumulativeUserMemory, @JsonProperty(value="userMemoryReservation") DataSize userMemoryReservation, @JsonProperty(value="totalMemoryReservation") DataSize totalMemoryReservation, @JsonProperty(value="peakUserMemoryReservation") DataSize peakUserMemoryReservation, @JsonProperty(value="totalScheduledTime") Duration totalScheduledTime, @JsonProperty(value="totalCpuTime") Duration totalCpuTime, @JsonProperty(value="totalBlockedTime") Duration totalBlockedTime, @JsonProperty(value="fullyBlocked") boolean fullyBlocked, @JsonProperty(value="blockedReasons") Set<BlockedReason> blockedReasons, @JsonProperty(value="rawInputDataSize") DataSize rawInputDataSize, @JsonProperty(value="rawInputPositions") long rawInputPositions, @JsonProperty(value="processedInputDataSize") DataSize processedInputDataSize, @JsonProperty(value="processedInputPositions") long processedInputPositions, @JsonProperty(value="bufferedDataSize") DataSize bufferedDataSize, @JsonProperty(value="outputDataSize") DataSize outputDataSize, @JsonProperty(value="outputPositions") long outputPositions, @JsonProperty(value="physicalWrittenDataSize") DataSize physicalWrittenDataSize, @JsonProperty(value="gcInfo") StageGcStatistics gcInfo, @JsonProperty(value="operatorSummaries") List<OperatorStats> operatorSummaries) {
        this.schedulingComplete = schedulingComplete;
        this.getSplitDistribution = Objects.requireNonNull(getSplitDistribution, "getSplitDistribution is null");
        Preconditions.checkArgument((totalTasks >= 0 ? 1 : 0) != 0, (Object)"totalTasks is negative");
        this.totalTasks = totalTasks;
        Preconditions.checkArgument((runningTasks >= 0 ? 1 : 0) != 0, (Object)"runningTasks is negative");
        this.runningTasks = runningTasks;
        Preconditions.checkArgument((completedTasks >= 0 ? 1 : 0) != 0, (Object)"completedTasks is negative");
        this.completedTasks = completedTasks;
        Preconditions.checkArgument((totalDrivers >= 0 ? 1 : 0) != 0, (Object)"totalDrivers is negative");
        this.totalDrivers = totalDrivers;
        Preconditions.checkArgument((queuedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedDrivers is negative");
        this.queuedDrivers = queuedDrivers;
        Preconditions.checkArgument((runningDrivers >= 0 ? 1 : 0) != 0, (Object)"runningDrivers is negative");
        this.runningDrivers = runningDrivers;
        Preconditions.checkArgument((blockedDrivers >= 0 ? 1 : 0) != 0, (Object)"blockedDrivers is negative");
        this.blockedDrivers = blockedDrivers;
        Preconditions.checkArgument((completedDrivers >= 0 ? 1 : 0) != 0, (Object)"completedDrivers is negative");
        this.completedDrivers = completedDrivers;
        Preconditions.checkArgument((cumulativeUserMemory >= 0.0 ? 1 : 0) != 0, (Object)"cumulativeUserMemory is negative");
        this.cumulativeUserMemory = cumulativeUserMemory;
        this.userMemoryReservation = Objects.requireNonNull(userMemoryReservation, "userMemoryReservation is null");
        this.totalMemoryReservation = Objects.requireNonNull(totalMemoryReservation, "totalMemoryReservation is null");
        this.peakUserMemoryReservation = Objects.requireNonNull(peakUserMemoryReservation, "peakUserMemoryReservation is null");
        this.totalScheduledTime = Objects.requireNonNull(totalScheduledTime, "totalScheduledTime is null");
        this.totalCpuTime = Objects.requireNonNull(totalCpuTime, "totalCpuTime is null");
        this.totalBlockedTime = Objects.requireNonNull(totalBlockedTime, "totalBlockedTime is null");
        this.fullyBlocked = fullyBlocked;
        this.blockedReasons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(blockedReasons, "blockedReasons is null"));
        this.rawInputDataSize = Objects.requireNonNull(rawInputDataSize, "rawInputDataSize is null");
        Preconditions.checkArgument((rawInputPositions >= 0L ? 1 : 0) != 0, (Object)"rawInputPositions is negative");
        this.rawInputPositions = rawInputPositions;
        this.processedInputDataSize = Objects.requireNonNull(processedInputDataSize, "processedInputDataSize is null");
        Preconditions.checkArgument((processedInputPositions >= 0L ? 1 : 0) != 0, (Object)"processedInputPositions is negative");
        this.processedInputPositions = processedInputPositions;
        this.bufferedDataSize = Objects.requireNonNull(bufferedDataSize, "bufferedDataSize is null");
        this.outputDataSize = Objects.requireNonNull(outputDataSize, "outputDataSize is null");
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
        this.physicalWrittenDataSize = Objects.requireNonNull(physicalWrittenDataSize, "writtenDataSize is null");
        this.gcInfo = Objects.requireNonNull(gcInfo, "gcInfo is null");
        this.operatorSummaries = ImmutableList.copyOf((Collection)Objects.requireNonNull(operatorSummaries, "operatorSummaries is null"));
    }

    @JsonProperty
    public DateTime getSchedulingComplete() {
        return this.schedulingComplete;
    }

    @JsonProperty
    public Distribution.DistributionSnapshot getGetSplitDistribution() {
        return this.getSplitDistribution;
    }

    @JsonProperty
    public int getTotalTasks() {
        return this.totalTasks;
    }

    @JsonProperty
    public int getRunningTasks() {
        return this.runningTasks;
    }

    @JsonProperty
    public int getCompletedTasks() {
        return this.completedTasks;
    }

    @JsonProperty
    public int getTotalDrivers() {
        return this.totalDrivers;
    }

    @JsonProperty
    public int getQueuedDrivers() {
        return this.queuedDrivers;
    }

    @JsonProperty
    public int getRunningDrivers() {
        return this.runningDrivers;
    }

    @JsonProperty
    public int getBlockedDrivers() {
        return this.blockedDrivers;
    }

    @JsonProperty
    public int getCompletedDrivers() {
        return this.completedDrivers;
    }

    @JsonProperty
    public double getCumulativeUserMemory() {
        return this.cumulativeUserMemory;
    }

    @JsonProperty
    public DataSize getUserMemoryReservation() {
        return this.userMemoryReservation;
    }

    @JsonProperty
    public DataSize getTotalMemoryReservation() {
        return this.totalMemoryReservation;
    }

    @JsonProperty
    public DataSize getPeakUserMemoryReservation() {
        return this.peakUserMemoryReservation;
    }

    @JsonProperty
    public Duration getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    @JsonProperty
    public Duration getTotalCpuTime() {
        return this.totalCpuTime;
    }

    @JsonProperty
    public Duration getTotalBlockedTime() {
        return this.totalBlockedTime;
    }

    @JsonProperty
    public boolean isFullyBlocked() {
        return this.fullyBlocked;
    }

    @JsonProperty
    public Set<BlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    @JsonProperty
    public DataSize getRawInputDataSize() {
        return this.rawInputDataSize;
    }

    @JsonProperty
    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    @JsonProperty
    public DataSize getProcessedInputDataSize() {
        return this.processedInputDataSize;
    }

    @JsonProperty
    public long getProcessedInputPositions() {
        return this.processedInputPositions;
    }

    @JsonProperty
    public DataSize getBufferedDataSize() {
        return this.bufferedDataSize;
    }

    @JsonProperty
    public DataSize getOutputDataSize() {
        return this.outputDataSize;
    }

    @JsonProperty
    public long getOutputPositions() {
        return this.outputPositions;
    }

    @JsonProperty
    public DataSize getPhysicalWrittenDataSize() {
        return this.physicalWrittenDataSize;
    }

    @JsonProperty
    public StageGcStatistics getGcInfo() {
        return this.gcInfo;
    }

    @JsonProperty
    public List<OperatorStats> getOperatorSummaries() {
        return this.operatorSummaries;
    }

    public BasicStageStats toBasicStageStats(StageState stageState) {
        boolean isScheduled = stageState == StageState.RUNNING || stageState.isDone();
        OptionalDouble progressPercentage = OptionalDouble.empty();
        if (isScheduled && this.totalDrivers != 0) {
            progressPercentage = OptionalDouble.of(Math.min(100.0, (double)this.completedDrivers * 100.0 / (double)this.totalDrivers));
        }
        return new BasicStageStats(isScheduled, this.totalDrivers, this.queuedDrivers, this.runningDrivers, this.completedDrivers, this.rawInputDataSize, this.rawInputPositions, (long)this.cumulativeUserMemory, this.userMemoryReservation, this.totalMemoryReservation, this.totalCpuTime, this.totalScheduledTime, this.fullyBlocked, this.blockedReasons, progressPercentage);
    }
}

