/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.event.SplitMonitor;
import com.facebook.presto.execution.SqlTaskExecution;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.executor.TaskExecutor;
import com.facebook.presto.memory.QueryContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.TaskExchangeClientManager;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.TypeProvider;
import com.google.common.base.Throwables;
import io.airlift.concurrent.SetThreadName;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.Executor;

public class SqlTaskExecutionFactory {
    private final Executor taskNotificationExecutor;
    private final TaskExecutor taskExecutor;
    private final LocalExecutionPlanner planner;
    private final SplitMonitor splitMonitor;
    private final boolean perOperatorCpuTimerEnabled;
    private final boolean cpuTimerEnabled;
    private final boolean legacyLifespanCompletionCondition;

    public SqlTaskExecutionFactory(Executor taskNotificationExecutor, TaskExecutor taskExecutor, LocalExecutionPlanner planner, SplitMonitor splitMonitor, TaskManagerConfig config) {
        this.taskNotificationExecutor = Objects.requireNonNull(taskNotificationExecutor, "taskNotificationExecutor is null");
        this.taskExecutor = Objects.requireNonNull(taskExecutor, "taskExecutor is null");
        this.planner = Objects.requireNonNull(planner, "planner is null");
        this.splitMonitor = Objects.requireNonNull(splitMonitor, "splitMonitor is null");
        Objects.requireNonNull(config, "config is null");
        this.perOperatorCpuTimerEnabled = config.isPerOperatorCpuTimerEnabled();
        this.cpuTimerEnabled = config.isTaskCpuTimerEnabled();
        this.legacyLifespanCompletionCondition = config.isLegacyLifespanCompletionCondition();
    }

    public SqlTaskExecution create(Session session, QueryContext queryContext, TaskStateMachine taskStateMachine, OutputBuffer outputBuffer, TaskExchangeClientManager taskExchangeClientManager, PlanFragment fragment, List<TaskSource> sources, OptionalInt totalPartitions) {
        LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan;
        TaskContext taskContext = queryContext.addTaskContext(taskStateMachine, session, this.perOperatorCpuTimerEnabled, this.cpuTimerEnabled, totalPartitions, this.legacyLifespanCompletionCondition);
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{taskStateMachine.getTaskId()});){
            try {
                localExecutionPlan = this.planner.plan(taskContext, fragment.getRoot(), TypeProvider.copyOf(fragment.getSymbols()), fragment.getPartitioningScheme(), fragment.getStageExecutionDescriptor(), fragment.getPartitionedSources(), outputBuffer, taskExchangeClientManager);
            }
            catch (Throwable e) {
                taskStateMachine.failed(e);
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return SqlTaskExecution.createSqlTaskExecution(taskStateMachine, taskContext, outputBuffer, sources, localExecutionPlan, this.taskExecutor, this.taskNotificationExecutor, this.splitMonitor);
    }
}

