/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.google.common.base.Ticker;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.joda.time.DateTime;

class QueryStateTimer {
    private final Ticker ticker;
    private final DateTime createTime = DateTime.now();
    private final long createNanos;
    private final AtomicReference<Long> beginResourceWaitingNanos = new AtomicReference();
    private final AtomicReference<Long> beginPlanningNanos = new AtomicReference();
    private final AtomicReference<Long> beginFinishingNanos = new AtomicReference();
    private final AtomicReference<Long> endNanos = new AtomicReference();
    private final AtomicReference<Duration> queuedTime = new AtomicReference();
    private final AtomicReference<Duration> resourceWaitingTime = new AtomicReference();
    private final AtomicReference<Duration> executionTime = new AtomicReference();
    private final AtomicReference<Duration> planningTime = new AtomicReference();
    private final AtomicReference<Duration> finishingTime = new AtomicReference();
    private final AtomicReference<Long> beginAnalysisNanos = new AtomicReference();
    private final AtomicReference<Duration> analysisTime = new AtomicReference();
    private final AtomicReference<Long> lastHeartbeatNanos;

    public QueryStateTimer(Ticker ticker) {
        this.ticker = Objects.requireNonNull(ticker, "ticker is null");
        this.createNanos = this.tickerNanos();
        this.lastHeartbeatNanos = new AtomicReference<Long>(this.createNanos);
    }

    public void beginWaitingForResources() {
        this.beginWaitingForResources(this.tickerNanos());
    }

    private void beginWaitingForResources(long now) {
        this.queuedTime.compareAndSet(null, QueryStateTimer.nanosSince(this.createNanos, now));
        this.beginResourceWaitingNanos.compareAndSet(null, now);
    }

    public void beginPlanning() {
        this.beginPlanning(this.tickerNanos());
    }

    private void beginPlanning(long now) {
        this.beginWaitingForResources(now);
        this.resourceWaitingTime.compareAndSet(null, QueryStateTimer.nanosSince(this.beginResourceWaitingNanos, now));
        this.beginPlanningNanos.compareAndSet(null, now);
    }

    public void beginStarting() {
        this.beginStarting(this.tickerNanos());
    }

    private void beginStarting(long now) {
        this.beginPlanning(now);
        this.planningTime.compareAndSet(null, QueryStateTimer.nanosSince(this.beginPlanningNanos, now));
    }

    public void beginRunning() {
        this.beginRunning(this.tickerNanos());
    }

    private void beginRunning(long now) {
        this.beginStarting(now);
    }

    public void beginFinishing() {
        this.beginFinishing(this.tickerNanos());
    }

    private void beginFinishing(long now) {
        this.beginRunning(now);
        this.beginFinishingNanos.compareAndSet(null, now);
    }

    public void endQuery() {
        this.endQuery(this.tickerNanos());
    }

    private void endQuery(long now) {
        this.beginFinishing(now);
        this.finishingTime.compareAndSet(null, QueryStateTimer.nanosSince(this.beginFinishingNanos, now));
        this.executionTime.compareAndSet(null, QueryStateTimer.nanosSince(this.beginPlanningNanos, now));
        this.endNanos.compareAndSet(null, now);
    }

    public void beginAnalyzing() {
        this.beginAnalysisNanos.compareAndSet(null, this.tickerNanos());
    }

    public void endAnalysis() {
        this.analysisTime.compareAndSet(null, QueryStateTimer.nanosSince(this.beginAnalysisNanos, this.tickerNanos()));
    }

    public void recordHeartbeat() {
        this.lastHeartbeatNanos.set(this.tickerNanos());
    }

    public DateTime getCreateTime() {
        return this.createTime;
    }

    public Optional<DateTime> getExecutionStartTime() {
        return this.toDateTime(this.beginPlanningNanos);
    }

    public Duration getElapsedTime() {
        if (this.endNanos.get() != null) {
            return Duration.succinctNanos((long)(this.endNanos.get() - this.createNanos));
        }
        return QueryStateTimer.nanosSince(this.createNanos, this.tickerNanos());
    }

    public Duration getQueuedTime() {
        Duration queuedTime = this.queuedTime.get();
        if (queuedTime != null) {
            return queuedTime;
        }
        return this.getElapsedTime();
    }

    public Duration getResourceWaitingTime() {
        return this.getDuration(this.resourceWaitingTime, this.beginResourceWaitingNanos);
    }

    public Duration getPlanningTime() {
        return this.getDuration(this.planningTime, this.beginPlanningNanos);
    }

    public Duration getFinishingTime() {
        return this.getDuration(this.finishingTime, this.beginFinishingNanos);
    }

    public Duration getExecutionTime() {
        return this.getDuration(this.executionTime, this.beginPlanningNanos);
    }

    public Optional<DateTime> getEndTime() {
        return this.toDateTime(this.endNanos);
    }

    public Duration getAnalysisTime() {
        return this.getDuration(this.analysisTime, this.beginAnalysisNanos);
    }

    public DateTime getLastHeartbeat() {
        return this.toDateTime(this.lastHeartbeatNanos.get());
    }

    private long tickerNanos() {
        return this.ticker.read();
    }

    private static Duration nanosSince(AtomicReference<Long> start, long end) {
        Long startNanos = start.get();
        if (startNanos == null) {
            throw new IllegalStateException("Start time not set");
        }
        return QueryStateTimer.nanosSince(startNanos, end);
    }

    private static Duration nanosSince(long start, long now) {
        return Duration.succinctNanos((long)(now - start));
    }

    private Duration getDuration(AtomicReference<Duration> finalDuration, AtomicReference<Long> start) {
        Duration duration = finalDuration.get();
        if (duration != null) {
            return duration;
        }
        Long startNanos = start.get();
        if (startNanos != null) {
            return QueryStateTimer.nanosSince(startNanos, this.tickerNanos());
        }
        return new Duration(0.0, TimeUnit.MILLISECONDS);
    }

    private Optional<DateTime> toDateTime(AtomicReference<Long> instantNanos) {
        Long nanos = instantNanos.get();
        if (nanos == null) {
            return Optional.empty();
        }
        return Optional.of(this.toDateTime(nanos));
    }

    private DateTime toDateTime(long instantNanos) {
        long millisSinceCreate = TimeUnit.NANOSECONDS.toMillis(instantNanos - this.createNanos);
        return new DateTime(this.createTime.getMillis() + millisSinceCreate);
    }
}

