/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Grant;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class GrantTask
implements DataDefinitionTask<Grant> {
    @Override
    public String getName() {
        return "GRANT";
    }

    @Override
    public ListenableFuture<?> execute(Grant statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        QualifiedObjectName tableName;
        Session session = stateMachine.getSession();
        Optional<TableHandle> tableHandle = metadata.getTableHandle(session, tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTableName()));
        if (!tableHandle.isPresent()) {
            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "Table '%s' does not exist", tableName);
        }
        Set<Object> privileges = statement.getPrivileges().isPresent() ? (Set)((List)statement.getPrivileges().get()).stream().map(privilege -> GrantTask.parsePrivilege(statement, privilege)).collect(ImmutableSet.toImmutableSet()) : EnumSet.allOf(Privilege.class);
        for (Privilege privilege2 : privileges) {
            accessControl.checkCanGrantTablePrivilege(session.getRequiredTransactionId(), session.getIdentity(), privilege2, tableName, MetadataUtil.createPrincipal(statement.getGrantee()), statement.isWithGrantOption());
        }
        metadata.grantTablePrivileges(session, tableName, privileges, MetadataUtil.createPrincipal(statement.getGrantee()), statement.isWithGrantOption());
        return Futures.immediateFuture(null);
    }

    private static Privilege parsePrivilege(Grant statement, String privilegeString) {
        for (Privilege privilege : Privilege.values()) {
            if (!privilege.name().equalsIgnoreCase(privilegeString)) continue;
            return privilege;
        }
        throw new SemanticException(SemanticErrorCode.INVALID_PRIVILEGE, (Node)statement, "Unknown privilege: '%s'", privilegeString);
    }
}

