/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import io.airlift.units.DataSize;

public class ExceededSpillLimitException
extends PrestoException {
    public static ExceededSpillLimitException exceededLocalLimit(DataSize maxSpill) {
        return new ExceededSpillLimitException(String.format("Query exceeded local spill limit of %s", maxSpill));
    }

    public static ExceededSpillLimitException exceededPerQueryLocalLimit(DataSize maxSpill) {
        return new ExceededSpillLimitException(String.format("Query exceeded per-query local spill limit of %s", maxSpill));
    }

    private ExceededSpillLimitException(String message) {
        super((ErrorCodeSupplier)StandardErrorCode.EXCEEDED_SPILL_LIMIT, message);
    }
}

