/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational.optimizer;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.type.JsonType;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;

public class ExpressionOptimizer {
    private final FunctionManager functionManager;
    private final ConnectorSession session;

    public ExpressionOptimizer(FunctionManager functionManager, Session session) {
        this.functionManager = functionManager;
        this.session = session.toConnectorSession();
    }

    public RowExpression optimize(RowExpression expression) {
        return (RowExpression)expression.accept((RowExpressionVisitor)new Visitor(), null);
    }

    private class Visitor
    implements RowExpressionVisitor<RowExpression, Void> {
        private Visitor() {
        }

        public RowExpression visitInputReference(InputReferenceExpression reference, Void context) {
            return reference;
        }

        public RowExpression visitConstant(ConstantExpression literal, Void context) {
            return literal;
        }

        public RowExpression visitCall(CallExpression call, Void context) {
            List arguments;
            FunctionHandle functionHandle;
            block8: {
                functionHandle = call.getFunctionHandle();
                if (functionHandle.getSignature().getName().equals("TRY_CAST")) {
                    List arguments2 = (List)call.getArguments().stream().map(argument -> (RowExpression)argument.accept((RowExpressionVisitor)this, null)).collect(ImmutableList.toImmutableList());
                    return Expressions.call(functionHandle, call.getType(), arguments2);
                }
                if (functionHandle.getSignature().getName().equals(CastType.CAST.getCastName())) {
                    call = this.rewriteCast(call);
                    functionHandle = call.getFunctionHandle();
                }
                ScalarFunctionImplementation function = ExpressionOptimizer.this.functionManager.getScalarFunctionImplementation(functionHandle);
                arguments = (List)call.getArguments().stream().map(argument -> (RowExpression)argument.accept((RowExpressionVisitor)this, (Object)context)).collect(ImmutableList.toImmutableList());
                if (Iterables.all((Iterable)arguments, (Predicate)Predicates.instanceOf(ConstantExpression.class)) && function.isDeterministic()) {
                    MethodHandle method = function.getMethodHandle();
                    if (method.type().parameterCount() > 0 && method.type().parameterType(0) == ConnectorSession.class) {
                        method = method.bindTo(ExpressionOptimizer.this.session);
                    }
                    int index = 0;
                    ArrayList<Object> constantArguments = new ArrayList<Object>();
                    for (RowExpression argument2 : arguments) {
                        Object value = ((ConstantExpression)argument2).getValue();
                        if (value == null && function.getArgumentProperty(index).getNullConvention() == ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL) {
                            return Expressions.constantNull(call.getType());
                        }
                        constantArguments.add(value);
                        ++index;
                    }
                    try {
                        return Expressions.constant(method.invokeWithArguments(constantArguments), call.getType());
                    }
                    catch (Throwable e) {
                        if (!(e instanceof InterruptedException)) break block8;
                        Thread.currentThread().interrupt();
                    }
                }
            }
            return Expressions.call(functionHandle, call.getType(), arguments);
        }

        public RowExpression visitLambda(LambdaDefinitionExpression lambda, Void context) {
            return new LambdaDefinitionExpression(lambda.getArgumentTypes(), lambda.getArguments(), (RowExpression)lambda.getBody().accept((RowExpressionVisitor)this, (Object)context));
        }

        public RowExpression visitVariableReference(VariableReferenceExpression reference, Void context) {
            return reference;
        }

        public RowExpression visitSpecialForm(SpecialFormExpression specialForm, Void context) {
            SpecialFormExpression.Form form = specialForm.getForm();
            switch (form) {
                case IF: {
                    Preconditions.checkState((specialForm.getArguments().size() == 3 ? 1 : 0) != 0, (Object)("IF function should have 3 arguments. Get " + specialForm.getArguments().size()));
                    RowExpression optimizedOperand = (RowExpression)((RowExpression)specialForm.getArguments().get(0)).accept((RowExpressionVisitor)this, (Object)context);
                    if (optimizedOperand instanceof ConstantExpression) {
                        ConstantExpression constantOperand = (ConstantExpression)optimizedOperand;
                        Preconditions.checkState((boolean)constantOperand.getType().equals(BooleanType.BOOLEAN), (Object)("Operand of IF function should be BOOLEAN type. Get type " + constantOperand.getType().getDisplayName()));
                        if (Boolean.TRUE.equals(constantOperand.getValue())) {
                            return (RowExpression)((RowExpression)specialForm.getArguments().get(1)).accept((RowExpressionVisitor)this, (Object)context);
                        }
                        return (RowExpression)((RowExpression)specialForm.getArguments().get(2)).accept((RowExpressionVisitor)this, (Object)context);
                    }
                    List arguments = (List)specialForm.getArguments().stream().map(argument -> (RowExpression)argument.accept((RowExpressionVisitor)this, null)).collect(ImmutableList.toImmutableList());
                    return new SpecialFormExpression(form, specialForm.getType(), arguments);
                }
                case BIND: {
                    Preconditions.checkState((specialForm.getArguments().size() >= 1 ? 1 : 0) != 0, (Object)(SpecialFormExpression.Form.BIND.name() + " function should have at least 1 argument. Got " + specialForm.getArguments().size()));
                    boolean allConstantExpression = true;
                    ImmutableList.Builder optimizedArgumentsBuilder = ImmutableList.builder();
                    for (RowExpression argument2 : specialForm.getArguments()) {
                        RowExpression optimizedArgument = (RowExpression)argument2.accept((RowExpressionVisitor)this, (Object)context);
                        if (!(optimizedArgument instanceof ConstantExpression)) {
                            allConstantExpression = false;
                        }
                        optimizedArgumentsBuilder.add((Object)optimizedArgument);
                    }
                    if (allConstantExpression) {
                        throw new UnsupportedOperationException();
                    }
                    return new SpecialFormExpression(form, specialForm.getType(), (List)optimizedArgumentsBuilder.build());
                }
                case NULL_IF: 
                case SWITCH: 
                case WHEN: 
                case IS_NULL: 
                case COALESCE: 
                case AND: 
                case OR: 
                case IN: 
                case DEREFERENCE: 
                case ROW_CONSTRUCTOR: {
                    List arguments = (List)specialForm.getArguments().stream().map(argument -> (RowExpression)argument.accept((RowExpressionVisitor)this, null)).collect(ImmutableList.toImmutableList());
                    return new SpecialFormExpression(form, specialForm.getType(), arguments);
                }
            }
            throw new IllegalArgumentException("Unsupported special form " + specialForm.getForm());
        }

        private CallExpression rewriteCast(CallExpression call) {
            CallExpression innerCall;
            if (call.getArguments().get(0) instanceof CallExpression && (innerCall = (CallExpression)call.getArguments().get(0)).getFunctionHandle().getSignature().getName().equals("json_parse")) {
                Preconditions.checkArgument((boolean)innerCall.getType().equals((Object)JsonType.JSON));
                Preconditions.checkArgument((innerCall.getArguments().size() == 1 ? 1 : 0) != 0);
                TypeSignature returnType = call.getFunctionHandle().getSignature().getReturnType();
                if (returnType.getBase().equals("array")) {
                    return Expressions.call(ExpressionOptimizer.this.functionManager.lookupCast(CastType.JSON_TO_ARRAY_CAST, TypeSignature.parseTypeSignature((String)"varchar"), returnType), call.getType(), innerCall.getArguments());
                }
                if (returnType.getBase().equals("map")) {
                    return Expressions.call(ExpressionOptimizer.this.functionManager.lookupCast(CastType.JSON_TO_MAP_CAST, TypeSignature.parseTypeSignature((String)"varchar"), returnType), call.getType(), innerCall.getArguments());
                }
                if (returnType.getBase().equals("row")) {
                    return Expressions.call(ExpressionOptimizer.this.functionManager.lookupCast(CastType.JSON_TO_ROW_CAST, TypeSignature.parseTypeSignature((String)"varchar"), returnType), call.getType(), innerCall.getArguments());
                }
            }
            return Expressions.call(ExpressionOptimizer.this.functionManager.lookupCast(CastType.CAST, ((RowExpression)call.getArguments().get(0)).getType().getTypeSignature(), call.getType().getTypeSignature()), call.getType(), call.getArguments());
        }
    }
}

