/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.OperatorSignatureUtils;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.type.LikePatternType;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;

public final class StandardFunctionResolution {
    private final FunctionManager functionManager;

    public StandardFunctionResolution(FunctionManager functionManager) {
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
    }

    public FunctionHandle notFunction() {
        return this.functionManager.lookupFunction(QualifiedName.of((String)"not"), TypeSignatureProvider.fromTypes(new Type[]{BooleanType.BOOLEAN}));
    }

    public FunctionHandle likeVarcharFunction() {
        return this.functionManager.lookupFunction(QualifiedName.of((String)"LIKE"), TypeSignatureProvider.fromTypes(new Type[]{VarcharType.VARCHAR, LikePatternType.LIKE_PATTERN}));
    }

    public FunctionHandle likeCharFunction(Type valueType) {
        Preconditions.checkArgument((boolean)(valueType instanceof CharType), (Object)"Expected CHAR value type");
        return this.functionManager.lookupFunction(QualifiedName.of((String)"LIKE"), TypeSignatureProvider.fromTypes(new Type[]{valueType, LikePatternType.LIKE_PATTERN}));
    }

    public boolean isLikeFunction(FunctionHandle functionHandle) {
        return functionHandle.getSignature().getName().toUpperCase().equals("LIKE");
    }

    public FunctionHandle likePatternFunction() {
        return this.functionManager.lookupFunction(QualifiedName.of((String)"LIKE_PATTERN"), TypeSignatureProvider.fromTypes(new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR}));
    }

    public boolean isCastFunction(FunctionHandle functionHandle) {
        return functionHandle.getSignature().getName().equals(OperatorSignatureUtils.mangleOperatorName(OperatorType.CAST.name()));
    }

    public FunctionHandle arithmeticFunction(ArithmeticBinaryExpression.Operator operator, Type leftType, Type rightType) {
        OperatorType operatorType;
        switch (operator) {
            case ADD: {
                operatorType = OperatorType.ADD;
                break;
            }
            case SUBTRACT: {
                operatorType = OperatorType.SUBTRACT;
                break;
            }
            case MULTIPLY: {
                operatorType = OperatorType.MULTIPLY;
                break;
            }
            case DIVIDE: {
                operatorType = OperatorType.DIVIDE;
                break;
            }
            case MODULUS: {
                operatorType = OperatorType.MODULUS;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown arithmetic operator: " + operator);
            }
        }
        return this.functionManager.resolveOperator(operatorType, TypeSignatureProvider.fromTypes(leftType, rightType));
    }

    public FunctionHandle arrayConstructor(List<? extends Type> argumentTypes) {
        return this.functionManager.lookupFunction(QualifiedName.of((String)"ARRAY_CONSTRUCTOR"), TypeSignatureProvider.fromTypes(argumentTypes));
    }

    public FunctionHandle comparisonFunction(ComparisonExpression.Operator operator, Type leftType, Type rightType) {
        OperatorType operatorType;
        switch (operator) {
            case EQUAL: {
                operatorType = OperatorType.EQUAL;
                break;
            }
            case NOT_EQUAL: {
                operatorType = OperatorType.NOT_EQUAL;
                break;
            }
            case LESS_THAN: {
                operatorType = OperatorType.LESS_THAN;
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                operatorType = OperatorType.LESS_THAN_OR_EQUAL;
                break;
            }
            case GREATER_THAN: {
                operatorType = OperatorType.GREATER_THAN;
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                operatorType = OperatorType.GREATER_THAN_OR_EQUAL;
                break;
            }
            case IS_DISTINCT_FROM: {
                operatorType = OperatorType.IS_DISTINCT_FROM;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported comparison operator type: " + operator);
            }
        }
        return this.functionManager.resolveOperator(operatorType, TypeSignatureProvider.fromTypes(leftType, rightType));
    }

    public FunctionHandle tryFunction(Type returnType) {
        return this.functionManager.lookupFunction(QualifiedName.of((String)"TRY"), TypeSignatureProvider.fromTypes(returnType));
    }
}

