/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ProjectNode
extends PlanNode {
    private final PlanNode source;
    private final Assignments assignments;

    @JsonCreator
    public ProjectNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="assignments") Assignments assignments) {
        super(id);
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(assignments, "assignments is null");
        this.source = source;
        this.assignments = assignments;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.assignments.getOutputs();
    }

    @JsonProperty
    public Assignments getAssignments() {
        return this.assignments;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitProject(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new ProjectNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.assignments);
    }
}

