/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations.joins;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.relational.ProjectNodeUtils;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class JoinGraph {
    private final Optional<Map<Symbol, Expression>> assignments;
    private final List<Expression> filters;
    private final List<PlanNode> nodes;
    private final Multimap<PlanNodeId, Edge> edges;
    private final PlanNodeId rootId;

    public static List<JoinGraph> buildFrom(PlanNode plan) {
        return JoinGraph.buildFrom(plan, Lookup.noLookup());
    }

    public static JoinGraph buildShallowFrom(PlanNode plan, Lookup lookup) {
        JoinGraph graph = plan.accept(new Builder(true, lookup), new Context());
        return graph;
    }

    private static List<JoinGraph> buildFrom(PlanNode plan, Lookup lookup) {
        Context context = new Context();
        JoinGraph graph = plan.accept(new Builder(false, lookup), context);
        if (graph.size() > 1) {
            context.addSubGraph(graph);
        }
        return context.getGraphs();
    }

    public JoinGraph(PlanNode node) {
        this((List<PlanNode>)ImmutableList.of((Object)node), (Multimap<PlanNodeId, Edge>)ImmutableMultimap.of(), node.getId(), (List<Expression>)ImmutableList.of(), Optional.empty());
    }

    public JoinGraph(List<PlanNode> nodes, Multimap<PlanNodeId, Edge> edges, PlanNodeId rootId, List<Expression> filters, Optional<Map<Symbol, Expression>> assignments) {
        this.nodes = nodes;
        this.edges = edges;
        this.rootId = rootId;
        this.filters = filters;
        this.assignments = assignments;
    }

    public JoinGraph withAssignments(Map<Symbol, Expression> assignments) {
        return new JoinGraph(this.nodes, this.edges, this.rootId, this.filters, Optional.of(assignments));
    }

    public Optional<Map<Symbol, Expression>> getAssignments() {
        return this.assignments;
    }

    public JoinGraph withFilter(Expression expression) {
        ImmutableList.Builder filters = ImmutableList.builder();
        filters.addAll(this.filters);
        filters.add((Object)expression);
        return new JoinGraph(this.nodes, this.edges, this.rootId, (List<Expression>)filters.build(), this.assignments);
    }

    public List<Expression> getFilters() {
        return this.filters;
    }

    public PlanNodeId getRootId() {
        return this.rootId;
    }

    public JoinGraph withRootId(PlanNodeId rootId) {
        return new JoinGraph(this.nodes, this.edges, rootId, this.filters, this.assignments);
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public int size() {
        return this.nodes.size();
    }

    public PlanNode getNode(int index) {
        return this.nodes.get(index);
    }

    public List<PlanNode> getNodes() {
        return this.nodes;
    }

    public Collection<Edge> getEdges(PlanNode node) {
        return ImmutableList.copyOf((Collection)this.edges.get((Object)node.getId()));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (PlanNode nodeFrom : this.nodes) {
            builder.append(nodeFrom.getId()).append(" = ").append(nodeFrom.toString()).append("\n");
        }
        for (PlanNode nodeFrom : this.nodes) {
            builder.append(nodeFrom.getId()).append(":");
            for (Edge nodeTo : this.edges.get((Object)nodeFrom.getId())) {
                builder.append(" ").append(nodeTo.getTargetNode().getId());
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    private JoinGraph joinWith(JoinGraph other, List<JoinNode.EquiJoinClause> joinClauses, Context context, PlanNodeId newRoot) {
        for (PlanNode node : other.nodes) {
            Preconditions.checkState((!this.edges.containsKey((Object)node.getId()) ? 1 : 0) != 0, (Object)String.format("Node [%s] appeared in two JoinGraphs", node));
        }
        ImmutableList nodes = ImmutableList.builder().addAll(this.nodes).addAll(other.nodes).build();
        ImmutableMultimap.Builder edges = ImmutableMultimap.builder().putAll(this.edges).putAll(other.edges);
        ImmutableList joinedFilters = ImmutableList.builder().addAll(this.filters).addAll(other.filters).build();
        for (JoinNode.EquiJoinClause edge : joinClauses) {
            Symbol leftSymbol = edge.getLeft();
            Symbol rightSymbol = edge.getRight();
            Preconditions.checkState((boolean)context.containsSymbol(leftSymbol));
            Preconditions.checkState((boolean)context.containsSymbol(rightSymbol));
            PlanNode left = context.getSymbolSource(leftSymbol);
            PlanNode right = context.getSymbolSource(rightSymbol);
            edges.put((Object)left.getId(), (Object)new Edge(right, leftSymbol, rightSymbol));
            edges.put((Object)right.getId(), (Object)new Edge(left, rightSymbol, leftSymbol));
        }
        return new JoinGraph((List<PlanNode>)nodes, (Multimap<PlanNodeId, Edge>)edges.build(), newRoot, (List<Expression>)joinedFilters, Optional.empty());
    }

    private static class Context {
        private final Map<Symbol, PlanNode> symbolSources = new HashMap<Symbol, PlanNode>();
        private final List<JoinGraph> joinGraphs = new ArrayList<JoinGraph>();

        private Context() {
        }

        public void setSymbolSource(Symbol symbol, PlanNode node) {
            this.symbolSources.put(symbol, node);
        }

        public void addSubGraph(JoinGraph graph) {
            this.joinGraphs.add(graph);
        }

        public boolean containsSymbol(Symbol symbol) {
            return this.symbolSources.containsKey(symbol);
        }

        public PlanNode getSymbolSource(Symbol symbol) {
            Preconditions.checkState((boolean)this.containsSymbol(symbol));
            return this.symbolSources.get(symbol);
        }

        public List<JoinGraph> getGraphs() {
            return this.joinGraphs;
        }
    }

    public static class Edge {
        private final PlanNode targetNode;
        private final Symbol sourceSymbol;
        private final Symbol targetSymbol;

        public Edge(PlanNode targetNode, Symbol sourceSymbol, Symbol targetSymbol) {
            this.targetNode = Objects.requireNonNull(targetNode, "targetNode is null");
            this.sourceSymbol = Objects.requireNonNull(sourceSymbol, "sourceSymbol is null");
            this.targetSymbol = Objects.requireNonNull(targetSymbol, "targetSymbol is null");
        }

        public PlanNode getTargetNode() {
            return this.targetNode;
        }

        public Symbol getSourceSymbol() {
            return this.sourceSymbol;
        }

        public Symbol getTargetSymbol() {
            return this.targetSymbol;
        }
    }

    private static class Builder
    extends PlanVisitor<JoinGraph, Context> {
        private final boolean shallow;
        private final Lookup lookup;

        private Builder(boolean shallow, Lookup lookup) {
            this.shallow = shallow;
            this.lookup = Objects.requireNonNull(lookup, "lookup cannot be null");
        }

        @Override
        protected JoinGraph visitPlan(PlanNode node, Context context) {
            if (!this.shallow) {
                for (PlanNode child : node.getSources()) {
                    JoinGraph graph = child.accept(this, context);
                    if (graph.size() < 2) continue;
                    context.addSubGraph(graph.withRootId(child.getId()));
                }
            }
            for (Symbol symbol : node.getOutputSymbols()) {
                context.setSymbolSource(symbol, node);
            }
            return new JoinGraph(node);
        }

        @Override
        public JoinGraph visitFilter(FilterNode node, Context context) {
            JoinGraph graph = node.getSource().accept(this, context);
            return graph.withFilter(node.getPredicate());
        }

        @Override
        public JoinGraph visitJoin(JoinNode node, Context context) {
            if (node.getType() != JoinNode.Type.INNER) {
                return this.visitPlan((PlanNode)node, context);
            }
            JoinGraph left = node.getLeft().accept(this, context);
            JoinGraph right = node.getRight().accept(this, context);
            JoinGraph graph = left.joinWith(right, node.getCriteria(), context, node.getId());
            if (node.getFilter().isPresent()) {
                return graph.withFilter(node.getFilter().get());
            }
            return graph;
        }

        @Override
        public JoinGraph visitProject(ProjectNode node, Context context) {
            if (ProjectNodeUtils.isIdentity(node)) {
                JoinGraph graph = node.getSource().accept(this, context);
                return graph.withAssignments(node.getAssignments().getMap());
            }
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public JoinGraph visitGroupReference(GroupReference node, Context context) {
            PlanNode dereferenced = this.lookup.resolve(node);
            JoinGraph graph = dereferenced.accept(this, context);
            if (this.isTrivialGraph(graph)) {
                return this.replacementGraph(dereferenced, node, context);
            }
            return graph;
        }

        private boolean isTrivialGraph(JoinGraph graph) {
            return graph.nodes.size() < 2 && graph.edges.isEmpty() && graph.filters.isEmpty() && !graph.assignments.isPresent();
        }

        private JoinGraph replacementGraph(PlanNode oldNode, PlanNode newNode, Context context) {
            List symbols = (List)context.symbolSources.entrySet().stream().filter(entry -> entry.getValue() == oldNode).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
            symbols.forEach(symbol -> context.symbolSources.put(symbol, newNode));
            return new JoinGraph(newNode);
        }
    }
}

