/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.sql.planner.SymbolsExtractor;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.WindowFrame;
import java.util.Collection;

public final class WindowNodeUtil {
    private WindowNodeUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean dependsOn(WindowNode parent, WindowNode child) {
        if (parent.getPartitionBy().stream().anyMatch(child.getCreatedSymbols()::contains)) return true;
        if (parent.getOrderingScheme().isPresent()) {
            if (parent.getOrderingScheme().get().getOrderBy().stream().anyMatch(child.getCreatedSymbols()::contains)) return true;
        }
        if (!parent.getWindowFunctions().values().stream().map(WindowNode.Function::getFunctionCall).map(SymbolsExtractor::extractUnique).flatMap(Collection::stream).anyMatch(child.getCreatedSymbols()::contains)) return false;
        return true;
    }

    public static WindowNode.Frame.WindowType toWindowType(WindowFrame.Type type) {
        switch (type) {
            case RANGE: {
                return WindowNode.Frame.WindowType.RANGE;
            }
            case ROWS: {
                return WindowNode.Frame.WindowType.ROWS;
            }
        }
        throw new UnsupportedOperationException(String.format("unrecognized window frame type %s", type));
    }

    public static WindowNode.Frame.BoundType toBoundType(FrameBound.Type type) {
        switch (type) {
            case UNBOUNDED_PRECEDING: {
                return WindowNode.Frame.BoundType.UNBOUNDED_PRECEDING;
            }
            case PRECEDING: {
                return WindowNode.Frame.BoundType.PRECEDING;
            }
            case CURRENT_ROW: {
                return WindowNode.Frame.BoundType.CURRENT_ROW;
            }
            case FOLLOWING: {
                return WindowNode.Frame.BoundType.FOLLOWING;
            }
            case UNBOUNDED_FOLLOWING: {
                return WindowNode.Frame.BoundType.UNBOUNDED_FOLLOWING;
            }
        }
        throw new UnsupportedOperationException(String.format("unrecognized frame bound type %s", type));
    }
}

