/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.NodeRef;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TranslateExpressions {
    private final Metadata metadata;
    private final SqlParser sqlParser;

    public TranslateExpressions(Metadata metadata, SqlParser sqlParser) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParseris null");
    }

    public Set<Rule<?>> rules() {
        return ImmutableSet.of((Object)new ValuesExpressionTranslation());
    }

    private RowExpression toRowExpression(Expression expression, Rule.Context context, Map<Symbol, Integer> sourceLayout) {
        Map<NodeRef<Expression>, Type> types = ExpressionAnalyzer.getExpressionTypes(context.getSession(), this.metadata, this.sqlParser, context.getSymbolAllocator().getTypes(), (Iterable<Expression>)ImmutableList.of((Object)expression), (List<Expression>)ImmutableList.of(), WarningCollector.NOOP, false);
        return SqlToRowExpressionTranslator.translate(expression, types, sourceLayout, this.metadata.getFunctionManager(), this.metadata.getTypeManager(), context.getSession(), false);
    }

    private final class ValuesExpressionTranslation
    implements Rule<ValuesNode> {
        private ValuesExpressionTranslation() {
        }

        @Override
        public Pattern<ValuesNode> getPattern() {
            return Patterns.values();
        }

        @Override
        public Rule.Result apply(ValuesNode valuesNode, Captures captures, Rule.Context context) {
            boolean anyRewritten = false;
            ImmutableList.Builder rows = ImmutableList.builder();
            for (List<RowExpression> row : valuesNode.getRows()) {
                ImmutableList.Builder newRow = ImmutableList.builder();
                for (RowExpression rowExpression : row) {
                    if (OriginalExpressionUtils.isExpression(rowExpression)) {
                        Expression expression = OriginalExpressionUtils.castToExpression(rowExpression);
                        RowExpression rewritten = TranslateExpressions.this.toRowExpression(expression, context, (Map)ImmutableMap.of());
                        anyRewritten = true;
                        newRow.add((Object)rewritten);
                        continue;
                    }
                    newRow.add((Object)rowExpression);
                }
                rows.add((Object)newRow.build());
            }
            if (anyRewritten) {
                return Rule.Result.ofPlanNode(new ValuesNode(valuesNode.getId(), valuesNode.getOutputSymbols(), (List<List<RowExpression>>)rows.build()));
            }
            return Rule.Result.empty();
        }
    }
}

